/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientGetData;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelGet;
import org.epics.pvaccess.client.ChannelGetRequester;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;
import org.epics.pvdata.pv.Structure;

public class PvaClientGet
implements ChannelGetRequester {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private final PvaClient pvaClient;
    private final Channel channel;
    private final PVStructure pvRequest;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitForConnect = this.lock.newCondition();
    private final Condition waitForGet = this.lock.newCondition();
    private PvaClientGetData pvaClientData = null;
    private volatile boolean isDestroyed = false;
    private volatile Status channelGetConnectStatus = statusCreate.getStatusOK();
    private volatile Status channelGetStatus = statusCreate.getStatusOK();
    private volatile ChannelGet channelGet = null;
    private volatile GetConnectState connectState = GetConnectState.connectIdle;
    private volatile GetState getState = GetState.getIdle;

    static PvaClientGet create(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        return new PvaClientGet(pvaClient, channel, pvRequest);
    }

    private PvaClientGet(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        this.pvaClient = pvaClient;
        this.channel = channel;
        this.pvRequest = pvRequest;
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientGet::PvaClientGet channelName " + channel.getChannelName());
        }
    }

    private void checkGetState() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientGet was destroyed");
        }
        if (this.connectState == GetConnectState.connectIdle) {
            this.connect();
        }
        if (this.getState == GetState.getIdle) {
            this.get();
        }
    }

    public String getRequesterName() {
        return this.pvaClient.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        this.pvaClient.message(message, messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelGetConnect(Status status, ChannelGet channelGet, Structure structure) {
        if (this.isDestroyed) {
            return;
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientGet::channelGetConnect channelName " + this.channel.getChannelName() + " status " + status);
            }
            this.channelGetConnectStatus = status;
            this.connectState = GetConnectState.connected;
            this.channelGet = channelGet;
            if (status.isOK()) {
                this.pvaClientData = PvaClientGetData.create(structure);
                this.pvaClientData.setMessagePrefix(this.channel.getChannelName());
            }
            this.waitForConnect.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDone(Status status, ChannelGet channelGet, PVStructure pvStructure, BitSet bitSet) {
        if (this.isDestroyed) {
            return;
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientGet::getDone channelName " + this.channel.getChannelName() + " status " + status);
            }
            this.channelGetStatus = status;
            this.getState = GetState.getComplete;
            if (status.isOK()) {
                this.pvaClientData.setData(pvStructure, bitSet);
            }
            this.waitForGet.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientGet::destroy channelName " + this.channel.getChannelName());
        }
        PvaClientGet pvaClientGet = this;
        synchronized (pvaClientGet) {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        if (this.channelGet != null) {
            this.channelGet.destroy();
        }
        if (this.pvaClientData != null) {
            this.pvaClientData = null;
        }
    }

    public void connect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientGet was destroyed");
        }
        this.issueConnect();
        Status status = this.waitConnect();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientGet::connect " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientGet was destroyed");
        }
        if (this.connectState != GetConnectState.connectIdle) {
            String message = "channel " + this.channel.getChannelName() + " pvaClientGet already connected ";
            throw new RuntimeException(message);
        }
        this.connectState = GetConnectState.connectActive;
        this.channelGet = this.channel.createChannelGet((ChannelGetRequester)this, this.pvRequest);
    }

    public Status waitConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientGet was destroyed");
        }
        this.lock.lock();
        try {
            if (this.connectState == GetConnectState.connected) {
                if (!this.channelGetConnectStatus.isOK()) {
                    this.connectState = GetConnectState.connectIdle;
                }
                Status status = this.channelGetConnectStatus;
                return status;
            }
            if (this.connectState != GetConnectState.connectActive) {
                String message = "channel " + this.channel.getChannelName() + " pvaClientGet::waitConnect illegal connect state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForConnect.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            if (!this.channelGetConnectStatus.isOK()) {
                this.connectState = GetConnectState.connectIdle;
            }
            Status status = this.channelGetConnectStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void get() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientGet was destroyed");
        }
        this.issueGet();
        Status status = this.waitGet();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + "PvaClientGet::get " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueGet() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientGet was destroyed");
        }
        if (this.connectState == GetConnectState.connectIdle) {
            this.connect();
        }
        if (this.getState == GetState.getActive) {
            String message = "channel " + this.channel.getChannelName() + " PvaClientGet::issueGet get aleady active ";
            throw new RuntimeException(message);
        }
        this.getState = GetState.getActive;
        this.channelGet.get();
    }

    public Status waitGet() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientGet was destroyed");
        }
        this.lock.lock();
        try {
            if (this.getState == GetState.getComplete) {
                Status status = this.channelGetStatus;
                return status;
            }
            if (this.getState != GetState.getActive) {
                String message = "channel " + this.channel.getChannelName() + " PvaClientGet::waitGet llegal get state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForGet.await();
            }
            catch (InterruptedException e) {
                String message = "channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            this.getState = GetState.getComplete;
            Status status = this.channelGetStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public PvaClientGetData getData() {
        this.checkGetState();
        return this.pvaClientData;
    }

    private static enum GetState {
        getIdle,
        getActive,
        getComplete;

    }

    private static enum GetConnectState {
        connectIdle,
        connectActive,
        connected;

    }
}

