/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientMonitorData;
import org.epics.pvaClient.PvaClientMonitorRequester;
import org.epics.pvaClient.PvaClientUnlistenRequester;
import org.epics.pvaccess.client.Channel;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.monitor.Monitor;
import org.epics.pvdata.monitor.MonitorElement;
import org.epics.pvdata.monitor.MonitorRequester;
import org.epics.pvdata.pv.MessageType;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;
import org.epics.pvdata.pv.Structure;

public class PvaClientMonitor
implements MonitorRequester {
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private final PvaClient pvaClient;
    private final Channel channel;
    private final PVStructure pvRequest;
    private volatile PvaClientMonitorRequester monitorRequester = null;
    private volatile PvaClientUnlistenRequester unlistenRequester = null;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition waitForConnect = this.lock.newCondition();
    private final Condition waitForEvent = this.lock.newCondition();
    private PvaClientMonitorData pvaClientData = null;
    private volatile boolean isDestroyed = false;
    private volatile Status connectStatus = statusCreate.getStatusOK();
    private volatile Monitor monitor = null;
    private volatile MonitorElement monitorElement = null;
    private volatile MonitorConnectState connectState = MonitorConnectState.connectIdle;
    private volatile boolean userPoll = false;
    private volatile boolean userWait = false;

    static PvaClientMonitor create(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        return new PvaClientMonitor(pvaClient, channel, pvRequest);
    }

    private PvaClientMonitor(PvaClient pvaClient, Channel channel, PVStructure pvRequest) {
        this.pvaClient = pvaClient;
        this.channel = channel;
        this.pvRequest = pvRequest;
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientMonitor::PvaClientMonitor");
        }
    }

    private void checkMonitorState() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        if (this.connectState == MonitorConnectState.connectIdle) {
            this.connect();
        }
        if (this.connectState == MonitorConnectState.connected) {
            this.start();
        }
    }

    public String getRequesterName() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        return this.pvaClient.getRequesterName();
    }

    public void message(String message, MessageType messageType) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        this.pvaClient.message(message, messageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorConnect(Status status, Monitor monitor, Structure structure) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        this.lock.lock();
        try {
            this.connectStatus = status;
            this.connectState = MonitorConnectState.connected;
            this.monitor = monitor;
            if (status.isSuccess()) {
                this.pvaClientData = PvaClientMonitorData.create(structure);
                this.pvaClientData.setMessagePrefix(this.channel.getChannelName());
            }
            this.waitForConnect.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void monitorEvent(Monitor monitor) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        this.lock.lock();
        try {
            if (PvaClient.getDebug()) {
                System.out.println("PvaClientMonitor::monitorEvent");
            }
            if (this.monitorRequester != null) {
                this.monitorRequester.event(this);
            }
            if (!this.userWait) {
                return;
            }
            this.waitForEvent.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unlisten(Monitor monitor) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientMonitor::unlisten");
        }
        if (this.unlistenRequester != null) {
            this.unlistenRequester.unlisten(this);
            return;
        }
        String message = "PvaClientMonitor::unlisten called but no requester to receive message";
        System.err.println(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientMonitor::destroy");
        }
        PvaClientMonitor pvaClientMonitor = this;
        synchronized (pvaClientMonitor) {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        if (this.monitor != null) {
            this.monitor.destroy();
        }
        this.monitor = null;
        this.monitorElement = null;
    }

    public void connect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        this.issueConnect();
        Status status = this.waitConnect();
        if (status.isOK()) {
            return;
        }
        String message = "channel " + this.channel.getChannelName() + " PvaClientMonitor::connect " + status.getMessage();
        throw new RuntimeException(message);
    }

    public void issueConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        if (this.connectState != MonitorConnectState.connectIdle) {
            String message = "channel " + this.channel.getChannelName() + " pvaClientMonitor already connected";
            throw new RuntimeException(message);
        }
        this.connectState = MonitorConnectState.connectActive;
        this.monitor = this.channel.createMonitor((MonitorRequester)this, this.pvRequest);
    }

    public Status waitConnect() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        this.lock.lock();
        try {
            if (this.connectState == MonitorConnectState.connected) {
                if (!this.connectStatus.isOK()) {
                    this.connectState = MonitorConnectState.connectIdle;
                }
                Status status = this.connectStatus;
                return status;
            }
            if (this.connectState != MonitorConnectState.connectActive) {
                String message = "channel " + this.channel.getChannelName() + " pvaClientMonitor illegal connect state ";
                throw new RuntimeException(message);
            }
            try {
                this.waitForConnect.await();
            }
            catch (InterruptedException e) {
                String message = "pvaClientMonitor channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            if (!this.connectStatus.isOK()) {
                this.connectState = MonitorConnectState.connectIdle;
            }
            Status status = this.connectStatus;
            return status;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRequester(PvaClientMonitorRequester requester) {
        this.monitorRequester = requester;
    }

    public void setUnlistenRequester(PvaClientUnlistenRequester requester) {
        this.unlistenRequester = requester;
    }

    public void start() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        if (this.connectState == MonitorConnectState.monitorStarted) {
            return;
        }
        if (this.connectState == MonitorConnectState.connectIdle) {
            this.connect();
        }
        if (this.connectState != MonitorConnectState.connected) {
            throw new RuntimeException("PvaClientMonitor::start illegal state");
        }
        this.connectState = MonitorConnectState.monitorStarted;
        this.monitor.start();
    }

    public void stop() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        if (this.connectState != MonitorConnectState.monitorStarted) {
            return;
        }
        this.connectState = MonitorConnectState.connected;
        this.monitor.stop();
    }

    public boolean poll() {
        this.checkMonitorState();
        if (this.connectState != MonitorConnectState.monitorStarted) {
            throw new RuntimeException("PvaClientMonitor::poll illegal state");
        }
        if (this.userPoll) {
            throw new RuntimeException("PvaClientMonitor::poll did not release last ");
        }
        this.monitorElement = this.monitor.poll();
        if (this.monitorElement == null) {
            return false;
        }
        this.userPoll = true;
        this.pvaClientData.setData(this.monitorElement);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitEvent(double secondsToWait) {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        if (this.connectState != MonitorConnectState.monitorStarted) {
            throw new RuntimeException("PvaClientMonitor::waitEvent illegal state");
        }
        this.lock.lock();
        try {
            if (this.poll()) {
                boolean bl = true;
                return bl;
            }
            this.userWait = true;
            try {
                if (secondsToWait == 0.0) {
                    this.waitForEvent.await();
                } else {
                    long nano = (long)(secondsToWait * 1.0E9);
                    this.waitForEvent.awaitNanos(nano);
                }
            }
            catch (InterruptedException e) {
                String message = "pvaClientMonitor::waitEvent channel " + this.channel.getChannelName() + " InterruptedException " + e.getMessage();
                throw new RuntimeException(message);
            }
            this.userWait = false;
            boolean bl = this.poll();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void releaseEvent() {
        if (this.isDestroyed) {
            throw new RuntimeException("pvaClientMonitor was destroyed");
        }
        if (this.connectState != MonitorConnectState.monitorStarted) {
            throw new RuntimeException("PvaClientMonitor::releaseEvent illegal state");
        }
        if (!this.userPoll) {
            throw new RuntimeException("PvaClientMonitor::releaseEvent did not call poll");
        }
        this.userPoll = false;
        this.monitor.release(this.monitorElement);
    }

    public PvaClientMonitorData getData() {
        this.checkMonitorState();
        return this.pvaClientData;
    }

    private static enum MonitorConnectState {
        connectIdle,
        connectActive,
        connected,
        monitorStarted;

    }
}

