/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.monitor.MonitorElement;
import org.epics.pvdata.property.Alarm;
import org.epics.pvdata.property.PVAlarm;
import org.epics.pvdata.property.PVAlarmFactory;
import org.epics.pvdata.property.PVTimeStamp;
import org.epics.pvdata.property.PVTimeStampFactory;
import org.epics.pvdata.property.TimeStamp;
import org.epics.pvdata.property.TimeStampFactory;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.DoubleArrayData;
import org.epics.pvdata.pv.PVArray;
import org.epics.pvdata.pv.PVDouble;
import org.epics.pvdata.pv.PVDoubleArray;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVScalar;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVStringArray;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.StringArrayData;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.Type;

public class PvaClientMonitorData {
    private static final Convert convert = ConvertFactory.getConvert();
    private static final String noStructure = "no pvStructure ";
    private static final String noValue = "no value field";
    private static final String noScalar = "value is not a scalar";
    private static final String notCompatibleScalar = "value is not a compatible scalar";
    private static final String notArray = "value is not an array";
    private static final String notScalarArray = "value is not a scalarArray";
    private static final String notDoubleArray = "value is not a doubleArray";
    private static final String notStringArray = "value is not a stringArray";
    private static final String noAlarm = "no alarm";
    private static final String noTimeStamp = "no timeStamp";
    private final Structure structure;
    private PVStructure pvStructure = null;
    private BitSet changedBitSet = null;
    private BitSet overrunBitSet = null;
    private String messagePrefix = "";
    private PVField pvValue = null;
    private final PVAlarm pvAlarm = PVAlarmFactory.create();
    private final Alarm alarm = new Alarm();
    private final PVTimeStamp pvTimeStamp = PVTimeStampFactory.create();
    private final TimeStamp timeStamp = TimeStampFactory.create();
    private final DoubleArrayData doubleArrayData = new DoubleArrayData();
    private final StringArrayData stringArrayData = new StringArrayData();

    static PvaClientMonitorData create(Structure structure) {
        return new PvaClientMonitorData(structure);
    }

    private PvaClientMonitorData(Structure structure) {
        this.structure = structure;
    }

    void setData(MonitorElement monitorElement) {
        this.pvStructure = monitorElement.getPVStructure();
        this.changedBitSet = monitorElement.getChangedBitSet();
        this.overrunBitSet = monitorElement.getOverrunBitSet();
        this.pvValue = this.pvStructure.getSubField("value");
    }

    private void checkValue() {
        if (this.pvValue != null) {
            return;
        }
        throw new RuntimeException(this.messagePrefix + noValue);
    }

    public void setMessagePrefix(String value) {
        this.messagePrefix = value + " ";
    }

    public Structure getStructure() {
        return this.structure;
    }

    public PVStructure getPVStructure() {
        if (this.pvStructure != null) {
            return this.pvStructure;
        }
        throw new RuntimeException(this.messagePrefix + noStructure);
    }

    public BitSet getChangedBitSet() {
        if (this.changedBitSet != null) {
            return this.changedBitSet;
        }
        throw new RuntimeException(this.messagePrefix + noStructure);
    }

    public BitSet getOverrunBitSet() {
        if (this.overrunBitSet != null) {
            return this.overrunBitSet;
        }
        throw new RuntimeException(this.messagePrefix + noStructure);
    }

    public String showChanged() {
        if (this.changedBitSet == null) {
            throw new RuntimeException(this.messagePrefix + noStructure);
        }
        String result = "";
        int nextSet = this.changedBitSet.nextSetBit(0);
        while (nextSet >= 0) {
            Object pvField = nextSet == 0 ? this.pvStructure : this.pvStructure.getSubField(nextSet);
            result = result + pvField.getFullName() + " = " + pvField + "\n";
            nextSet = this.changedBitSet.nextSetBit(nextSet + 1);
        }
        return result;
    }

    public String showOverrun() {
        if (this.overrunBitSet == null) {
            throw new RuntimeException(this.messagePrefix + noStructure);
        }
        String result = "";
        int nextSet = this.overrunBitSet.nextSetBit(0);
        while (nextSet >= 0) {
            Object pvField = nextSet == 0 ? this.pvStructure : this.pvStructure.getSubField(nextSet);
            result = result + pvField.getFullName() + " = " + pvField + "\n";
            nextSet = this.overrunBitSet.nextSetBit(nextSet + 1);
        }
        return result;
    }

    public boolean hasValue() {
        return this.pvValue != null;
    }

    public boolean isValueScalar() {
        if (this.pvValue == null) {
            return false;
        }
        return this.pvValue.getField().getType() == Type.scalar;
    }

    public boolean isValueScalarArray() {
        if (this.pvValue == null) {
            return false;
        }
        return this.pvValue.getField().getType() == Type.scalarArray;
    }

    public PVField getValue() {
        this.checkValue();
        return this.pvValue;
    }

    public PVScalar getScalarValue() {
        this.checkValue();
        PVScalar pv = (PVScalar)this.pvStructure.getSubField(PVScalar.class, "value");
        if (pv == null) {
            throw new RuntimeException(this.messagePrefix + noScalar);
        }
        return pv;
    }

    public PVArray getArrayValue() {
        this.checkValue();
        PVArray pv = (PVArray)this.pvStructure.getSubField(PVArray.class, "value");
        if (pv == null) {
            throw new RuntimeException(this.messagePrefix + notArray);
        }
        return pv;
    }

    public PVScalarArray getScalarArrayValue() {
        this.checkValue();
        PVScalarArray pv = (PVScalarArray)this.pvStructure.getSubField(PVScalarArray.class, "value");
        if (pv == null) {
            throw new RuntimeException(this.messagePrefix + notScalarArray);
        }
        return pv;
    }

    public double getDouble() {
        PVScalar pvScalar = this.getScalarValue();
        ScalarType scalarType = pvScalar.getScalar().getScalarType();
        if (scalarType == ScalarType.pvDouble) {
            PVDouble pv = (PVDouble)pvScalar;
            return pv.get();
        }
        if (!scalarType.isNumeric()) {
            throw new RuntimeException(this.messagePrefix + notCompatibleScalar);
        }
        return convert.toDouble(pvScalar);
    }

    public String getString() {
        PVScalar pvScalar = this.getScalarValue();
        return convert.toString(pvScalar);
    }

    public double[] getDoubleArray() {
        this.checkValue();
        PVDoubleArray pvDoubleArray = (PVDoubleArray)this.pvStructure.getSubField(PVDoubleArray.class, "value");
        if (pvDoubleArray == null) {
            throw new RuntimeException(this.messagePrefix + notDoubleArray);
        }
        int length = pvDoubleArray.getLength();
        double[] data = new double[length];
        pvDoubleArray.get(0, length, this.doubleArrayData);
        for (int i = 0; i < length; ++i) {
            data[i] = ((double[])this.doubleArrayData.data)[i];
        }
        return data;
    }

    public String[] getStringArray() {
        this.checkValue();
        PVStringArray pvStringArray = (PVStringArray)this.pvStructure.getSubField(PVStringArray.class, "value");
        if (pvStringArray == null) {
            throw new RuntimeException(this.messagePrefix + notStringArray);
        }
        int length = pvStringArray.getLength();
        String[] data = new String[length];
        pvStringArray.get(0, length, this.stringArrayData);
        for (int i = 0; i < length; ++i) {
            data[i] = ((String[])this.stringArrayData.data)[i];
        }
        return data;
    }

    public int getDoubleArray(double[] value, int length) {
        this.checkValue();
        PVDoubleArray pvDoubleArray = (PVDoubleArray)this.pvStructure.getSubField(PVDoubleArray.class, "value");
        if (pvDoubleArray == null) {
            throw new RuntimeException(this.messagePrefix + notDoubleArray);
        }
        if (pvDoubleArray.getLength() < length) {
            length = pvDoubleArray.getLength();
        }
        pvDoubleArray.get(0, length, this.doubleArrayData);
        for (int i = 0; i < length; ++i) {
            value[i] = ((double[])this.doubleArrayData.data)[i];
        }
        return length;
    }

    public int getStringArray(String[] value, int length) {
        this.checkValue();
        PVStringArray pvStringArray = (PVStringArray)this.pvStructure.getSubField(PVStringArray.class, "value");
        if (pvStringArray == null) {
            throw new RuntimeException(this.messagePrefix + notStringArray);
        }
        if (pvStringArray.getLength() < length) {
            length = pvStringArray.getLength();
        }
        pvStringArray.get(0, length, this.stringArrayData);
        for (int i = 0; i < length; ++i) {
            value[i] = ((String[])this.stringArrayData.data)[i];
        }
        return length;
    }

    public Alarm getAlarm() {
        if (this.pvStructure == null) {
            throw new RuntimeException(this.messagePrefix + noStructure);
        }
        PVStructure pvs = (PVStructure)this.pvStructure.getSubField(PVStructure.class, "alarm");
        if (pvs == null) {
            throw new RuntimeException(this.messagePrefix + noAlarm);
        }
        this.pvAlarm.attach((PVField)pvs);
        if (this.pvAlarm.isAttached()) {
            this.pvAlarm.get(this.alarm);
            this.pvAlarm.detach();
            return this.alarm;
        }
        throw new RuntimeException(this.messagePrefix + noAlarm);
    }

    public TimeStamp getTimeStamp() {
        if (this.pvStructure == null) {
            throw new RuntimeException(this.messagePrefix + noStructure);
        }
        PVStructure pvs = (PVStructure)this.pvStructure.getSubField(PVStructure.class, "timeStamp");
        if (pvs == null) {
            throw new RuntimeException(this.messagePrefix + noTimeStamp);
        }
        this.pvTimeStamp.attach((PVField)pvs);
        if (this.pvTimeStamp.isAttached()) {
            this.pvTimeStamp.get(this.timeStamp);
            this.pvTimeStamp.detach();
            return this.timeStamp;
        }
        throw new RuntimeException(this.messagePrefix + noTimeStamp);
    }
}

