/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientChannel;
import org.epics.pvaClient.PvaClientGet;
import org.epics.pvaClient.PvaClientMultiChannel;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.PVScalar;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Status;

public class PvaClientMultiGetDouble {
    private static final Convert convert = ConvertFactory.getConvert();
    private final PvaClientMultiChannel pvaClientMultiChannel;
    private PvaClientChannel[] pvaClientChannelArray;
    private int nchannel;
    private double[] doubleValue;
    private PvaClientGet[] pvaClientGet;
    boolean isGetConnected = false;
    boolean isDestroyed = false;

    public static PvaClientMultiGetDouble create(PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray) {
        return new PvaClientMultiGetDouble(pvaClientMultiChannel, pvaClientChannelArray);
    }

    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientMultiGetDouble::destroy()");
        }
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        this.pvaClientChannelArray = null;
    }

    public void connect() {
        int i;
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        String request = "value";
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientGet[i] = this.pvaClientChannelArray[i].createGet(request);
            this.pvaClientGet[i].issueConnect();
        }
        for (i = 0; i < this.nchannel; ++i) {
            Status status;
            if (!isConnected[i] || (status = this.pvaClientGet[i].waitConnect()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName();
            message = message + " PvaChannelGet::waitConnect " + status.getMessage();
            throw new RuntimeException(message);
        }
        this.isGetConnected = true;
    }

    public double[] get() {
        int i;
        if (!this.isGetConnected) {
            this.connect();
        }
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientGet[i].issueGet();
        }
        for (i = 0; i < this.nchannel; ++i) {
            Status status;
            if (!isConnected[i] || (status = this.pvaClientGet[i].waitGet()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName();
            message = message + " PvaChannelGet::waitGet " + status.getMessage();
            throw new RuntimeException(message);
        }
        for (i = 0; i < this.nchannel; ++i) {
            if (isConnected[i]) {
                PVStructure pvStructure = this.pvaClientGet[i].getData().getPVStructure();
                this.doubleValue[i] = convert.toDouble((PVScalar)pvStructure.getSubField(PVScalar.class, "value"));
                continue;
            }
            this.doubleValue[i] = Double.NaN;
        }
        return this.doubleValue;
    }

    private PvaClientMultiGetDouble(PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientMultiGetDouble::PvaClientMultiGetDouble()");
        }
        this.pvaClientMultiChannel = pvaClientMultiChannel;
        this.pvaClientChannelArray = pvaClientChannelArray;
        this.nchannel = pvaClientChannelArray.length;
        this.doubleValue = new double[this.nchannel];
        this.pvaClientGet = new PvaClientGet[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            this.pvaClientGet[i] = null;
            this.doubleValue[i] = Double.NaN;
        }
    }
}

