/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientChannel;
import org.epics.pvaClient.PvaClientMonitor;
import org.epics.pvaClient.PvaClientMultiChannel;
import org.epics.pvdata.property.TimeStamp;
import org.epics.pvdata.property.TimeStampFactory;
import org.epics.pvdata.pv.Status;

public class PvaClientMultiMonitorDouble {
    private final PvaClientMultiChannel pvaClientMultiChannel;
    private PvaClientChannel[] pvaClientChannelArray;
    private int nchannel;
    private double[] doubleValue;
    private PvaClientMonitor[] pvaClientMonitor;
    boolean isMonitorConnected = false;
    boolean isDestroyed = false;

    public static PvaClientMultiMonitorDouble create(PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray) {
        return new PvaClientMultiMonitorDouble(pvaClientMultiChannel, pvaClientChannelArray);
    }

    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientMultiMonitorDouble::destroy()");
        }
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        this.pvaClientChannelArray = null;
    }

    public void connect() {
        int i;
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        String request = "value";
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientMonitor[i] = this.pvaClientChannelArray[i].createMonitor(request);
            this.pvaClientMonitor[i].issueConnect();
        }
        for (i = 0; i < this.nchannel; ++i) {
            Status status;
            if (!isConnected[i] || (status = this.pvaClientMonitor[i].waitConnect()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName();
            message = message + " PvaChannelMonitor::waitConnect " + status.getMessage();
            throw new RuntimeException(message);
        }
        this.isMonitorConnected = true;
    }

    public boolean poll() {
        if (!this.isMonitorConnected) {
            this.connect();
            try {
                Thread.sleep(100L);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        boolean result = false;
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        for (int i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i] || !this.pvaClientMonitor[i].poll()) continue;
            this.doubleValue[i] = this.pvaClientMonitor[i].getData().getDouble();
            this.pvaClientMonitor[i].releaseEvent();
            result = true;
        }
        return result;
    }

    public boolean waitEvent(double waitForEvent) {
        double diff;
        if (this.poll()) {
            return true;
        }
        TimeStamp start = TimeStampFactory.create();
        start.getCurrentTime();
        TimeStamp now = TimeStampFactory.create();
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
            if (this.poll()) {
                return true;
            }
            now.getCurrentTime();
        } while (!((diff = start.diff(now, start)) >= waitForEvent));
        return false;
    }

    public double[] get() {
        return this.doubleValue;
    }

    private PvaClientMultiMonitorDouble(PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientMultiMonitorDouble::PvaClientMultiMonitorDouble()");
        }
        this.pvaClientMultiChannel = pvaClientMultiChannel;
        this.pvaClientChannelArray = pvaClientChannelArray;
        this.nchannel = pvaClientChannelArray.length;
        this.doubleValue = new double[this.nchannel];
        this.pvaClientMonitor = new PvaClientMonitor[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            this.pvaClientMonitor[i] = null;
            this.doubleValue[i] = Double.NaN;
        }
    }
}

