/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.ReentrantLock;
import org.epics.nt.NTMultiChannel;
import org.epics.nt.NTMultiChannelBuilder;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientChannel;
import org.epics.pvaClient.PvaClientMultiChannel;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.property.Alarm;
import org.epics.pvdata.property.AlarmSeverity;
import org.epics.pvdata.property.AlarmStatus;
import org.epics.pvdata.property.PVTimeStamp;
import org.epics.pvdata.property.PVTimeStampFactory;
import org.epics.pvdata.property.TimeStamp;
import org.epics.pvdata.property.TimeStampFactory;
import org.epics.pvdata.pv.BooleanArrayData;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.IntArrayData;
import org.epics.pvdata.pv.LongArrayData;
import org.epics.pvdata.pv.PVBooleanArray;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVIntArray;
import org.epics.pvdata.pv.PVLong;
import org.epics.pvdata.pv.PVLongArray;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStringArray;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.PVUnion;
import org.epics.pvdata.pv.PVUnionArray;
import org.epics.pvdata.pv.StringArrayData;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.Union;
import org.epics.pvdata.pv.UnionArrayData;

public class PvaClientNTMultiData {
    private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    private static final Convert convert = ConvertFactory.getConvert();
    private final PvaClientMultiChannel pvaClientMultiChannel;
    private final PvaClientChannel[] pvaClientChannelArray;
    private final int nchannel;
    private final ReentrantLock lock = new ReentrantLock();
    private PVStructure[] topPVStructure;
    private boolean gotAlarm = false;
    private boolean gotTimeStamp = false;
    private boolean isDestroyed = false;
    private Structure ntMultiChannelStructure;
    private PVUnion[] unionValue;
    private UnionArrayData unionArrayData = new UnionArrayData();
    private IntArrayData intArrayData = new IntArrayData();
    private LongArrayData longArrayData = new LongArrayData();
    private StringArrayData stringArrayData = new StringArrayData();
    private BooleanArrayData booleanArrayData = new BooleanArrayData();
    private int[] severity;
    private int[] status;
    private String[] message;
    private long[] secondsPastEpoch;
    private int[] nanoseconds;
    private int[] userTag;
    private Alarm alarm = new Alarm();
    private TimeStamp timeStamp = TimeStampFactory.create();
    private PVTimeStamp pvTimeStamp = PVTimeStampFactory.create();

    public static PvaClientNTMultiData create(Union u, PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray, PVStructure pvRequest) {
        return new PvaClientNTMultiData(u, pvaClientMultiChannel, pvaClientChannelArray, pvRequest);
    }

    private PvaClientNTMultiData(Union u, PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray, PVStructure pvRequest) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientNTMultiData::PvaClientNTMultiData()");
        }
        this.pvaClientMultiChannel = pvaClientMultiChannel;
        this.pvaClientChannelArray = pvaClientChannelArray;
        this.nchannel = pvaClientChannelArray.length;
        PVField pvValue = pvRequest.getSubField("field.value");
        if (pvValue == null) {
            throw new RuntimeException("pvRequest did not specify value");
        }
        this.topPVStructure = new PVStructure[this.nchannel];
        this.unionValue = new PVUnion[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            this.topPVStructure[i] = null;
            this.unionValue[i] = pvDataCreate.createPVUnion(u);
        }
        NTMultiChannelBuilder builder = NTMultiChannel.createBuilder();
        builder.value(u).addIsConnected();
        if (pvRequest.getSubField("field.alarm") != null) {
            this.gotAlarm = true;
            builder.addAlarm();
            builder.addSeverity();
            builder.addStatus();
            builder.addMessage();
            this.severity = new int[this.nchannel];
            this.status = new int[this.nchannel];
            this.message = new String[this.nchannel];
        }
        if (pvRequest.getSubField("field.timeStamp") != null) {
            this.gotTimeStamp = true;
            builder.addTimeStamp();
            builder.addSecondsPastEpoch();
            builder.addNanoseconds();
            builder.addUserTag();
            this.secondsPastEpoch = new long[this.nchannel];
            this.nanoseconds = new int[this.nchannel];
            this.userTag = new int[this.nchannel];
        }
        this.ntMultiChannelStructure = builder.createStructure();
    }

    void setStructure(Structure structure, int index) {
        Field field = structure.getField("value");
        if (field == null) {
            String message = "channel " + this.pvaClientChannelArray[index].getChannel().getChannelName() + " does not have top level value field";
            throw new RuntimeException(message);
        }
    }

    void setPVStructure(PVStructure pvStructure, int index) {
        this.topPVStructure[index] = pvStructure;
    }

    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientNTMultiData::destroy()");
        }
        this.lock.lock();
        try {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        finally {
            this.lock.unlock();
        }
        for (int i = 0; i < this.nchannel; ++i) {
            this.pvaClientChannelArray[i] = null;
            this.topPVStructure[i] = null;
        }
    }

    public int getNumber() {
        return this.nchannel;
    }

    public void startDeltaTime() {
        for (int i = 0; i < this.nchannel; ++i) {
            this.topPVStructure[i] = null;
            if (this.gotAlarm) {
                this.alarm.setSeverity(AlarmSeverity.NONE);
                this.alarm.setStatus(AlarmStatus.NONE);
                this.alarm.setMessage("");
                this.severity[i] = AlarmSeverity.INVALID.ordinal();
                this.status[i] = AlarmStatus.UNDEFINED.ordinal();
                this.message[i] = "not connected";
            }
            if (!this.gotTimeStamp) continue;
            this.timeStamp.getCurrentTime();
            this.secondsPastEpoch[i] = 0L;
            this.nanoseconds[i] = 0;
            this.userTag[i] = 0;
        }
    }

    public void endDeltaTime() {
        for (int i = 0; i < this.nchannel; ++i) {
            PVStructure pvst = this.topPVStructure[i];
            if (pvst == null) {
                this.unionValue[i].set(null);
                continue;
            }
            this.unionValue[i].set(pvst.getSubField("value"));
            if (this.gotAlarm) {
                this.severity[i] = ((PVInt)pvst.getSubField(PVInt.class, "alarm.severity")).get();
                this.status[i] = ((PVInt)pvst.getSubField(PVInt.class, "alarm.status")).get();
                this.message[i] = ((PVString)pvst.getSubField(PVString.class, "alarm.message")).get();
            }
            if (!this.gotTimeStamp) continue;
            this.secondsPastEpoch[i] = ((PVLong)pvst.getSubField(PVLong.class, "timeStamp.secondsPastEpoch")).get();
            this.nanoseconds[i] = ((PVInt)pvst.getSubField(PVInt.class, "timeStamp.nanoseconds")).get();
            this.userTag[i] = ((PVInt)pvst.getSubField(PVInt.class, "timeStamp.userTag")).get();
        }
    }

    public TimeStamp getTimeStamp() {
        this.pvTimeStamp.get(this.timeStamp);
        return this.timeStamp;
    }

    public NTMultiChannel getNTMultiChannel() {
        int i;
        PVStructure pvStructure = pvDataCreate.createPVStructure(this.ntMultiChannelStructure);
        NTMultiChannel ntMultiChannel = NTMultiChannel.wrap((PVStructure)pvStructure);
        convert.fromStringArray((PVScalarArray)ntMultiChannel.getChannelName(), 0, this.nchannel, this.pvaClientMultiChannel.getChannelNames(), 0);
        PVUnion[] val = new PVUnion[this.nchannel];
        for (int i2 = 0; i2 < this.nchannel; ++i2) {
            val[i2] = this.unionValue[i2];
        }
        PVUnionArray array = ntMultiChannel.getValue();
        array.setLength(this.nchannel);
        array.get(0, this.nchannel, this.unionArrayData);
        for (int i3 = 0; i3 < this.nchannel; ++i3) {
            ((PVUnion[])this.unionArrayData.data)[i3] = val[i3];
        }
        boolean[] connected = this.pvaClientMultiChannel.getIsConnected();
        boolean[] isConnected = new boolean[this.nchannel];
        for (int i4 = 0; i4 < this.nchannel; ++i4) {
            isConnected[i4] = connected[i4];
        }
        PVBooleanArray pvBooleanArray = ntMultiChannel.getIsConnected();
        pvBooleanArray.setLength(this.nchannel);
        pvBooleanArray.get(0, this.nchannel, this.booleanArrayData);
        for (int i5 = 0; i5 < this.nchannel; ++i5) {
            ((boolean[])this.booleanArrayData.data)[i5] = isConnected[i5];
        }
        if (this.gotAlarm) {
            int i6;
            int[] sev = new int[this.nchannel];
            for (int i7 = 0; i7 < this.nchannel; ++i7) {
                sev[i7] = this.severity[i7];
            }
            PVIntArray pvIntArray = ntMultiChannel.getSeverity();
            pvIntArray.setLength(this.nchannel);
            pvIntArray.get(0, this.nchannel, this.intArrayData);
            for (int i8 = 0; i8 < this.nchannel; ++i8) {
                ((int[])this.intArrayData.data)[i8] = sev[i8];
            }
            int[] sta = new int[this.nchannel];
            for (i6 = 0; i6 < this.nchannel; ++i6) {
                sta[i6] = this.status[i6];
            }
            pvIntArray = ntMultiChannel.getStatus();
            pvIntArray.setLength(this.nchannel);
            pvIntArray.get(0, this.nchannel, this.intArrayData);
            for (i6 = 0; i6 < this.nchannel; ++i6) {
                ((int[])this.intArrayData.data)[i6] = sev[i6];
            }
            String[] mes = new String[this.nchannel];
            for (int i9 = 0; i9 < this.nchannel; ++i9) {
                mes[i9] = this.message[i9];
            }
            PVStringArray pvStringArray = ntMultiChannel.getMessage();
            pvStringArray.setLength(this.nchannel);
            pvStringArray.get(0, this.nchannel, this.stringArrayData);
            for (i = 0; i < this.nchannel; ++i) {
                ((String[])this.stringArrayData.data)[i] = mes[i];
            }
        }
        if (this.gotTimeStamp) {
            long[] sec = new long[this.nchannel];
            for (int i10 = 0; i10 < this.nchannel; ++i10) {
                sec[i10] = this.secondsPastEpoch[i10];
            }
            PVLongArray pvLongArray = ntMultiChannel.getSecondsPastEpoch();
            pvLongArray.setLength(this.nchannel);
            pvLongArray.get(0, this.nchannel, this.longArrayData);
            for (int i11 = 0; i11 < this.nchannel; ++i11) {
                ((long[])this.longArrayData.data)[i11] = sec[i11];
            }
            int[] nano = new int[this.nchannel];
            for (int i12 = 0; i12 < this.nchannel; ++i12) {
                nano[i12] = this.nanoseconds[i12];
            }
            PVIntArray pvIntArray = ntMultiChannel.getNanoseconds();
            pvIntArray.setLength(this.nchannel);
            pvIntArray.get(0, this.nchannel, this.intArrayData);
            for (int i13 = 0; i13 < this.nchannel; ++i13) {
                ((int[])this.intArrayData.data)[i13] = nano[i13];
            }
            int[] tag = new int[this.nchannel];
            for (i = 0; i < this.nchannel; ++i) {
                tag[i] = this.userTag[i];
            }
            pvIntArray = ntMultiChannel.getUserTag();
            pvIntArray.setLength(this.nchannel);
            pvIntArray.get(0, this.nchannel, this.intArrayData);
            for (i = 0; i < this.nchannel; ++i) {
                ((int[])this.intArrayData.data)[i] = tag[i];
            }
        }
        return ntMultiChannel;
    }
}

