/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaClient;

import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvaClient.PvaClient;
import org.epics.pvaClient.PvaClientChannel;
import org.epics.pvaClient.PvaClientMultiChannel;
import org.epics.pvaClient.PvaClientPut;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.factory.FieldFactory;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.FieldBuilder;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVUnion;
import org.epics.pvdata.pv.Status;

public class PvaClientNTMultiPut {
    private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    private static final FieldCreate fieldCreate = FieldFactory.getFieldCreate();
    private static final Convert convert = ConvertFactory.getConvert();
    private final PvaClientMultiChannel pvaClientMultiChannel;
    private final PvaClientChannel[] pvaClientChannelArray;
    private final int nchannel;
    private final ReentrantLock lock = new ReentrantLock();
    private PVUnion[] unionValue;
    private PVField[] value;
    private PvaClientPut[] pvaClientPut;
    private boolean isConnected = false;
    private boolean isDestroyed = false;

    public static PvaClientNTMultiPut create(PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray) {
        return new PvaClientNTMultiPut(pvaClientMultiChannel, pvaClientChannelArray);
    }

    public void destroy() {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientNTMultiPut::destroy()");
        }
        this.lock.lock();
        try {
            if (this.isDestroyed) {
                return;
            }
            this.isDestroyed = true;
        }
        finally {
            this.lock.unlock();
        }
        for (int i = 0; i < this.nchannel; ++i) {
            this.pvaClientChannelArray[i] = null;
        }
    }

    public void connect() {
        Status status;
        int i;
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientPut[i] = this.pvaClientChannelArray[i].createPut();
            this.pvaClientPut[i].issueConnect();
        }
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i] || (status = this.pvaClientPut[i].waitConnect()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName() + " PvaChannelPut::waitConnect " + status.getMessage();
            throw new RuntimeException(message);
        }
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.pvaClientPut[i].issueGet();
        }
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i] || (status = this.pvaClientPut[i].waitGet()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName() + " PvaChannelPut::waitGet " + status.getMessage();
            throw new RuntimeException(message);
        }
        for (i = 0; i < this.nchannel; ++i) {
            if (!isConnected[i]) continue;
            this.value[i] = this.pvaClientPut[i].getData().getValue();
            FieldBuilder fb = fieldCreate.createFieldBuilder();
            fb.add("value", this.value[i].getField());
            this.unionValue[i] = pvDataCreate.createPVUnion(fb.createUnion());
        }
        this.isConnected = true;
    }

    public PVUnion[] getValues() {
        if (!this.isConnected) {
            this.connect();
        }
        return this.unionValue;
    }

    public void put() {
        if (!this.isConnected) {
            this.connect();
        }
        boolean[] isConnected = this.pvaClientMultiChannel.getIsConnected();
        for (int i = 0; i < this.nchannel; ++i) {
            Status status;
            if (isConnected[i]) {
                convert.copy(this.unionValue[i].get(), this.value[i]);
                this.pvaClientPut[i].issuePut();
            }
            if (!isConnected[i] || (status = this.pvaClientPut[i].waitPut()).isOK()) continue;
            String message = "channel " + this.pvaClientChannelArray[i].getChannelName() + " PvaChannelPut::waitPut " + status.getMessage();
            throw new RuntimeException(message);
        }
    }

    private PvaClientNTMultiPut(PvaClientMultiChannel pvaClientMultiChannel, PvaClientChannel[] pvaClientChannelArray) {
        if (PvaClient.getDebug()) {
            System.out.println("PvaClientNTMultiPut::PvaClientNTMultiPut()");
        }
        this.pvaClientMultiChannel = pvaClientMultiChannel;
        this.pvaClientChannelArray = pvaClientChannelArray;
        this.nchannel = pvaClientChannelArray.length;
        this.unionValue = new PVUnion[this.nchannel];
        this.value = new PVField[this.nchannel];
        this.pvaClientPut = new PvaClientPut[this.nchannel];
        for (int i = 0; i < this.nchannel; ++i) {
            this.unionValue[i] = null;
            this.value[i] = null;
            this.pvaClientPut[i] = null;
        }
    }
}

