/*
 * Decompiled with CFR 0.152.
 */
package org.epics.gpclient.datasource.ca;

import gov.aps.jca.Channel;
import gov.aps.jca.dbr.DBRType;
import java.time.Instant;
import org.epics.gpclient.datasource.ca.CAChannelHandler;
import org.epics.gpclient.datasource.ca.CADataSource;

public class CAConnectionPayload {
    private final CADataSource caDataSource;
    private final Channel channel;
    private final boolean connected;
    private final boolean longString;
    private final DBRType fieldType;
    private final Instant eventTime = Instant.now();

    public CAConnectionPayload(CAChannelHandler channleHandler, Channel channel, CAConnectionPayload previousPayload) {
        this.caDataSource = channleHandler.getCADataSource();
        this.channel = channel;
        this.connected = channel != null && channel.getConnectionState() == Channel.ConnectionState.CONNECTED;
        this.longString = channleHandler.isLongString();
        this.fieldType = channel.getFieldType();
    }

    public CADataSource getCADataSource() {
        return this.caDataSource;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public DBRType getFieldType() {
        return this.fieldType;
    }

    public boolean isChannelConnected() {
        return this.connected;
    }

    public boolean isWriteConnected() {
        return this.isChannelConnected() && this.channel.getWriteAccess();
    }

    public boolean isLongString() {
        return this.longString;
    }

    public Instant getEventTime() {
        return this.eventTime;
    }

    public String toString() {
        return "CAConnection [connected: " + this.isChannelConnected() + " writeConnected: " + this.isWriteConnected() + " channel: " + this.channel + "]";
    }
}

