/*
 * Decompiled with CFR 0.152.
 */
package org.epics.gpclient.datasource.ca.types;

import gov.aps.jca.Channel;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import org.epics.gpclient.ReadCollector;
import org.epics.gpclient.datasource.DataSourceTypeAdapter;
import org.epics.gpclient.datasource.ca.CAConnectionPayload;
import org.epics.gpclient.datasource.ca.CAMessagePayload;

public abstract class CATypeAdapter
implements DataSourceTypeAdapter<CAConnectionPayload, CAMessagePayload> {
    private final Class<?> typeClass;
    private final DBRType epicsValueType;
    private final DBRType epicsMetaType;
    private final Boolean array;

    public CATypeAdapter(Class<?> typeClass, DBRType epicsValueType, DBRType epicsMetaType, Boolean array) {
        this.typeClass = typeClass;
        this.epicsValueType = epicsValueType;
        this.epicsMetaType = epicsMetaType;
        this.array = array;
    }

    public boolean match(ReadCollector<?, ?> cache, CAConnectionPayload connectionPayload) {
        Channel channel = connectionPayload.getChannel();
        if (!cache.getType().isAssignableFrom(this.typeClass)) {
            return false;
        }
        if (!CATypeAdapter.dbrTypeMatch(this.epicsValueType, connectionPayload.getFieldType())) {
            return false;
        }
        if (this.array != null && this.array.booleanValue() && channel.getElementCount() == 1) {
            return false;
        }
        return this.array == null || this.array != false || channel.getElementCount() == 1;
    }

    private static boolean dbrTypeMatch(DBRType aType, DBRType anotherType) {
        if (aType.getClass() == null && anotherType.getClass() != null) {
            return false;
        }
        if (aType.getClass() != null && anotherType.getClass() == null) {
            return false;
        }
        return aType.isBYTE() && anotherType.isBYTE() || aType.isDOUBLE() && anotherType.isDOUBLE() || aType.isENUM() && anotherType.isENUM() || aType.isFLOAT() && anotherType.isFLOAT() || aType.isINT() && anotherType.isINT() || aType.isSHORT() && anotherType.isSHORT() || aType.isSTRING() && anotherType.isSTRING();
    }

    public Object getSubscriptionParameter(ReadCollector<?, ?> cache, CAConnectionPayload connection) {
        throw new UnsupportedOperationException("Not implemented: CAChannelHandler is multiplexed, will not use this method");
    }

    public void updateCache(ReadCollector cache, CAConnectionPayload connection, CAMessagePayload message) {
        Channel channel = connection.getChannel();
        if (this.epicsMetaType != null && message.getMetadata() == null) {
            return;
        }
        if (message.getEvent() == null) {
            return;
        }
        cache.updateValue(this.createValue(message.getEvent().getDBR(), message.getMetadata(), connection));
    }

    public abstract Object createValue(DBR var1, DBR var2, CAConnectionPayload var3);
}

