/*
 * Decompiled with CFR 0.152.
 */
package org.epics.gpclient.datasource.ca.types;

import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBR_CTRL_Double;
import gov.aps.jca.dbr.DBR_LABELS_Enum;
import gov.aps.jca.dbr.DBR_TIME_Byte;
import gov.aps.jca.dbr.DBR_TIME_Double;
import gov.aps.jca.dbr.DBR_TIME_Enum;
import gov.aps.jca.dbr.DBR_TIME_Float;
import gov.aps.jca.dbr.DBR_TIME_Int;
import gov.aps.jca.dbr.DBR_TIME_Short;
import gov.aps.jca.dbr.DBR_TIME_String;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.epics.gpclient.ReadCollector;
import org.epics.gpclient.datasource.ca.CAConnectionPayload;
import org.epics.gpclient.datasource.ca.types.CADataUtils;
import org.epics.gpclient.datasource.ca.types.CATypeAdapter;
import org.epics.gpclient.datasource.ca.types.CATypeAdapterSet;
import org.epics.util.array.ArrayByte;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ArrayFloat;
import org.epics.util.array.ArrayInteger;
import org.epics.util.array.ArrayShort;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.ListByte;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListFloat;
import org.epics.util.array.ListInteger;
import org.epics.util.array.ListShort;
import org.epics.util.stats.Range;
import org.epics.vtype.Alarm;
import org.epics.vtype.Display;
import org.epics.vtype.EnumDisplay;
import org.epics.vtype.Time;
import org.epics.vtype.VByte;
import org.epics.vtype.VByteArray;
import org.epics.vtype.VDouble;
import org.epics.vtype.VDoubleArray;
import org.epics.vtype.VEnum;
import org.epics.vtype.VFloat;
import org.epics.vtype.VFloatArray;
import org.epics.vtype.VInt;
import org.epics.vtype.VIntArray;
import org.epics.vtype.VShort;
import org.epics.vtype.VShortArray;
import org.epics.vtype.VString;
import org.epics.vtype.VStringArray;

public class CAVTypeAdapterSet
implements CATypeAdapterSet {
    static final CATypeAdapter DBRFloatToVFloat = new CATypeAdapter((Class)VFloat.class, DBR_TIME_Float.TYPE, DBR_CTRL_Double.TYPE, (Boolean)false){

        @Override
        public Object createValue(DBR rawMessage, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Float message = (DBR_TIME_Float)rawMessage;
            DBR_CTRL_Double metadata = (DBR_CTRL_Double)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            NumberFormat format = CADataUtils.getFormat((DBR)metadata, connPayload.getCADataSource().isHonorZeroPrecision());
            Display display = Display.of((Range)Range.of((double)metadata.getLowerDispLimit().doubleValue(), (double)metadata.getUpperDispLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerAlarmLimit().doubleValue(), (double)metadata.getUpperAlarmLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerWarningLimit().doubleValue(), (double)metadata.getUpperWarningLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerCtrlLimit().doubleValue(), (double)metadata.getUpperCtrlLimit().doubleValue()), (String)metadata.getUnits(), (NumberFormat)format);
            return VFloat.of((Float)Float.valueOf(message.getFloatValue()[0]), (Alarm)alarm, (Time)timestamp, (Display)display);
        }
    };
    static final CATypeAdapter DBRDoubleToVDouble = new CATypeAdapter((Class)VDouble.class, DBR_TIME_Double.TYPE, DBR_CTRL_Double.TYPE, (Boolean)false){

        @Override
        public Object createValue(DBR rawMessage, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Double message = (DBR_TIME_Double)rawMessage;
            DBR_CTRL_Double metadata = (DBR_CTRL_Double)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            NumberFormat format = CADataUtils.getFormat((DBR)metadata, connPayload.getCADataSource().isHonorZeroPrecision());
            Display display = Display.of((Range)Range.of((double)metadata.getLowerDispLimit().doubleValue(), (double)metadata.getUpperDispLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerAlarmLimit().doubleValue(), (double)metadata.getUpperAlarmLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerWarningLimit().doubleValue(), (double)metadata.getUpperWarningLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerCtrlLimit().doubleValue(), (double)metadata.getUpperCtrlLimit().doubleValue()), (String)metadata.getUnits(), (NumberFormat)format);
            return VDouble.of((Double)message.getDoubleValue()[0], (Alarm)alarm, (Time)timestamp, (Display)display);
        }
    };
    static final CATypeAdapter DBRByteToVByte = new CATypeAdapter((Class)VByte.class, DBR_TIME_Byte.TYPE, DBR_CTRL_Double.TYPE, (Boolean)false){

        public VByte createValue(DBR rawMessage, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Byte message = (DBR_TIME_Byte)rawMessage;
            DBR_CTRL_Double metadata = (DBR_CTRL_Double)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            NumberFormat format = CADataUtils.getFormat((DBR)metadata, connPayload.getCADataSource().isHonorZeroPrecision());
            Display display = Display.of((Range)Range.of((double)metadata.getLowerDispLimit().doubleValue(), (double)metadata.getUpperDispLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerAlarmLimit().doubleValue(), (double)metadata.getUpperAlarmLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerWarningLimit().doubleValue(), (double)metadata.getUpperWarningLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerCtrlLimit().doubleValue(), (double)metadata.getUpperCtrlLimit().doubleValue()), (String)metadata.getUnits(), (NumberFormat)format);
            return VByte.of((Byte)message.getByteValue()[0], (Alarm)alarm, (Time)timestamp, (Display)display);
        }
    };
    static final CATypeAdapter DBRShortToVShort = new CATypeAdapter((Class)VShort.class, DBR_TIME_Short.TYPE, DBR_CTRL_Double.TYPE, (Boolean)false){

        public VShort createValue(DBR rawMessage, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Short message = (DBR_TIME_Short)rawMessage;
            DBR_CTRL_Double metadata = (DBR_CTRL_Double)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            NumberFormat format = CADataUtils.getFormat((DBR)metadata, connPayload.getCADataSource().isHonorZeroPrecision());
            Display display = Display.of((Range)Range.of((double)metadata.getLowerDispLimit().doubleValue(), (double)metadata.getUpperDispLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerAlarmLimit().doubleValue(), (double)metadata.getUpperAlarmLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerWarningLimit().doubleValue(), (double)metadata.getUpperWarningLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerCtrlLimit().doubleValue(), (double)metadata.getUpperCtrlLimit().doubleValue()), (String)metadata.getUnits(), (NumberFormat)format);
            return VShort.of((Short)message.getShortValue()[0], (Alarm)alarm, (Time)timestamp, (Display)display);
        }
    };
    static final CATypeAdapter DBRIntToVInt = new CATypeAdapter((Class)VInt.class, DBR_TIME_Int.TYPE, DBR_CTRL_Double.TYPE, (Boolean)false){

        public VInt createValue(DBR rawMessage, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Int message = (DBR_TIME_Int)rawMessage;
            DBR_CTRL_Double metadata = (DBR_CTRL_Double)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            NumberFormat format = CADataUtils.getFormat((DBR)metadata, connPayload.getCADataSource().isHonorZeroPrecision());
            Display display = Display.of((Range)Range.of((double)metadata.getLowerDispLimit().doubleValue(), (double)metadata.getUpperDispLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerAlarmLimit().doubleValue(), (double)metadata.getUpperAlarmLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerWarningLimit().doubleValue(), (double)metadata.getUpperWarningLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerCtrlLimit().doubleValue(), (double)metadata.getUpperCtrlLimit().doubleValue()), (String)metadata.getUnits(), (NumberFormat)format);
            return VInt.of((Integer)message.getIntValue()[0], (Alarm)alarm, (Time)timestamp, (Display)display);
        }
    };
    static final CATypeAdapter DBRStringToVString = new CATypeAdapter((Class)VString.class, DBR_TIME_String.TYPE, null, (Boolean)false){

        public VString createValue(DBR rawMessage, DBR metadata, CAConnectionPayload connPayload) {
            DBR_TIME_String message = (DBR_TIME_String)rawMessage;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            return VString.of((String)String.valueOf(message.getStringValue()[0]), (Alarm)alarm, (Time)timestamp);
        }
    };
    static final CATypeAdapter DBRByteToVString = new CATypeAdapter((Class)VString.class, DBR_TIME_Byte.TYPE, null, null){

        @Override
        public boolean match(ReadCollector<?, ?> cache, CAConnectionPayload connPayload) {
            if (!connPayload.isLongString()) {
                return false;
            }
            return super.match(cache, connPayload);
        }

        public VString createValue(DBR value, DBR metadata, CAConnectionPayload connPayload) {
            DBR_TIME_String message = (DBR_TIME_String)value;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            return VString.of((String)String.valueOf(message.getStringValue()), (Alarm)alarm, (Time)timestamp);
        }
    };
    static final CATypeAdapter DBREnumToVEnum = new CATypeAdapter((Class)VEnum.class, DBR_TIME_Enum.TYPE, DBR_LABELS_Enum.TYPE, (Boolean)false){

        public VEnum createValue(DBR value, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Enum message = (DBR_TIME_Enum)value;
            DBR_LABELS_Enum metadata = (DBR_LABELS_Enum)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            return VEnum.of((int)message.getEnumValue()[0], (EnumDisplay)EnumDisplay.of((String[])metadata.getLabels()), (Alarm)alarm, (Time)timestamp);
        }
    };
    static final CATypeAdapter DBRFloatToVFloatArray = new CATypeAdapter((Class)VFloatArray.class, DBR_TIME_Float.TYPE, DBR_CTRL_Double.TYPE, (Boolean)true){

        public VFloatArray createValue(DBR value, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Float message = (DBR_TIME_Float)value;
            DBR_CTRL_Double metadata = (DBR_CTRL_Double)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            NumberFormat format = CADataUtils.getFormat((DBR)metadata, connPayload.getCADataSource().isHonorZeroPrecision());
            Display display = Display.of((Range)Range.of((double)metadata.getLowerDispLimit().doubleValue(), (double)metadata.getUpperDispLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerAlarmLimit().doubleValue(), (double)metadata.getUpperAlarmLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerWarningLimit().doubleValue(), (double)metadata.getUpperWarningLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerCtrlLimit().doubleValue(), (double)metadata.getUpperCtrlLimit().doubleValue()), (String)metadata.getUnits(), (NumberFormat)format);
            ArrayFloat data = CollectionNumbers.toListFloat((float[])message.getFloatValue());
            return VFloatArray.of((ListFloat)data, (Alarm)alarm, (Time)timestamp, (Display)display);
        }
    };
    static final CATypeAdapter DBRDoubleToVDoubleArray = new CATypeAdapter((Class)VDoubleArray.class, DBR_TIME_Double.TYPE, DBR_CTRL_Double.TYPE, (Boolean)true){

        public VDoubleArray createValue(DBR value, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Double message = (DBR_TIME_Double)value;
            DBR_CTRL_Double metadata = (DBR_CTRL_Double)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            NumberFormat format = CADataUtils.getFormat((DBR)metadata, connPayload.getCADataSource().isHonorZeroPrecision());
            Display display = Display.of((Range)Range.of((double)metadata.getLowerDispLimit().doubleValue(), (double)metadata.getUpperDispLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerAlarmLimit().doubleValue(), (double)metadata.getUpperAlarmLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerWarningLimit().doubleValue(), (double)metadata.getUpperWarningLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerCtrlLimit().doubleValue(), (double)metadata.getUpperCtrlLimit().doubleValue()), (String)metadata.getUnits(), (NumberFormat)format);
            ArrayDouble data = CollectionNumbers.toListDouble((double[])message.getDoubleValue());
            return VDoubleArray.of((ListDouble)data, (Alarm)alarm, (Time)timestamp, (Display)display);
        }
    };
    static final CATypeAdapter DBRByteToVByteArray = new CATypeAdapter((Class)VByteArray.class, DBR_TIME_Byte.TYPE, DBR_CTRL_Double.TYPE, (Boolean)true){

        @Override
        public boolean match(ReadCollector<?, ?> cache, CAConnectionPayload connPayload) {
            if (connPayload.isLongString()) {
                return false;
            }
            return super.match(cache, connPayload);
        }

        public VByteArray createValue(DBR value, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Byte message = (DBR_TIME_Byte)value;
            DBR_CTRL_Double metadata = (DBR_CTRL_Double)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            NumberFormat format = CADataUtils.getFormat((DBR)metadata, connPayload.getCADataSource().isHonorZeroPrecision());
            Display display = Display.of((Range)Range.of((double)metadata.getLowerDispLimit().doubleValue(), (double)metadata.getUpperDispLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerAlarmLimit().doubleValue(), (double)metadata.getUpperAlarmLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerWarningLimit().doubleValue(), (double)metadata.getUpperWarningLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerCtrlLimit().doubleValue(), (double)metadata.getUpperCtrlLimit().doubleValue()), (String)metadata.getUnits(), (NumberFormat)format);
            ArrayByte data = CollectionNumbers.toListByte((byte[])message.getByteValue());
            return VByteArray.of((ListByte)data, (Alarm)alarm, (Time)timestamp, (Display)display);
        }
    };
    static final CATypeAdapter DBRShortToVShortArray = new CATypeAdapter((Class)VShortArray.class, DBR_TIME_Short.TYPE, DBR_CTRL_Double.TYPE, (Boolean)true){

        public VShortArray createValue(DBR value, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Short message = (DBR_TIME_Short)value;
            DBR_CTRL_Double metadata = (DBR_CTRL_Double)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            NumberFormat format = CADataUtils.getFormat((DBR)metadata, connPayload.getCADataSource().isHonorZeroPrecision());
            Display display = Display.of((Range)Range.of((double)metadata.getLowerDispLimit().doubleValue(), (double)metadata.getUpperDispLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerAlarmLimit().doubleValue(), (double)metadata.getUpperAlarmLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerWarningLimit().doubleValue(), (double)metadata.getUpperWarningLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerCtrlLimit().doubleValue(), (double)metadata.getUpperCtrlLimit().doubleValue()), (String)metadata.getUnits(), (NumberFormat)format);
            ArrayShort data = CollectionNumbers.toListShort((short[])message.getShortValue());
            return VShortArray.of((ListShort)data, (Alarm)alarm, (Time)timestamp, (Display)display);
        }
    };
    static final CATypeAdapter DBRIntToVIntArray = new CATypeAdapter((Class)VIntArray.class, DBR_TIME_Int.TYPE, DBR_CTRL_Double.TYPE, (Boolean)true){

        public VIntArray createValue(DBR value, DBR rawMetadata, CAConnectionPayload connPayload) {
            DBR_TIME_Int message = (DBR_TIME_Int)value;
            DBR_CTRL_Double metadata = (DBR_CTRL_Double)rawMetadata;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            NumberFormat format = CADataUtils.getFormat((DBR)metadata, connPayload.getCADataSource().isHonorZeroPrecision());
            Display display = Display.of((Range)Range.of((double)metadata.getLowerDispLimit().doubleValue(), (double)metadata.getUpperDispLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerAlarmLimit().doubleValue(), (double)metadata.getUpperAlarmLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerWarningLimit().doubleValue(), (double)metadata.getUpperWarningLimit().doubleValue()), (Range)Range.of((double)metadata.getLowerCtrlLimit().doubleValue(), (double)metadata.getUpperCtrlLimit().doubleValue()), (String)metadata.getUnits(), (NumberFormat)format);
            ArrayInteger data = CollectionNumbers.toListInt((int[])message.getIntValue());
            return VIntArray.of((ListInteger)data, (Alarm)alarm, (Time)timestamp, (Display)display);
        }
    };
    static final CATypeAdapter DBRStringToVStringArray = new CATypeAdapter((Class)VStringArray.class, DBR_TIME_String.TYPE, null, (Boolean)true){

        public VStringArray createValue(DBR rawMessage, DBR metadata, CAConnectionPayload connPayload) {
            DBR_TIME_String message = (DBR_TIME_String)rawMessage;
            Alarm alarm = !connPayload.isChannelConnected() ? Alarm.disconnected() : CADataUtils.fromEpics(message.getSeverity());
            Time timestamp = !connPayload.isChannelConnected() ? Time.of((Instant)connPayload.getEventTime()) : CADataUtils.timestampOf(message.getTimeStamp());
            return VStringArray.of(Arrays.asList(message.getStringValue()), (Alarm)alarm, (Time)timestamp);
        }
    };
    private static final Set<CATypeAdapter> converters;

    static {
        HashSet<CATypeAdapter> newFactories = new HashSet<CATypeAdapter>();
        newFactories.add(DBRFloatToVFloat);
        newFactories.add(DBRDoubleToVDouble);
        newFactories.add(DBRByteToVByte);
        newFactories.add(DBRShortToVShort);
        newFactories.add(DBRIntToVInt);
        newFactories.add(DBRStringToVString);
        newFactories.add(DBRByteToVString);
        newFactories.add(DBREnumToVEnum);
        newFactories.add(DBRFloatToVFloatArray);
        newFactories.add(DBRDoubleToVDoubleArray);
        newFactories.add(DBRByteToVByteArray);
        newFactories.add(DBRShortToVShortArray);
        newFactories.add(DBRIntToVIntArray);
        newFactories.add(DBRStringToVStringArray);
        converters = Collections.unmodifiableSet(newFactories);
    }

    public Set<CATypeAdapter> getAdapters() {
        return converters;
    }
}

