/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Point2DDatasets;
import org.epics.graphene.profile.ProfileGraph2D;
import org.epics.graphene.profile.image.ShowResizableGraph;
import org.epics.graphene.profile.io.CSVWriter;
import org.epics.graphene.profile.io.DateUtils;
import org.epics.graphene.profile.io.ImageWriter;
import org.epics.graphene.profile.settings.SaveSettings;
import org.epics.graphene.profile.utils.DatasetFactory;
import org.epics.graphene.profile.utils.Resolution;
import org.epics.graphene.profile.utils.Statistics;

public class MultiLevelProfiler {
    private ProfileGraph2D profiler;
    private List<Resolution> resolutions;
    private List<Integer> datasetSizes;
    private Map<Resolution, Map<Integer, Statistics>> results;
    private Map<Resolution, Map<Integer, BufferedImage>> images;

    public MultiLevelProfiler(ProfileGraph2D profiler) {
        this.profiler = profiler;
        this.results = new HashMap<Resolution, Map<Integer, Statistics>>();
        this.images = new HashMap<Resolution, Map<Integer, BufferedImage>>();
    }

    public void profile() {
        if (this.datasetSizes == null || this.datasetSizes.isEmpty()) {
            throw new NullPointerException("Use the setter to list dataset sizes.");
        }
        if (this.resolutions == null || this.resolutions.isEmpty()) {
            throw new NullPointerException("Use the setter to list resolutions.");
        }
        this.processTimeWarning(this.datasetSizes.size() * this.resolutions.size() * this.profiler.getProfileSettings().getTestTime());
        for (int r = 0; r < this.resolutions.size() && !Thread.currentThread().isInterrupted(); ++r) {
            HashMap<Integer, Statistics> map = new HashMap<Integer, Statistics>();
            HashMap<Integer, BufferedImage> imageMap = new HashMap<Integer, BufferedImage>();
            for (int s = 0; s < this.datasetSizes.size() && !Thread.currentThread().isInterrupted(); ++s) {
                this.processPreResult(this.resolutions.get(r), this.datasetSizes.get(s));
                this.profiler.setNumDataPoints(this.datasetSizes.get(s));
                this.profiler.getResolution().setWidth(this.resolutions.get(r).getWidth());
                this.profiler.getResolution().setHeight(this.resolutions.get(r).getHeight());
                this.profiler.profile();
                map.put(this.datasetSizes.get(s), this.profiler.getStatistics());
                imageMap.put(this.datasetSizes.get(s), this.profiler.getSaveSettings().getSaveImage());
                this.processResult(this.resolutions.get(r), this.datasetSizes.get(s), this.profiler.getStatistics());
            }
            this.results.put(this.resolutions.get(r), map);
            this.images.put(this.resolutions.get(r), imageMap);
        }
    }

    public Map<Resolution, Map<Integer, Statistics>> getResults() {
        if (this.results == null) {
            throw new NullPointerException("Profiling has not been run.");
        }
        return this.results;
    }

    public List<Point2DDataset> getStatisticLineData() {
        ArrayList<Point2DDataset> allLines = new ArrayList<Point2DDataset>();
        Object[] resolutionKeys = this.results.keySet().toArray();
        for (int i = 0; i < this.results.size(); ++i) {
            Resolution resolution = (Resolution)resolutionKeys[i];
            Map<Integer, Statistics> map = this.results.get(resolution);
            Object[] sizeKeys = map.keySet().toArray();
            double[] sizes = new double[map.size()];
            double[] times = new double[map.size()];
            for (int j = 0; j < map.size(); ++j) {
                Integer size = (Integer)sizeKeys[j];
                Statistics stats = map.get(size);
                sizes[j] = size.intValue();
                times[j] = stats.getAverageTime();
            }
            Point2DDataset data = Point2DDatasets.lineData((double[])sizes, (double[])times);
            allLines.add(data);
        }
        return allLines;
    }

    public void graphStatistics() {
        if (this.results == null) {
            throw new NullPointerException("Profiling has not been run.");
        }
        List<Point2DDataset> lines = this.getStatisticLineData();
        for (Point2DDataset data : lines) {
            ShowResizableGraph.showLineGraph(data);
        }
    }

    public void saveStatistics() {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.results == null) {
            throw new NullPointerException("Profiling has not been run.");
        }
        if (this.results.isEmpty()) {
            return;
        }
        Object[] resKeys = this.results.keySet().toArray(new Resolution[0]);
        Object[] sizeKeys = this.results.get(resKeys[0]).keySet().toArray(new Integer[0]);
        ArrayList<List> data = new ArrayList<List>();
        Arrays.sort(resKeys);
        Arrays.sort(sizeKeys);
        for (int i = 0; i < sizeKeys.length; ++i) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(sizeKeys[i]);
            for (int j = 0; j < resKeys.length; ++j) {
                row.add(String.format("%.3f", this.results.get(resKeys[j]).get(sizeKeys[i]).getAverageTime()));
            }
            data.add(row);
        }
        String filename = "ProfileResults\\" + DateUtils.getDate(DateUtils.DateFormat.NONDELIMITED) + "-" + this.profiler.getGraphTitle() + "-" + "Table2D";
        File output = CSVWriter.createFile(filename);
        CSVWriter.writeRow(output, CSVWriter.arrayCombine("", resKeys));
        CSVWriter.writeData(output, data);
        this.saveAdditionalInfo(filename);
    }

    private void saveAdditionalInfo(String filename) {
        File output = CSVWriter.createFile(filename + ".out");
        CSVWriter.writeRow(output, CSVWriter.arrayCombine("Graph Type", "Date", this.profiler.getProfileSettings().getTitle(), this.profiler.getRenderSettings().getTitle(), this.profiler.getSaveSettings().getTitle()));
        CSVWriter.writeRow(output, CSVWriter.arrayCombine(this.profiler.getGraphTitle(), DateUtils.getDate(DateUtils.DateFormat.DELIMITED), this.profiler.getProfileSettings().getOutput(), this.profiler.getRenderSettings().getOutput(), this.profiler.getSaveSettings().getOutput()));
    }

    public void saveImages() {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.images == null) {
            throw new NullPointerException("Profiling has not been run.");
        }
        if (this.images.isEmpty()) {
            return;
        }
        String path = "ProfileResults\\" + DateUtils.getDate(DateUtils.DateFormat.NONDELIMITED) + "-" + this.profiler.getGraphTitle() + "-" + "Table2D";
        boolean success = new File(path).mkdir();
        if (!success) {
            return;
        }
        Object[] resKeys = this.images.keySet().toArray(new Resolution[0]);
        Object[] sizeKeys = this.images.get(resKeys[0]).keySet().toArray(new Integer[0]);
        Arrays.sort(resKeys);
        Arrays.sort(sizeKeys);
        for (int i = 0; i < sizeKeys.length; ++i) {
            for (int j = 0; j < resKeys.length; ++j) {
                BufferedImage img = this.images.get(resKeys[j]).get(sizeKeys[i]);
                String name = ((Resolution)resKeys[j]).toString() + "." + ((Integer)sizeKeys[i]).toString();
                ImageWriter.saveImage(path + "/", name, img);
            }
        }
    }

    public void processTimeWarning(int estimatedTime) {
        System.out.println("The estimated run time is " + estimatedTime + " seconds.");
    }

    public void processPreResult(Resolution resolution, int datasetSize) {
        System.out.print(resolution + ": " + datasetSize + ": ");
    }

    public void processResult(Resolution resolution, int datasetSize, Statistics stats) {
        System.out.println(stats.getAverageTime() + "ms");
    }

    public void setImageSizes(List<Resolution> resolutions) {
        if (resolutions == null) {
            throw new IllegalArgumentException("The list of image resolutions must be non-null.");
        }
        if (resolutions.isEmpty()) {
            throw new IllegalArgumentException("The list of image resolutions must be non-empty.");
        }
        this.resolutions = resolutions;
    }

    public void setDatasetSizes(List<Integer> nPoints) {
        if (nPoints == null) {
            throw new IllegalArgumentException("The list of dataset sizes must be non-null.");
        }
        if (nPoints.isEmpty()) {
            throw new IllegalArgumentException("The list of dataset sizes must be non-empty.");
        }
        this.datasetSizes = nPoints;
    }

    public SaveSettings getSaveSettings() {
        return this.profiler.getSaveSettings();
    }

    public static void defaultProfile(ProfileGraph2D profiler) {
        MultiLevelProfiler layer = new MultiLevelProfiler(profiler);
        layer.setImageSizes(Resolution.defaultResolutions());
        layer.setDatasetSizes(DatasetFactory.defaultDatasetSizes());
        layer.profile();
        layer.graphStatistics();
        layer.saveStatistics();
    }
}

