/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile;

import java.io.File;
import java.util.List;
import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.Cell1DDatasets;
import org.epics.graphene.Point1DDataset;
import org.epics.graphene.Point1DDatasets;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Point2DDatasets;
import org.epics.graphene.profile.image.ShowResizableGraph;
import org.epics.graphene.profile.io.CSVWriter;
import org.epics.graphene.profile.settings.ProfileSettings;
import org.epics.graphene.profile.utils.Statistics;
import org.epics.graphene.profile.utils.StopWatch;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListLong;
import org.epics.util.array.ListMath;
import org.epics.util.array.ListNumber;
import org.epics.util.time.TimeDuration;
import org.epics.util.time.Timestamp;

public abstract class Profiler {
    protected int nTries = 0;
    protected StopWatch stopWatch;
    private ProfileSettings profileSettings = new ProfileSettings();

    public void profile() {
        this.preLoopAction();
        this.stopWatch = new StopWatch(this.profileSettings.getMaxTries());
        this.stopWatch.setTimeType(this.profileSettings.getTimeType());
        this.nTries = 0;
        Timestamp start = Timestamp.now();
        Timestamp end = start.plus(TimeDuration.ofSeconds((double)this.profileSettings.getTestTime()));
        while (end.compareTo(Timestamp.now()) >= 0 && !Thread.currentThread().isInterrupted() && this.nTries < this.profileSettings.getMaxTries()) {
            ++this.nTries;
            this.stopWatch.start();
            this.iterationAction();
            this.stopWatch.stop();
            this.postIterationAction();
        }
    }

    protected void preLoopAction() {
    }

    protected abstract void iterationAction();

    protected void postIterationAction() {
    }

    public abstract String getProfileTitle();

    protected void saveStatistics(String fileName, List header, List row) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.stopWatch == null || this.nTries == 0) {
            throw new NullPointerException("Has not been profiled.");
        }
        File output = new File(fileName + ".csv");
        if (!output.exists()) {
            output = CSVWriter.createNewFile(fileName);
            CSVWriter.writeRow(output, header);
        }
        CSVWriter.writeRow(output, row);
    }

    public Statistics getStatistics() {
        if (this.stopWatch == null || this.nTries == 0) {
            throw new NullPointerException("Has not been profiled.");
        }
        return new Statistics(this.nTries, this.stopWatch.getAverageMs(), this.stopWatch.getTotalMs());
    }

    public void printStatistics() {
        Statistics stats = this.getStatistics();
        if (stats != null) {
            System.out.println(this.getProfileTitle());
            stats.printStatistics();
        }
    }

    public void graphStatistics() {
        if (this.stopWatch == null || this.nTries == 0) {
            throw new NullPointerException("Has not been profiled.");
        }
        ListDouble timingsExcludeFirst = ListMath.rescale((ListNumber)ListMath.limit((ListLong)this.stopWatch.getNanoTimings(), (int)1, (int)this.stopWatch.getNanoTimings().size()), (double)1.0E-6, (double)0.0);
        ListDouble averages = ListMath.rescale((ListNumber)this.stopWatch.getNanoAverages(1), (double)1.0E-6, (double)0.0);
        Point1DDataset timings = Point1DDatasets.of((ListNumber)timingsExcludeFirst);
        Cell1DDataset hist = Cell1DDatasets.createHistogram((Point1DDataset)timings);
        Point2DDataset line = Point2DDatasets.lineData((ListNumber)timingsExcludeFirst);
        Point2DDataset averagedLine = Point2DDatasets.lineData((ListNumber)averages);
        ShowResizableGraph.showHistogram(hist);
        ShowResizableGraph.showLineGraph(line);
        ShowResizableGraph.showLineGraph(averagedLine);
    }

    public ProfileSettings getProfileSettings() {
        return this.profileSettings;
    }
}

