/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.impl;

import java.awt.Graphics2D;
import java.util.LinkedHashMap;
import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.GraphBuffer;
import org.epics.graphene.IntensityGraph2DRenderer;
import org.epics.graphene.IntensityGraph2DRendererUpdate;
import org.epics.graphene.profile.ProfileGraph2D;
import org.epics.graphene.profile.utils.DatasetFactory;

public class ProfileIntensityGraph2D
extends ProfileGraph2D<IntensityGraph2DRenderer, Cell2DDataset> {
    private int numXData = 100;
    private int numYData = 100;
    protected GraphBuffer graphBuffer = null;

    @Override
    public int getNumDataPoints() {
        return this.getNumXDataPoints() * this.getNumYDataPoints();
    }

    public int getNumXDataPoints() {
        return this.numXData;
    }

    public int getNumYDataPoints() {
        return this.numYData;
    }

    @Override
    public void setNumDataPoints(int numData) {
        this.numXData = (int)Math.sqrt(numData);
        this.numYData = (int)Math.sqrt(numData);
        super.setNumDataPoints(this.numXData * this.numYData);
        this.createDatasetMessage();
    }

    public void setNumXDataPoints(int numXData) {
        this.numXData = numXData;
        this.createDatasetMessage();
    }

    public void setNumYDataPoints(int numYData) {
        this.numYData = numYData;
        this.createDatasetMessage();
    }

    public final void createDatasetMessage() {
        super.getSaveSettings().setDatasetMessage(this.getNumXDataPoints() + "x" + this.getNumYDataPoints());
    }

    @Override
    protected void preLoopAction() {
        this.data = this.getDataset();
        this.renderer = this.getRenderer(this.getResolution().getWidth(), this.getResolution().getHeight());
        for (Graph2DRendererUpdate u : this.getRenderSettings().getUpdates()) {
            ((IntensityGraph2DRenderer)this.renderer).update((IntensityGraph2DRendererUpdate)u);
        }
        if (!this.getRenderSettings().getBufferInLoop()) {
            this.graphBuffer = new GraphBuffer(this.renderer);
        }
    }

    @Override
    protected void iterationAction() {
        if (this.getRenderSettings().getBufferInLoop()) {
            this.graphBuffer = new GraphBuffer(this.renderer);
        }
        this.render((Graphics2D)null, (IntensityGraph2DRenderer)this.renderer, (Cell2DDataset)this.data);
    }

    @Override
    protected void render(Graphics2D graphics, IntensityGraph2DRenderer renderer, Cell2DDataset data) {
        renderer.draw(this.graphBuffer, data);
    }

    @Override
    protected Cell2DDataset getDataset() {
        return DatasetFactory.makeCell2DGaussianRandomData(this.getNumXDataPoints(), this.getNumYDataPoints());
    }

    @Override
    protected IntensityGraph2DRenderer getRenderer(int imageWidth, int imageHeight) {
        IntensityGraph2DRenderer renderer = new IntensityGraph2DRenderer(imageWidth, imageHeight);
        return renderer;
    }

    @Override
    public String getGraphTitle() {
        return "IntensityGraph2D";
    }

    @Override
    public LinkedHashMap<String, Graph2DRendererUpdate> getVariations() {
        LinkedHashMap<String, Graph2DRendererUpdate> map = new LinkedHashMap<String, Graph2DRendererUpdate>();
        map.put("None", null);
        map.put("Not Draw Legend", (Graph2DRendererUpdate)new IntensityGraph2DRendererUpdate().drawLegend(false));
        return map;
    }
}

