/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.impl;

import java.awt.Graphics2D;
import java.util.LinkedHashMap;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.LineGraph2DRenderer;
import org.epics.graphene.LineGraph2DRendererUpdate;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.ReductionScheme;
import org.epics.graphene.profile.ProfileGraph2D;
import org.epics.graphene.profile.utils.DatasetFactory;

public class ProfileLineGraph2D
extends ProfileGraph2D<LineGraph2DRenderer, Point2DDataset> {
    @Override
    protected Point2DDataset getDataset() {
        return DatasetFactory.makePoint2DGaussianRandomData(this.getNumDataPoints());
    }

    @Override
    protected LineGraph2DRenderer getRenderer(int imageWidth, int imageHeight) {
        LineGraph2DRenderer renderer = new LineGraph2DRenderer(imageWidth, imageHeight);
        return renderer;
    }

    @Override
    protected void render(Graphics2D graphics, LineGraph2DRenderer renderer, Point2DDataset data) {
        renderer.draw(graphics, data);
    }

    @Override
    public String getGraphTitle() {
        return "LineGraph2D";
    }

    @Override
    public LinkedHashMap<String, Graph2DRendererUpdate> getVariations() {
        LinkedHashMap<String, Graph2DRendererUpdate> map = new LinkedHashMap<String, Graph2DRendererUpdate>();
        map.put("None", null);
        map.put("Linear Interpolation", (Graph2DRendererUpdate)new LineGraph2DRendererUpdate().interpolation(InterpolationScheme.LINEAR));
        map.put("Cubic Interpolation", (Graph2DRendererUpdate)new LineGraph2DRendererUpdate().interpolation(InterpolationScheme.CUBIC));
        map.put("Nearest Neighbor Interpolation", (Graph2DRendererUpdate)new LineGraph2DRendererUpdate().interpolation(InterpolationScheme.NEAREST_NEIGHBOR));
        map.put("First Max Min Last Reduction", (Graph2DRendererUpdate)new LineGraph2DRendererUpdate().dataReduction(ReductionScheme.FIRST_MAX_MIN_LAST));
        map.put("No Data Reduction", (Graph2DRendererUpdate)new LineGraph2DRendererUpdate().dataReduction(ReductionScheme.NONE));
        return map;
    }
}

