/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.impl;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.Cell1DDatasets;
import org.epics.graphene.profile.impl.ProfileHistogram1D;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;

public class ProfileParallelHistogram1D
extends ProfileHistogram1D {
    private static int nThreads = 4;
    private final int nSamples = this.getNumDataPoints();
    private Cell1DDataset dataset;

    public ProfileParallelHistogram1D() {
        this.initDatasets();
    }

    private void initDatasets() {
        Random rand = new Random(1L);
        double[] data = new double[this.nSamples];
        for (int i = 0; i < this.nSamples; ++i) {
            data[i] = rand.nextGaussian();
        }
        this.dataset = Cell1DDatasets.datasetFrom((ListNumber)new ArrayDouble(data), (ListNumber)ListNumbers.linearList((double)0.0, (double)1.0, (int)this.nSamples));
    }

    @Override
    protected final Cell1DDataset getDataset() {
        return this.dataset;
    }

    @Override
    public String getGraphTitle() {
        return "ParallelHistogram1D";
    }

    public static void main(String[] args) {
        ExecutorService executor = Executors.newFixedThreadPool(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ProfileParallelHistogram1D profiler = new ProfileParallelHistogram1D();
                    profiler.profile();
                    System.out.println(profiler.getStatistics().toString());
                }
            });
        }
        executor.shutdown();
    }
}

