/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.utils;

import java.util.ArrayList;
import java.util.List;
import org.epics.graphene.profile.settings.Settings;

public class Resolution
implements Comparable,
Settings {
    public static Resolution RESOLUTION_160x120 = new Resolution(160, 120);
    public static Resolution RESOLUTION_320x240 = new Resolution(320, 240);
    public static Resolution RESOLUTION_640x480 = new Resolution(640, 480);
    public static Resolution RESOLUTION_1024x768 = new Resolution(1024, 768);
    public static Resolution RESOLUTION_1440x1080 = new Resolution(1440, 1080);
    public static Resolution RESOLUTION_1600x1200 = new Resolution(1600, 1200);
    private int width;
    private int height;

    public Resolution(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public final void setWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Width must be a postive non-zero integer.");
        }
        this.width = width;
    }

    public final void setHeight(int height) {
        if (height <= 0) {
            throw new IllegalArgumentException("Height must be a postive non-zero integer.");
        }
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixels() {
        return this.width * this.height;
    }

    public String toString() {
        return this.width + "x" + this.height;
    }

    public int compareTo(Object o) {
        if (o instanceof Resolution) {
            Resolution other = (Resolution)o;
            return Integer.compare(this.getPixels(), other.getPixels());
        }
        return 0;
    }

    public static List<Resolution> defaultResolutions() {
        ArrayList<Resolution> r = new ArrayList<Resolution>();
        r.add(new Resolution(160, 120));
        r.add(new Resolution(320, 240));
        r.add(new Resolution(640, 480));
        r.add(new Resolution(800, 600));
        r.add(new Resolution(1024, 768));
        r.add(new Resolution(1440, 1080));
        r.add(new Resolution(1600, 1200));
        return r;
    }

    @Override
    public Object[] getTitle() {
        return new Object[]{"Image Width", "Image Height"};
    }

    @Override
    public Object[] getOutput() {
        return new Object[]{this.getWidth(), this.getHeight()};
    }
}

