/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.List;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.profile.Profiler;
import org.epics.graphene.profile.io.CSVWriter;
import org.epics.graphene.profile.io.DateUtils;
import org.epics.graphene.profile.io.ImageWriter;
import org.epics.graphene.profile.settings.RenderSettings;
import org.epics.graphene.profile.settings.SaveSettings;
import org.epics.graphene.profile.utils.Resolution;

public abstract class ProfileGraph2D<T extends Graph2DRenderer, S>
extends Profiler {
    public static final String LOG_FILEPATH = "ProfileResults\\";
    private Resolution resolution = new Resolution(600, 400);
    private int nPoints = 1000;
    private RenderSettings renderSettings;
    private SaveSettings saveSettings = new SaveSettings();
    private BufferedImage image = null;
    private Graphics2D graphics = null;
    protected S data = null;
    protected T renderer = null;

    public ProfileGraph2D() {
        this.renderSettings = new RenderSettings(this);
    }

    @Override
    protected void preLoopAction() {
        this.saveSettings.setSaveImage(null);
        this.data = this.getDataset();
        this.renderer = this.getRenderer(this.resolution.getWidth(), this.resolution.getHeight());
        for (Graph2DRendererUpdate u : this.renderSettings.getUpdates()) {
            this.renderer.update(u);
        }
        if (!this.renderSettings.getBufferInLoop()) {
            this.image = new BufferedImage(this.renderer.getImageWidth(), this.renderer.getImageHeight(), 5);
            this.graphics = this.image.createGraphics();
        }
    }

    @Override
    protected void iterationAction() {
        if (this.renderSettings.getBufferInLoop()) {
            this.image = new BufferedImage(this.renderer.getImageWidth(), this.renderer.getImageHeight(), 5);
            this.graphics = this.image.createGraphics();
        }
        this.render(this.graphics, this.renderer, this.data);
    }

    @Override
    protected void postIterationAction() {
        if (this.getSaveSettings().getSaveImage() == null) {
            this.getSaveSettings().setSaveImage(this.image);
        }
        if (this.image != null && this.image.getRGB(0, 0) == 0) {
            System.out.println("Black");
        }
    }

    protected abstract S getDataset();

    protected abstract T getRenderer(int var1, int var2);

    protected abstract void render(Graphics2D var1, T var2, S var3);

    public abstract LinkedHashMap<String, Graph2DRendererUpdate> getVariations();

    public void saveStatistics() {
        String fileName = LOG_FILEPATH + this.getLogFileName();
        List header = CSVWriter.arrayCombine("Graph Type", "Date", this.stopWatch.getTitle(), "Number of Tries", "Number of Data Points", this.resolution.getTitle(), this.getProfileSettings().getTitle(), this.renderSettings.getTitle(), this.saveSettings.getTitle());
        List row = CSVWriter.arrayCombine(this.getGraphTitle(), DateUtils.getDate(DateUtils.DateFormat.DELIMITED), this.stopWatch.getOutput(), this.nTries, this.getNumDataPoints(), this.resolution.getOutput(), this.getProfileSettings().getOutput(), this.renderSettings.getOutput(), this.saveSettings.getOutput());
        super.saveStatistics(fileName, header, row);
    }

    public void saveImage() {
        BufferedImage i = this.getSaveSettings().getSaveImage();
        if (i != null) {
            ImageWriter.saveImage(this.getLogFileName(), i);
        }
    }

    @Override
    public String getProfileTitle() {
        return this.getGraphTitle();
    }

    public abstract String getGraphTitle();

    public String getLogFileName() {
        return this.getGraphTitle() + "-Table1D";
    }

    public SaveSettings getSaveSettings() {
        return this.saveSettings;
    }

    public RenderSettings getRenderSettings() {
        return this.renderSettings;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public int getNumDataPoints() {
        return this.nPoints;
    }

    public void setNumDataPoints(int nPoints) {
        this.nPoints = nPoints;
    }
}

