/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.epics.graphene.LineGraph2DRenderer;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.profile.MultiLevelProfiler;
import org.epics.graphene.profile.ProfileGraph2D;
import org.epics.graphene.profile.impl.ProfileAreaGraph2D;
import org.epics.graphene.profile.impl.ProfileBubbleGraph2D;
import org.epics.graphene.profile.impl.ProfileHistogram1D;
import org.epics.graphene.profile.impl.ProfileIntensityGraph2D;
import org.epics.graphene.profile.impl.ProfileLineGraph2D;
import org.epics.graphene.profile.impl.ProfileMultiYAxisGraph2D;
import org.epics.graphene.profile.impl.ProfileMultilineGraph2D;
import org.epics.graphene.profile.impl.ProfileNLineGraphs2D;
import org.epics.graphene.profile.impl.ProfileScatterGraph2D;
import org.epics.graphene.profile.impl.ProfileSparklineGraph2D;
import org.epics.graphene.profile.io.ImageWriter;
import org.epics.graphene.profile.utils.DatasetFactory;
import org.epics.graphene.profile.utils.Resolution;
import org.epics.graphene.profile.utils.Statistics;
import org.epics.graphene.profile.utils.StopWatch;
import org.epics.util.time.TimeDuration;
import org.epics.util.time.Timestamp;

public final class TestCaseProfiler {
    private TestCaseProfiler() {
    }

    public static void main(String[] args) {
        int invokeType = -1;
        switch (invokeType) {
            case 0: {
                TestCaseProfiler.invokeAll();
                break;
            }
            case 1: {
                TestCaseProfiler.invokeNoRequirements();
                break;
            }
            case 2: {
                TestCaseProfiler.invokeWithRequirements();
                break;
            }
        }
    }

    public static void invokeNoRequirements() {
        Method[] allMethods = TestCaseProfiler.class.getMethods();
        TestCaseProfiler profiler = new TestCaseProfiler();
        for (Method method : allMethods) {
            NoRequires req = method.getAnnotation(NoRequires.class);
            boolean noRequirements = req != null;
            if (TestCaseProfiler.ignoreMethod(method) || !noRequirements) continue;
            try {
                System.out.println("Invoking " + method.getName() + "...");
                method.invoke((Object)profiler, new Object[0]);
                System.out.println("success");
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                System.err.println("Error invoking method: " + method.getName());
                Logger.getLogger(TestCaseProfiler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void invokeWithRequirements() {
        Method[] allMethods = TestCaseProfiler.class.getMethods();
        TestCaseProfiler profiler = new TestCaseProfiler();
        double memoryAvailable = Runtime.getRuntime().maxMemory();
        for (Method method : allMethods) {
            boolean hasRequirements;
            double memoryRequired = -1.0;
            Unit unit = null;
            Requires req = method.getAnnotation(Requires.class);
            if (req != null) {
                memoryRequired = req.memory();
                unit = req.unit();
                hasRequirements = true;
            } else {
                hasRequirements = false;
            }
            if (TestCaseProfiler.ignoreMethod(method) || !hasRequirements || unit == null) continue;
            try {
                if (memoryRequired > Unit.convert(memoryAvailable, unit)) {
                    throw new IllegalArgumentException();
                }
                System.out.print("Invoking " + method.getName() + " (Requirements: " + String.format("%.3f", memoryRequired) + unit.toString() + ")...");
                method.invoke((Object)profiler, new Object[0]);
                System.out.println("success");
            }
            catch (IllegalArgumentException ex) {
                System.err.println("Error invoking method: " + method.getName() + ", " + "Memory Required: " + String.format("%.3f", memoryRequired) + unit.toString() + ", " + "Memory Available: " + String.format("%.3f", Unit.convert(memoryAvailable, unit)) + unit.toString());
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                System.err.println("Error invoking method: " + method.getName());
                Logger.getLogger(TestCaseProfiler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void invokeAll() {
        Method[] allMethods = TestCaseProfiler.class.getMethods();
        TestCaseProfiler profiler = new TestCaseProfiler();
        double memoryAvailable = Runtime.getRuntime().maxMemory();
        for (Method method : allMethods) {
            boolean hasRequirements;
            double memoryRequired = -1.0;
            Unit unit = null;
            Requires req = method.getAnnotation(Requires.class);
            if (req != null) {
                memoryRequired = req.memory();
                unit = req.unit();
                hasRequirements = true;
            } else {
                hasRequirements = false;
            }
            if (TestCaseProfiler.ignoreMethod(method)) continue;
            try {
                if (hasRequirements && unit != null && memoryRequired > Unit.convert(memoryAvailable, unit)) {
                    throw new IllegalArgumentException();
                }
                System.out.print("Invoking " + method.getName() + "...");
                method.invoke((Object)profiler, new Object[0]);
                System.out.println("success");
            }
            catch (IllegalArgumentException ex) {
                if (unit == null) continue;
                System.err.println("Error invoking method: " + method.getName() + ", " + "Memory Required: " + String.format("%.3f", memoryRequired) + unit.toString() + ", " + "Memory Available: " + String.format("%.3f", Unit.convert(memoryAvailable, unit)) + unit.toString() + "...failed");
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                System.err.println("Error invoking method: " + method.getName());
                Logger.getLogger(TestCaseProfiler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static boolean ignoreMethod(Method method) {
        List<String> names = Arrays.asList("main", "TestCaseProfiler", "ignoreMethod");
        boolean isInherited = !method.getDeclaringClass().equals(TestCaseProfiler.class);
        boolean isInvocation = method.getName().contains("invoke");
        boolean isInIgnoreList = names.contains(method.getName());
        return isInherited || isInvocation || isInIgnoreList;
    }

    @NoRequires
    public static void maxDataset1D() {
        ArrayList<ProfileHistogram1D> graphs = new ArrayList<ProfileHistogram1D>();
        graphs.add(new ProfileHistogram1D());
        while (!graphs.isEmpty()) {
            ProfileGraph2D graph = (ProfileGraph2D)graphs.get(0);
            graph.setNumDataPoints((int)Math.pow(10.0, 6.0));
            graph.getResolution().setWidth(600);
            graph.getResolution().setHeight(400);
            graph.getSaveSettings().setSaveMessage("Max Dataset Size Test");
            graph.getSaveSettings().setAuthorMessage("asbarber");
            graph.getProfileSettings().setTestTime(20);
            graph.profile();
            graph.saveStatistics();
            graphs.remove(0);
        }
    }

    @NoRequires
    public static void maxDataset2DPoint() {
        ArrayList<ProfileGraph2D> graphs = new ArrayList<ProfileGraph2D>();
        ArrayList<Integer> size = new ArrayList<Integer>();
        graphs.add(new ProfileLineGraph2D());
        graphs.add(new ProfileScatterGraph2D());
        graphs.add(new ProfileSparklineGraph2D());
        size.add((int)Math.pow(10.0, 6.0));
        size.add((int)Math.pow(10.0, 3.0));
        size.add((int)Math.pow(10.0, 3.0));
        while (!graphs.isEmpty() && !size.isEmpty()) {
            ProfileGraph2D graph = (ProfileGraph2D)graphs.get(0);
            graph.setNumDataPoints((Integer)size.get(0));
            graph.getResolution().setWidth(600);
            graph.getResolution().setHeight(400);
            graph.getSaveSettings().setSaveMessage("Max Dataset Size Test");
            graph.getSaveSettings().setAuthorMessage("asbarber");
            graph.getProfileSettings().setTestTime(20);
            graph.profile();
            graph.saveStatistics();
            graphs.remove(0);
            size.remove(0);
        }
    }

    @NoRequires
    public static void maxDataset3DPoint() {
        ArrayList<ProfileBubbleGraph2D> graphs = new ArrayList<ProfileBubbleGraph2D>();
        ArrayList<Integer> size = new ArrayList<Integer>();
        graphs.add(new ProfileBubbleGraph2D());
        size.add((int)Math.pow(10.0, 6.0));
        while (!graphs.isEmpty() && !size.isEmpty()) {
            ProfileGraph2D graph = (ProfileGraph2D)graphs.get(0);
            graph.setNumDataPoints((Integer)size.get(0));
            graph.getResolution().setWidth(600);
            graph.getResolution().setHeight(400);
            graph.getSaveSettings().setSaveMessage("Max Dataset Size Test");
            graph.getSaveSettings().setAuthorMessage("asbarber");
            graph.getProfileSettings().setTestTime(20);
            graph.profile();
            graph.saveStatistics();
            graphs.remove(0);
            size.remove(0);
        }
    }

    @NoRequires
    public static void maxDataset1DCell() {
        ArrayList<ProfileAreaGraph2D> graphs = new ArrayList<ProfileAreaGraph2D>();
        ArrayList<Integer> size = new ArrayList<Integer>();
        graphs.add(new ProfileAreaGraph2D());
        size.add((int)Math.pow(10.0, 6.0));
        while (!graphs.isEmpty() && !size.isEmpty()) {
            ProfileGraph2D graph = (ProfileGraph2D)graphs.get(0);
            graph.setNumDataPoints((Integer)size.get(0));
            graph.getResolution().setWidth(600);
            graph.getResolution().setHeight(400);
            graph.getSaveSettings().setSaveMessage("Max Dataset Size Test");
            graph.getSaveSettings().setAuthorMessage("asbarber");
            graph.getProfileSettings().setTestTime(20);
            graph.profile();
            graph.saveStatistics();
            graphs.remove(0);
            size.remove(0);
        }
    }

    @NoRequires
    public static void maxDatasetMultiline() {
        int maxLines = 10;
        ProfileMultiYAxisGraph2D multiy = new ProfileMultiYAxisGraph2D();
        ProfileMultilineGraph2D multiline = new ProfileMultilineGraph2D();
        ProfileNLineGraphs2D nline = new ProfileNLineGraphs2D();
        multiy.setNumGraphs(maxLines);
        multiline.setNumGraphs(maxLines);
        nline.setNumGraphs(maxLines);
        ArrayList<ProfileGraph2D> graphs = new ArrayList<ProfileGraph2D>();
        graphs.add(multiy);
        graphs.add(multiline);
        graphs.add(nline);
        while (!graphs.isEmpty()) {
            ((ProfileGraph2D)graphs.get(0)).setNumDataPoints((int)Math.pow(10.0, 6.0));
            ((ProfileGraph2D)graphs.get(0)).getResolution().setWidth(600);
            ((ProfileGraph2D)graphs.get(0)).getResolution().setWidth(400);
            ((ProfileGraph2D)graphs.get(0)).getSaveSettings().setSaveMessage("Max Dataset Size Test");
            ((ProfileGraph2D)graphs.get(0)).getSaveSettings().setAuthorMessage("asbarber");
            ((ProfileGraph2D)graphs.get(0)).getProfileSettings().setTestTime(20);
            ((ProfileGraph2D)graphs.get(0)).profile();
            ((ProfileGraph2D)graphs.get(0)).saveStatistics();
            graphs.remove(0);
        }
    }

    @NoRequires
    public static void renderMethod() {
        RenderMethodProfiler profiler = new RenderMethodProfiler();
        profiler.profileSetPixel();
        profiler.printStatistics();
        System.out.println();
        profiler.profileDrawRect();
        profiler.printStatistics();
        System.out.println();
        profiler.profileByteArray();
        profiler.printStatistics();
    }

    @NoRequires
    public static void lineGraph() {
        ProfileLineGraph2D profiler = new ProfileLineGraph2D();
        profiler.getProfileSettings().setTestTime(2);
        MultiLevelProfiler multi = new MultiLevelProfiler(profiler);
        ArrayList<Point2DDataset> data = new ArrayList<Point2DDataset>();
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        resolutions.add(Resolution.RESOLUTION_640x480);
        multi.setImageSizes(resolutions);
        multi.setDatasetSizes(DatasetFactory.defaultDatasetSizes());
        multi.profile();
        List<Point2DDataset> results = multi.getStatisticLineData();
        assert (results.size() == 1);
        data.add(results.get(0));
        profiler.getRenderSettings().setUpdate("First Max Min Last Reduction");
        multi.profile();
        results = multi.getStatisticLineData();
        assert (results.size() == 1);
        data.add(results.get(0));
        LineGraph2DRenderer graph = new LineGraph2DRenderer(640, 480);
        BufferedImage image = new BufferedImage(640, 480, 5);
        Graphics2D g = (Graphics2D)image.getGraphics();
        graph.draw(g, data);
        ImageWriter.saveImage(profiler.getGraphTitle() + "-Table2D", image);
    }

    @Requires(xmx="-Xmx4g", memory=3.5, unit=Unit.GIGABYTE)
    public static void maxDataset2DCell() {
        ProfileIntensityGraph2D graph = new ProfileIntensityGraph2D();
        graph.setNumXDataPoints(10000);
        graph.setNumYDataPoints(10000);
        graph.getResolution().setWidth(600);
        graph.getResolution().setHeight(400);
        graph.getSaveSettings().setDatasetMessage("10000x10000");
        graph.getSaveSettings().setSaveMessage("Max Dataset Size Test");
        graph.getSaveSettings().setAuthorMessage("asbarber");
        graph.getProfileSettings().setTestTime(20);
        graph.profile();
        graph.saveStatistics();
    }

    private static class RenderMethodProfiler {
        private RenderMethod renderType;
        private int width = 1600;
        private int height = 1200;
        private StopWatch stopWatch;
        private int maxTries = 1000000;
        private int testTimeSec = 20;
        private int nTries = 0;
        private BufferedImage image;
        private Graphics2D graphics;

        public RenderMethodProfiler() {
        }

        public RenderMethodProfiler(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public void profileSetPixel() {
            this.renderType = RenderMethod.SET_PIXEL;
            this.profile();
        }

        public void profileDrawRect() {
            this.renderType = RenderMethod.DRAW_RECT;
            this.profile();
        }

        public void profileByteArray() {
            this.renderType = RenderMethod.BYTE_ARRAY;
            this.profile();
        }

        private void profile() {
            Timestamp start = Timestamp.now();
            Timestamp end = start.plus(TimeDuration.ofSeconds((double)this.testTimeSec));
            this.stopWatch = new StopWatch(this.maxTries);
            this.nTries = 0;
            this.image = new BufferedImage(this.width, this.height, 5);
            this.graphics = this.image.createGraphics();
            double[] data = this.makeData();
            while (end.compareTo(Timestamp.now()) >= 0 && this.nTries < this.maxTries) {
                ++this.nTries;
                this.stopWatch.start();
                if (this.renderType == RenderMethod.SET_PIXEL) {
                    this.doSetPixel(data);
                } else if (this.renderType == RenderMethod.DRAW_RECT) {
                    this.doDrawRect(data);
                } else if (this.renderType == RenderMethod.BYTE_ARRAY) {
                    this.doByteArray(data);
                }
                this.stopWatch.stop();
            }
        }

        private double[] makeData() {
            Random rand = new Random(0L);
            double[] values = new double[this.width * this.height];
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    values[y * this.width + x] = rand.nextDouble();
                }
            }
            return values;
        }

        private void doSetPixel(double[] values) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.image.setRGB(x, y, (int)(255.0 * values[y * this.width + x]));
                }
            }
        }

        private void doDrawRect(double[] values) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    Color color = new Color((int)(255.0 * values[y * this.width + x]));
                    this.graphics.setColor(color);
                    this.graphics.fillRect(x, y, 1, 1);
                    this.image.setRGB(x, y, (int)(255.0 * values[y * this.width + x]));
                }
            }
        }

        private void doByteArray(double[] values) {
            byte[] pixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
            boolean hasAlphaChannel = this.image.getAlphaRaster() != null;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int pixelLength;
                    int index = y * this.width + x;
                    int rgb = (int)(255.0 * values[index]);
                    if (hasAlphaChannel) {
                        pixelLength = 4;
                        ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData()[(index *= 4) + 0] = (byte)(rgb << 24 & 0xFF);
                        ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData()[index + 1] = (byte)(rgb & 0xFF);
                        ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData()[index + 2] = (byte)(rgb << 8 & 0xFF);
                        ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData()[index + 3] = (byte)(rgb << 16 & 0xFF);
                        continue;
                    }
                    pixelLength = 3;
                    ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData()[(index *= 3) + 0] = (byte)(rgb & 0xFF);
                    ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData()[index + 1] = (byte)(rgb << 8 & 0xFF);
                    ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData()[index + 2] = (byte)(rgb << 16 & 0xFF);
                }
            }
        }

        public void saveImage() {
            this.saveImage("");
        }

        public void saveImage(String name) {
            try {
                if (this.image == null) {
                    return;
                }
                String fileName = "ProfileResults\\RenderMethod" + name + ".png";
                ImageIO.write((RenderedImage)this.image, "png", new File(fileName));
            }
            catch (IOException ex) {
                System.out.println("Could not save image.");
                Logger.getLogger(TestCaseProfiler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public Statistics getStatistics() {
            if (this.stopWatch == null || this.nTries == 0) {
                throw new NullPointerException("Has not been profiled.");
            }
            return new Statistics(this.nTries, this.stopWatch.getAverageMs(), this.stopWatch.getTotalMs());
        }

        public void printStatistics() {
            Statistics stats = this.getStatistics();
            if (stats != null) {
                System.out.println(this.getClass().getName());
                System.out.println("Profiled: " + this.getTypeProfiled());
                stats.printStatistics();
            }
        }

        public String getTypeProfiled() {
            if (this.renderType == RenderMethod.SET_PIXEL) {
                return "Set Pixel";
            }
            if (this.renderType == RenderMethod.DRAW_RECT) {
                return "Draw Rect";
            }
            if (this.renderType == RenderMethod.BYTE_ARRAY) {
                return "Byte Array";
            }
            return "";
        }

        private static enum RenderMethod {
            SET_PIXEL,
            DRAW_RECT,
            BYTE_ARRAY;

        }
    }

    private static enum Unit {
        BYTE,
        KILOBYTE,
        MEGABYTE,
        GIGABYTE;


        public String toString() {
            if (this.equals((Object)BYTE)) {
                return "byte";
            }
            if (this.equals((Object)KILOBYTE)) {
                return "kb";
            }
            if (this.equals((Object)MEGABYTE)) {
                return "mb";
            }
            if (this.equals((Object)GIGABYTE)) {
                return "gb";
            }
            return "";
        }

        public double toValue() {
            if (this.equals((Object)BYTE)) {
                return 1.0;
            }
            if (this.equals((Object)KILOBYTE)) {
                return 1024.0;
            }
            if (this.equals((Object)MEGABYTE)) {
                return 1048576.0;
            }
            if (this.equals((Object)GIGABYTE)) {
                return 1.073741824E9;
            }
            return 1.0;
        }

        public static double convert(double value, Unit unit) {
            return value / unit.toValue();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface NoRequires {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Requires {
        public String xmx() default "-Xmx4g";

        public double memory() default 512.0;

        public Unit unit() default Unit.MEGABYTE;
    }
}

