/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.epics.graphene.profile.MultiLevelProfiler;
import org.epics.graphene.profile.ProfileGraph2D;
import org.epics.graphene.profile.impl.ProfileAreaGraph2D;
import org.epics.graphene.profile.impl.ProfileBubbleGraph2D;
import org.epics.graphene.profile.impl.ProfileHistogram1D;
import org.epics.graphene.profile.impl.ProfileIntensityGraph2D;
import org.epics.graphene.profile.impl.ProfileLineGraph2D;
import org.epics.graphene.profile.impl.ProfileMultiYAxisGraph2D;
import org.epics.graphene.profile.impl.ProfileMultilineGraph2D;
import org.epics.graphene.profile.impl.ProfileNLineGraphs2D;
import org.epics.graphene.profile.impl.ProfileScatterGraph2D;
import org.epics.graphene.profile.impl.ProfileSparklineGraph2D;
import org.epics.graphene.profile.io.DateUtils;
import org.epics.graphene.profile.utils.DatasetFactory;
import org.epics.graphene.profile.utils.ProfileAnalysis;
import org.epics.graphene.profile.utils.Resolution;
import org.epics.graphene.profile.utils.Statistics;
import org.epics.graphene.profile.utils.StopWatch;

public class VisualProfiler
extends JPanel {
    private SwingWorker thread;
    private List<JButton> actionButtons;
    private ActionModel model;
    private UserSettings userSettings;
    private JTabbedPane tabs;
    private SettingsPanel settingsPanel;
    private Profile1DTable profile1DTable;
    private Profile2DTable profile2DTable;
    private FileViewer fileViewer;
    private AnalyzePanel analyzePanel;
    private Console console;
    public static final String PROFILE_PATH = "org.epics.graphene.profile.impl";
    public static final String[] SUPPORTED_PROFILERS = new String[]{"AreaGraph2D", "BubbleGraph2D", "Histogram1D", "IntensityGraph2D", "LineGraph2D", "MultiYAxisGraph2D", "MultilineGraph2D", "NLineGraphs2D", "ScatterGraph2D", "SparklineGraph2D"};
    public static final String[] PROTECTED_FILES = new String[]{"ProfileResults", "1D Table Output", "2D Table Output", "Tests", "README.txt"};
    public static final String FRAME_TITLE = "Visual Profiler";

    public static ProfileGraph2D factory(String strClass) {
        switch (strClass) {
            case "AreaGraph2D": {
                return new ProfileAreaGraph2D();
            }
            case "BubbleGraph2D": {
                return new ProfileBubbleGraph2D();
            }
            case "Histogram1D": {
                return new ProfileHistogram1D();
            }
            case "IntensityGraph2D": {
                return new ProfileIntensityGraph2D();
            }
            case "LineGraph2D": {
                return new ProfileLineGraph2D();
            }
            case "MultiYAxisGraph2D": {
                return new ProfileMultiYAxisGraph2D();
            }
            case "MultilineGraph2D": {
                return new ProfileMultilineGraph2D();
            }
            case "NLineGraphs2D": {
                return new ProfileNLineGraphs2D();
            }
            case "ScatterGraph2D": {
                return new ProfileScatterGraph2D();
            }
            case "SparklineGraph2D": {
                return new ProfileSparklineGraph2D();
            }
        }
        return null;
    }

    public VisualProfiler() {
        this.initComponents();
        this.addComponents();
        this.addListeners();
        this.finalizePanel();
    }

    private void initComponents() {
        this.tabs = new JTabbedPane();
        this.actionButtons = new ArrayList<JButton>();
        this.model = new ActionModel();
        this.userSettings = new UserSettings();
        this.settingsPanel = new SettingsPanel();
        this.profile1DTable = new Profile1DTable();
        this.profile2DTable = new Profile2DTable();
        this.analyzePanel = new AnalyzePanel();
        this.fileViewer = new FileViewer();
        this.console = new Console();
    }

    private void addComponents() {
        this.tabs.addTab("Profile 1D Table", this.profile1DTable);
        this.tabs.addTab("Profile 2D Table", this.profile2DTable);
        this.tabs.addTab("Control Panel", this.analyzePanel);
        this.tabs.addTab("File Browser", this.fileViewer);
        JSplitPane top = new JSplitPane(0);
        top.setTopComponent(this.settingsPanel);
        top.setBottomComponent(this.tabs);
        JSplitPane bottom = new JSplitPane(0);
        bottom.setTopComponent(top);
        bottom.setBottomComponent(this.console);
        this.add(bottom);
    }

    private void addListeners() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = e.getSource();
                if (o == ((VisualProfiler)VisualProfiler.this).profile1DTable.btnProfile1D) {
                    VisualProfiler.this.model.profile1D();
                } else if (o == ((VisualProfiler)VisualProfiler.this).profile1DTable.btnProfile1DAll) {
                    VisualProfiler.this.model.profile1DAll();
                } else if (o == ((VisualProfiler)VisualProfiler.this).profile2DTable.btnProfile2D) {
                    VisualProfiler.this.model.profile2D();
                } else if (o == ((VisualProfiler)VisualProfiler.this).analyzePanel.btnCompare2DTables) {
                    VisualProfiler.this.model.compare2DTables();
                } else if (o == ((VisualProfiler)VisualProfiler.this).analyzePanel.btnAnalyze1DTable) {
                    VisualProfiler.this.model.analyze1DTable();
                } else if (o == ((VisualProfiler)VisualProfiler.this).fileViewer.btnOpenFiles) {
                    VisualProfiler.this.model.openFiles();
                } else if (o == ((VisualProfiler)VisualProfiler.this).fileViewer.btnDeleteFiles) {
                    VisualProfiler.this.model.deleteFiles();
                } else if (o == ((VisualProfiler)VisualProfiler.this).fileViewer.btnReloadFiles) {
                    VisualProfiler.this.model.reloadFiles();
                } else if (o == ((VisualProfiler)VisualProfiler.this).console.btnSaveLog) {
                    VisualProfiler.this.model.saveLog();
                } else if (o == ((VisualProfiler)VisualProfiler.this).console.btnClearLog) {
                    VisualProfiler.this.model.clearLog();
                } else if (o == ((VisualProfiler)VisualProfiler.this).console.btnCancelThread) {
                    VisualProfiler.this.model.cancelThread();
                }
            }
        };
        for (JButton button : this.actionButtons) {
            button.addActionListener(listener);
        }
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VisualProfiler.this.model.reloadFiles(true);
            }
        });
        this.settingsPanel.listRendererTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VisualProfiler.this.reloadUpdateVariations();
                }
            }
        });
        this.fileViewer.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = VisualProfiler.this.fileViewer.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = VisualProfiler.this.fileViewer.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() != 1 && e.getClickCount() == 2) {
                    File o = (File)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
                    ArrayList<File> files = new ArrayList<File>();
                    files.add(o);
                    VisualProfiler.this.model.openFiles(files);
                }
            }
        });
    }

    private void finalizePanel() {
        this.setAuthor(this.model.login());
        this.reloadUpdateVariations();
        this.model.reloadFiles(true);
        this.model.startTimer();
    }

    public void setAuthor(String author) {
        this.settingsPanel.txtAuthorMessage.setText(author);
    }

    public void setEnabledActions(boolean enabled) {
        for (JButton button : this.actionButtons) {
            button.setEnabled(enabled);
        }
    }

    public void print(String chunk) {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(chunk);
        this.console.print(tmp);
    }

    public void print(List<String> chunks) {
        this.console.print(chunks);
    }

    public void reloadUpdateVariations() {
        if (this.userSettings.selectedProfiler() == null) {
            return;
        }
        DefaultComboBoxModel<Object> tmp = new DefaultComboBoxModel<Object>(this.userSettings.selectedProfiler().getVariations().keySet().toArray());
        this.settingsPanel.listUpdateTypes.setModel(tmp);
    }

    public static JFrame makeFrame() {
        JFrame frame = new JFrame(FRAME_TITLE);
        frame.add(new VisualProfiler());
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        return frame;
    }

    private JPanel blankPanel(Component itemToAdd) {
        JPanel tmp = new JPanel();
        tmp.add(itemToAdd);
        return tmp;
    }

    public static void invokeVisualAid() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualProfiler.makeFrame();
            }
        });
    }

    public static void main(String[] args) {
        VisualProfiler.invokeVisualAid();
    }

    private class ActionModel {
        private ActionModel() {
        }

        private void startTimer() {
            SwingWorker<Object, String> worker = new SwingWorker<Object, String>(){

                @Override
                protected Object doInBackground() throws Exception {
                    Timer t = new Timer();
                    t.scheduleAtFixedRate(new TimerTask(){

                        @Override
                        public void run() {
                            this.publish(new String[]{this.getTime()});
                        }
                    }, 1000L, 1000L);
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String chunk : chunks) {
                        VisualProfiler.this.console.txtTime.setText(chunk);
                    }
                }

                private String getTime() {
                    int hour = Calendar.getInstance().get(10);
                    int minute = Calendar.getInstance().get(12);
                    int second = Calendar.getInstance().get(13);
                    String format = "%02d";
                    return String.format(format, hour) + ":" + String.format(format, minute) + ":" + String.format(format, second);
                }
            };
            worker.execute();
        }

        private String login() {
            String input = null;
            boolean exit = false;
            String cancelMessage = "Do you want to exit the application?";
            while (!exit) {
                input = JOptionPane.showInputDialog(null, "Username: ", "Login", -1);
                if (input == null || input.equals("")) {
                    int cancel = JOptionPane.showConfirmDialog(null, "Do you want to exit the application?", "Cancel", 0);
                    if (cancel != 0) continue;
                    exit = true;
                    System.exit(0);
                    continue;
                }
                exit = true;
            }
            return input;
        }

        private void profile1D() {
            final ProfileGraph2D profiler = VisualProfiler.this.userSettings.getProfiler();
            SwingWorker<Object, String> worker = new SwingWorker<Object, String>(){

                @Override
                protected Object doInBackground() throws Exception {
                    VisualProfiler.this.setEnabledActions(false);
                    ActionModel.this.threadStart(this);
                    this.publish("--------\n");
                    this.publish(profiler.getGraphTitle() + ": Single Profile\n");
                    this.publish(profiler.getResolution() + ": " + profiler.getNumDataPoints() + ":" + "    ");
                    profiler.profile();
                    this.publish(profiler.getStatistics().getAverageTime() + "ms" + "\n");
                    if (!Thread.currentThread().isInterrupted()) {
                        this.publish("Saving...");
                        profiler.saveStatistics();
                        this.publish("finished.\n");
                        if (VisualProfiler.this.profile1DTable.getShowGraph()) {
                            this.publish("Graphing Results...");
                            profiler.graphStatistics();
                            this.publish("finished.\n");
                        }
                        if (VisualProfiler.this.userSettings.getSaveImage()) {
                            this.publish("Saving Image...");
                            profiler.saveImage();
                            this.publish("finished.\n");
                        }
                        this.publish("\nProfiling completed.\n");
                        this.publish("--------\n");
                    } else {
                        this.publish("\nProfiling cancelled.\n");
                        this.publish("--------\n");
                    }
                    VisualProfiler.this.setEnabledActions(true);
                    ActionModel.this.threadFinish();
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String chunk : chunks) {
                        VisualProfiler.this.print(chunk);
                    }
                }
            };
            worker.execute();
        }

        private void profile1DAll() {
            final ArrayList<ProfileGraph2D> profilers = new ArrayList<ProfileGraph2D>();
            for (int i = 0; i < SUPPORTED_PROFILERS.length; ++i) {
                profilers.add(VisualProfiler.this.userSettings.applySettings(VisualProfiler.this.userSettings.makeProfiler(SUPPORTED_PROFILERS[i])));
            }
            SwingWorker<Object, String> worker = new SwingWorker<Object, String>(){

                @Override
                protected Object doInBackground() throws Exception {
                    VisualProfiler.this.setEnabledActions(false);
                    ActionModel.this.threadStart(this);
                    for (ProfileGraph2D profiler : profilers) {
                        if (Thread.currentThread().isInterrupted()) break;
                        this.publish("--------\n");
                        this.publish(profiler.getGraphTitle() + ": Single Profile\n");
                        this.publish(profiler.getResolution() + ": " + profiler.getNumDataPoints() + ":" + "    ");
                        profiler.profile();
                        this.publish(profiler.getStatistics().getAverageTime() + "ms" + "\n");
                        if (!Thread.currentThread().isInterrupted()) {
                            this.publish("Saving...");
                            profiler.saveStatistics();
                            this.publish("finished.\n");
                            if (VisualProfiler.this.profile1DTable.getShowGraph()) {
                                this.publish("Graphing Results...");
                                profiler.graphStatistics();
                                this.publish("finished.\n");
                            }
                            if (VisualProfiler.this.userSettings.getSaveImage()) {
                                this.publish("Saving Image...");
                                profiler.saveImage();
                                this.publish("finished.\n");
                            }
                            this.publish("\nProfiling completed.\n");
                            this.publish("--------\n");
                            continue;
                        }
                        this.publish("\nProfiling cancelled.\n");
                        this.publish("--------\n");
                    }
                    VisualProfiler.this.setEnabledActions(true);
                    ActionModel.this.threadFinish();
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String chunk : chunks) {
                        VisualProfiler.this.print(chunk);
                    }
                }
            };
            worker.execute();
        }

        private void profile2D() {
            List<Resolution> resolutions = VisualProfiler.this.profile2DTable.listResolutions.getSelectedValuesList();
            List<Integer> datasetSizes = VisualProfiler.this.profile2DTable.listNPoints.getSelectedValuesList();
            ProfileGraph2D profiler = VisualProfiler.this.userSettings.getProfiler();
            if (!resolutions.isEmpty() && !datasetSizes.isEmpty() && VisualProfiler.this.userSettings.getProfiler() != null) {
                Profile2DTableThread worker = new Profile2DTableThread(profiler, resolutions, datasetSizes);
                worker.execute();
            } else {
                JOptionPane.showMessageDialog(null, "Profiling was cancelled due to invalid settings.", "Run Fail", 0);
            }
        }

        private void compare2DTables() {
            SwingWorker<Object, String> worker = new SwingWorker<Object, String>(){

                @Override
                protected Object doInBackground() throws Exception {
                    VisualProfiler.this.setEnabledActions(false);
                    ActionModel.this.threadStart(this);
                    this.publish("--------\n");
                    this.publish("Comparing Tables...");
                    ProfileAnalysis.compareTables2D();
                    this.publish("finished.\n");
                    this.publish("--------\n");
                    VisualProfiler.this.setEnabledActions(true);
                    ActionModel.this.threadFinish();
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String chunk : chunks) {
                        VisualProfiler.this.print(chunk);
                    }
                }
            };
            worker.execute();
        }

        private void analyze1DTable() {
            SwingWorker<Object, String> worker = new SwingWorker<Object, String>(){

                @Override
                protected Object doInBackground() throws Exception {
                    VisualProfiler.this.setEnabledActions(false);
                    ActionModel.this.threadStart(this);
                    this.publish("--------\n");
                    this.publish("Comparing Single Profile Tables\n");
                    List<String> output = ProfileAnalysis.analyzeTables1D();
                    for (String out : output) {
                        this.publish(out + "\n");
                    }
                    this.publish("Comparison completed.\n");
                    this.publish("--------\n");
                    VisualProfiler.this.setEnabledActions(true);
                    ActionModel.this.threadFinish();
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String chunk : chunks) {
                        VisualProfiler.this.print(chunk);
                    }
                }
            };
            worker.execute();
        }

        private void openFiles(final List<File> files) {
            SwingWorker<Object, String> worker = new SwingWorker<Object, String>(){

                @Override
                protected Object doInBackground() throws Exception {
                    VisualProfiler.this.setEnabledActions(false);
                    ActionModel.this.threadStart(this);
                    this.publish("--------\n");
                    this.publish("Opening Files\n");
                    Desktop desktop = Desktop.getDesktop();
                    TreePath[] paths = VisualProfiler.this.fileViewer.tree.getSelectionPaths();
                    if (files != null && desktop != null) {
                        for (File file : files) {
                            if (Thread.currentThread().isInterrupted()) break;
                            if (file == null) continue;
                            try {
                                desktop.open(file);
                                this.publish(file.getName() + "...opened successfully!\n");
                            }
                            catch (IOException e) {
                                this.publish("Unable to open: " + file.getName() + "\n");
                            }
                            catch (ClassCastException e) {}
                        }
                    }
                    if (!Thread.currentThread().isInterrupted()) {
                        this.publish("File operations completed.\n");
                        this.publish("--------\n");
                    } else {
                        this.publish("File operations cancelled.\n");
                        this.publish("--------\n");
                    }
                    VisualProfiler.this.setEnabledActions(true);
                    ActionModel.this.threadFinish();
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String chunk : chunks) {
                        VisualProfiler.this.print(chunk);
                    }
                }
            };
            worker.execute();
        }

        private void openFiles() {
            SwingWorker<Object, String> worker = new SwingWorker<Object, String>(){

                @Override
                protected Object doInBackground() throws Exception {
                    VisualProfiler.this.setEnabledActions(false);
                    ActionModel.this.threadStart(this);
                    this.publish("--------\n");
                    this.publish("Opening Files\n");
                    Desktop desktop = Desktop.getDesktop();
                    TreePath[] paths = VisualProfiler.this.fileViewer.tree.getSelectionPaths();
                    if (paths != null && desktop != null) {
                        for (TreePath path : paths) {
                            if (Thread.currentThread().isInterrupted()) break;
                            if (path == null) continue;
                            try {
                                File toOpen = (File)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                                desktop.open(toOpen);
                                this.publish(toOpen.getName() + "...opened successfully!\n");
                            }
                            catch (IOException e) {
                                this.publish("Unable to open: " + ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() + "\n");
                            }
                            catch (ClassCastException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (!Thread.currentThread().isInterrupted()) {
                        this.publish("File operations completed.\n");
                        this.publish("--------\n");
                    } else {
                        this.publish("File operations cancelled.\n");
                        this.publish("--------\n");
                    }
                    VisualProfiler.this.setEnabledActions(true);
                    ActionModel.this.threadFinish();
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String chunk : chunks) {
                        VisualProfiler.this.print(chunk);
                    }
                }
            };
            worker.execute();
        }

        private void deleteFiles() {
            SwingWorker<Object, String> worker = new SwingWorker<Object, String>(){

                @Override
                protected Object doInBackground() throws Exception {
                    VisualProfiler.this.setEnabledActions(false);
                    ActionModel.this.threadStart(this);
                    this.publish("--------\n");
                    this.publish("Deleting Files\n");
                    TreePath[] paths = VisualProfiler.this.fileViewer.tree.getSelectionPaths();
                    if (paths != null) {
                        for (TreePath path : paths) {
                            if (Thread.currentThread().isInterrupted()) break;
                            if (path == null) continue;
                            try {
                                File toDelete = (File)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                                boolean protect = false;
                                for (String name : PROTECTED_FILES) {
                                    if (!toDelete.getName().equals(name)) continue;
                                    protect = true;
                                    break;
                                }
                                if (!protect) {
                                    Files.delete(toDelete.toPath());
                                    this.publish(toDelete.getName() + "...deleted successfully!\n");
                                    continue;
                                }
                                this.publish("Unable to delete: " + toDelete.getName() + " (Protected)\n");
                            }
                            catch (IOException e) {
                                this.publish("Unable to delete: " + ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() + "\n");
                            }
                            catch (ClassCastException e) {
                                // empty catch block
                            }
                        }
                    }
                    VisualProfiler.this.fileViewer.reloadNodes();
                    if (!Thread.currentThread().isInterrupted()) {
                        this.publish("File operations completed.\n");
                        this.publish("--------\n");
                    } else {
                        this.publish("File operations cancelled.\n");
                        this.publish("--------\n");
                    }
                    VisualProfiler.this.setEnabledActions(true);
                    ActionModel.this.threadFinish();
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String chunk : chunks) {
                        VisualProfiler.this.print(chunk);
                    }
                }
            };
            worker.execute();
        }

        private void reloadFiles() {
            this.reloadFiles(false);
        }

        private void reloadFiles(final boolean silent) {
            SwingWorker<Object, String> worker = new SwingWorker<Object, String>(){

                @Override
                protected Object doInBackground() throws Exception {
                    if (!silent) {
                        VisualProfiler.this.setEnabledActions(false);
                        ActionModel.this.threadStart(this);
                        this.publish("--------\n");
                        this.publish("Refreshing File Browser...");
                    }
                    VisualProfiler.this.fileViewer.reloadNodes();
                    if (!silent) {
                        this.publish("finished.\n");
                        this.publish("--------\n");
                        VisualProfiler.this.setEnabledActions(true);
                        ActionModel.this.threadFinish();
                    }
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String chunk : chunks) {
                        VisualProfiler.this.print(chunk);
                    }
                }
            };
            worker.execute();
        }

        private void addNodes(DefaultMutableTreeNode parentNode) {
            File[] subfiles = ((File)parentNode.getUserObject()).listFiles();
            if (subfiles != null) {
                for (File subfile : subfiles) {
                    if (subfile == null) continue;
                    DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(subfile);
                    parentNode.add(childNode);
                    this.addNodes(childNode);
                }
            }
        }

        private void saveLog() {
            SwingWorker<Object, String> worker = new SwingWorker<Object, String>(){

                @Override
                protected Object doInBackground() throws Exception {
                    VisualProfiler.this.setEnabledActions(false);
                    ActionModel.this.threadStart(this);
                    this.saveFile();
                    this.publish("--------\n");
                    this.publish("Saving Log...");
                    this.publish("finished.\n");
                    this.publish("--------\n");
                    VisualProfiler.this.setEnabledActions(true);
                    ActionModel.this.threadFinish();
                    return null;
                }

                private void saveFile() {
                    File outputFile = new File("ProfileResults\\" + DateUtils.getDate(DateUtils.DateFormat.NONDELIMITED) + "-Log.txt");
                    try {
                        outputFile.createNewFile();
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
                        out.print(VisualProfiler.this.console.txtConsole.getText());
                        out.close();
                    }
                    catch (IOException ex) {
                        System.err.println("Output errors exist.");
                    }
                }

                @Override
                protected void process(List<String> chunks) {
                    for (String chunk : chunks) {
                        VisualProfiler.this.print(chunk);
                    }
                }
            };
            worker.execute();
        }

        private void clearLog() {
            VisualProfiler.this.console.txtConsole.setText("");
        }

        private void threadStart(SwingWorker worker) {
            if (worker == null) {
                throw new IllegalArgumentException("Must have a non-null thread.");
            }
            VisualProfiler.this.thread = worker;
            ((VisualProfiler)VisualProfiler.this).console.btnCancelThread.setEnabled(true);
        }

        private void threadFinish() {
            VisualProfiler.this.thread = null;
            ((VisualProfiler)VisualProfiler.this).console.btnCancelThread.setEnabled(false);
            VisualProfiler.this.setEnabledActions(true);
        }

        private void cancelThread() {
            if (VisualProfiler.this.thread != null) {
                VisualProfiler.this.thread.cancel(true);
                ((VisualProfiler)VisualProfiler.this).console.btnCancelThread.setEnabled(false);
                SwingWorker worker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        this.publish("\nAction Cancelled\n");
                        this.publish("--------\n");
                        return null;
                    }
                };
                worker.execute();
            }
        }

        private class Profile2DTableThread
        extends SwingWorker<Object, String> {
            private VisualMultiLevelProfiler multiProfiler;

            public Profile2DTableThread(ProfileGraph2D profiler, List<Resolution> resolutions, List<Integer> datasetSizes) {
                VisualProfiler.this.setEnabledActions(false);
                VisualProfiler.this.model.threadStart(this);
                this.publish("--------\n");
                this.publish(profiler.getGraphTitle() + "\n\n");
                String strAuthor = VisualProfiler.this.settingsPanel.txtAuthorMessage.getText();
                String saveMessage = VisualProfiler.this.settingsPanel.txtSaveMessage.getText();
                this.multiProfiler = new VisualMultiLevelProfiler(profiler);
                this.multiProfiler.getSaveSettings().setAuthorMessage(strAuthor);
                this.multiProfiler.getSaveSettings().setSaveMessage(saveMessage);
                this.multiProfiler.setImageSizes(resolutions);
                this.multiProfiler.setDatasetSizes(datasetSizes);
            }

            @Override
            protected Object doInBackground() throws Exception {
                this.multiProfiler.profile();
                if (!Thread.currentThread().isInterrupted()) {
                    this.multiProfiler.saveStatistics();
                    if (VisualProfiler.this.userSettings.getSaveImage()) {
                        this.publish("Saving Images...");
                        this.multiProfiler.saveImages();
                        this.publish("finished.\n");
                    }
                    this.publish("\nProfiling complete.\n");
                    this.publish("--------\n");
                } else {
                    this.publish("\nProfiling cancelled.\n");
                    this.publish("--------\n");
                }
                VisualProfiler.this.setEnabledActions(true);
                VisualProfiler.this.model.threadFinish();
                return true;
            }

            @Override
            protected void process(List<String> chunks) {
                for (String chunk : chunks) {
                    VisualProfiler.this.print(chunk);
                }
            }

            private class VisualMultiLevelProfiler
            extends MultiLevelProfiler {
                public VisualMultiLevelProfiler(ProfileGraph2D profiler) {
                    super(profiler);
                }

                @Override
                public void processTimeWarning(int estimatedTime) {
                    Profile2DTableThread.this.publish(new String[]{"The estimated run time is " + estimatedTime + " seconds." + "\n\n"});
                }

                @Override
                public void processPreResult(Resolution resolution, int datasetSize) {
                    Profile2DTableThread.this.publish(new String[]{resolution + ": " + datasetSize + ":" + "    "});
                }

                @Override
                public void processResult(Resolution resolution, int datasetSize, Statistics stats) {
                    Profile2DTableThread.this.publish(new String[]{stats.getAverageTime() + "ms" + "\n"});
                }
            }
        }
    }

    private class UserSettings {
        private UserSettings() {
        }

        public Integer getWidth() {
            String strImageWidth = VisualProfiler.this.profile1DTable.txtImageWidth.getText();
            try {
                int width = Integer.parseInt(strImageWidth);
                if (width <= 0) {
                    throw new NumberFormatException();
                }
                return width;
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Enter a positive non-zero integer for the height.", "Error", 0);
                return null;
            }
        }

        public Integer getHeight() {
            String strImageHeight = VisualProfiler.this.profile1DTable.txtImageHeight.getText();
            try {
                int height = Integer.parseInt(strImageHeight);
                if (height <= 0) {
                    throw new NumberFormatException();
                }
                return height;
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Enter a positive non-zero integer for the height.", "Error", 0);
                return null;
            }
        }

        public boolean getSaveImage() {
            return VisualProfiler.this.settingsPanel.chkSaveImage.isSelected();
        }

        public Integer getTestTime() {
            String strTestTime = VisualProfiler.this.settingsPanel.txtTestTime.getText();
            try {
                Integer testTime = Integer.parseInt(strTestTime);
                if (testTime <= 0) {
                    throw new NumberFormatException();
                }
                return testTime;
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Enter a positive non-zero integer for test time.", "Error", 0);
                return null;
            }
        }

        public Integer getMaxTries() {
            String strMaxAttempts = VisualProfiler.this.settingsPanel.txtMaxAttempts.getText();
            try {
                int maxAttempts = Integer.parseInt(strMaxAttempts);
                if (maxAttempts <= 0) {
                    throw new NumberFormatException();
                }
                return maxAttempts;
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Enter a positive non-zero integer for max attempts.", "Error", 0);
                return null;
            }
        }

        public StopWatch.TimeType getTimeType() {
            return (StopWatch.TimeType)((Object)VisualProfiler.this.settingsPanel.listTimeTypes.getSelectedItem());
        }

        public List<String> getUpdateDescriptionList() {
            return VisualProfiler.this.settingsPanel.listUpdateTypes.getSelectedValuesList();
        }

        public String getAuthor() {
            return VisualProfiler.this.settingsPanel.txtAuthorMessage.getText();
        }

        public String getSaveMessage() {
            return VisualProfiler.this.settingsPanel.txtSaveMessage.getText();
        }

        public ProfileGraph2D getProfiler() {
            ProfileGraph2D renderer = this.selectedProfiler();
            if (renderer == null) {
                return null;
            }
            return this.applyDataset(this.applySettings(renderer));
        }

        public ProfileGraph2D selectedProfiler() {
            String strClass = ((VisualProfiler)VisualProfiler.this).settingsPanel.listRendererTypes.getSelectedItem().toString();
            return this.makeProfiler(strClass);
        }

        public ProfileGraph2D makeProfiler(String strClass) {
            return VisualProfiler.factory(strClass);
        }

        public ProfileGraph2D applySettings(ProfileGraph2D renderer) {
            renderer.getProfileSettings().setTestTime(this.getTestTime());
            renderer.getProfileSettings().setMaxTries(this.getMaxTries());
            renderer.getProfileSettings().setTimeType(this.getTimeType());
            renderer.getRenderSettings().setUpdate(this.getUpdateDescriptionList());
            renderer.getResolution().setWidth(this.getWidth());
            renderer.getResolution().setHeight(this.getHeight());
            renderer.getSaveSettings().setAuthorMessage(this.getAuthor());
            renderer.getSaveSettings().setSaveMessage(this.getSaveMessage());
            return renderer;
        }

        public ProfileGraph2D applyDataset(ProfileGraph2D renderer) {
            String strSize = VisualProfiler.this.profile1DTable.txtDatasetSize.getText();
            try {
                if (renderer instanceof ProfileIntensityGraph2D) {
                    ProfileIntensityGraph2D i = (ProfileIntensityGraph2D)renderer;
                    if (strSize.contains("x")) {
                        int w = Integer.parseInt(strSize.substring(0, strSize.indexOf("x")));
                        int h = Integer.parseInt(strSize.substring(strSize.indexOf("x") + 1));
                        i.setNumXDataPoints(w);
                        i.setNumYDataPoints(h);
                        return i;
                    }
                }
                int size = Integer.parseInt(strSize);
                renderer.setNumDataPoints(size);
                if (size <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Enter a positive non-zero integer for the dataset size. Use 1000x1000 for 2D cell data.", "Error", 0);
                return null;
            }
            return renderer;
        }
    }

    private class Console
    extends JPanel {
        private JTextArea txtConsole;
        private JLabel lblConsole;
        public JButton btnClearLog;
        public JButton btnSaveLog;
        private JLabel lblTime;
        private JTextField txtTime;
        public JButton btnCancelThread;

        public Console() {
            this.initComponents();
            this.initMnemonics();
            this.addComponents();
        }

        private void initComponents() {
            this.txtConsole = new JTextArea(20, 50);
            this.txtConsole.setEditable(false);
            this.lblConsole = new JLabel("Console");
            this.btnSaveLog = new JButton("Save Log");
            VisualProfiler.this.actionButtons.add(this.btnSaveLog);
            this.btnClearLog = new JButton("Clear Log");
            VisualProfiler.this.actionButtons.add(this.btnClearLog);
            this.lblTime = new JLabel("Timer:");
            this.txtTime = new JTextField("00:00:00");
            this.txtTime.setEditable(false);
            this.btnCancelThread = new JButton("Cancel");
            this.btnCancelThread.setEnabled(false);
            VisualProfiler.this.actionButtons.add(this.btnCancelThread);
        }

        private void initMnemonics() {
            this.btnSaveLog.setMnemonic('L');
            this.btnClearLog.setMnemonic('C');
            this.btnCancelThread.setMnemonic('T');
        }

        private void addComponents() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            JPanel consoleBottom = new JPanel();
            consoleBottom.setLayout(new GridLayout(3, 2));
            consoleBottom.add(VisualProfiler.this.blankPanel(this.btnSaveLog));
            consoleBottom.add(VisualProfiler.this.blankPanel(this.btnClearLog));
            consoleBottom.add(VisualProfiler.this.blankPanel(this.lblTime));
            consoleBottom.add(VisualProfiler.this.blankPanel(this.txtTime));
            consoleBottom.add(VisualProfiler.this.blankPanel(this.btnCancelThread));
            this.add((Component)this.lblConsole, "North");
            this.add((Component)new JScrollPane(this.txtConsole), "Center");
            this.add((Component)consoleBottom, "South");
        }

        public void print(List<String> chunks) {
            for (String chunk : chunks) {
                this.txtConsole.append(chunk);
            }
        }
    }

    private class FileViewer
    extends JSplitPane {
        private JTree tree;
        private DefaultTreeModel treeModel;
        private DefaultMutableTreeNode treeRoot;
        public JButton btnOpenFiles;
        public JButton btnDeleteFiles;
        public JButton btnReloadFiles;

        public FileViewer() {
            this.initComponents();
            this.initMenmonics();
            this.addComponents();
        }

        private void initComponents() {
            this.treeRoot = new DefaultMutableTreeNode(new File("ProfileResults\\"));
            this.treeModel = new DefaultTreeModel(this.treeRoot);
            this.tree = new JTree(this.treeRoot){

                @Override
                public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    try {
                        File f = (File)node.getUserObject();
                        return f.getName();
                    }
                    catch (Exception e) {
                        return node.toString();
                    }
                }
            };
            this.tree.setModel(this.treeModel);
            this.tree.expandRow(0);
            this.tree.setShowsRootHandles(true);
            this.btnOpenFiles = new JButton("Open File(s)");
            VisualProfiler.this.actionButtons.add(this.btnOpenFiles);
            this.btnDeleteFiles = new JButton("Delete File(s)");
            VisualProfiler.this.actionButtons.add(this.btnDeleteFiles);
            this.btnReloadFiles = new JButton("Refresh");
            VisualProfiler.this.actionButtons.add(this.btnReloadFiles);
        }

        private void initMenmonics() {
            this.btnOpenFiles.setMnemonic('O');
            this.btnDeleteFiles.setMnemonic('D');
            this.btnReloadFiles.setMnemonic('R');
        }

        private void addComponents() {
            JPanel fileTabRight = new JPanel();
            fileTabRight.setLayout(new BoxLayout(fileTabRight, 1));
            fileTabRight.add(this.btnOpenFiles);
            fileTabRight.add(this.btnDeleteFiles);
            fileTabRight.add(this.btnReloadFiles);
            this.setLeftComponent(new JScrollPane(this.tree));
            this.setRightComponent(fileTabRight);
        }

        public void reloadNodes() {
            this.treeRoot.removeAllChildren();
            VisualProfiler.this.model.addNodes(this.treeRoot);
            this.treeModel.nodeStructureChanged(this.treeRoot);
            this.repaint();
        }
    }

    private class AnalyzePanel
    extends JPanel {
        public JButton btnCompare2DTables;
        public JButton btnAnalyze1DTable;

        public AnalyzePanel() {
            this.initComponents();
            this.addComponents();
        }

        private void initComponents() {
            this.btnCompare2DTables = new JButton("Compare Profile Tables");
            VisualProfiler.this.actionButtons.add(this.btnCompare2DTables);
            this.btnAnalyze1DTable = new JButton("Analyze Single Profile Tables");
            VisualProfiler.this.actionButtons.add(this.btnAnalyze1DTable);
        }

        private void addComponents() {
            this.add(this.btnCompare2DTables);
            this.add(this.btnAnalyze1DTable);
        }
    }

    private class Profile2DTable
    extends JSplitPane {
        private JLabel lblResolutions;
        private JLabel lblNPoints;
        public JButton btnProfile2D;
        private JList<Resolution> listResolutions;
        private JList<Integer> listNPoints;
        private DefaultListModel<Resolution> modelResolutions;
        private DefaultListModel<Integer> modelNPoints;

        public Profile2DTable() {
            this.initComponents();
            this.initMnemonics();
            this.addComponents();
            this.loadLists();
        }

        private void initComponents() {
            this.lblResolutions = new JLabel("Resolutions");
            this.lblNPoints = new JLabel("N Points");
            this.btnProfile2D = new JButton("Start");
            VisualProfiler.this.actionButtons.add(this.btnProfile2D);
            this.listResolutions = new JList();
            this.listNPoints = new JList();
        }

        private void initMnemonics() {
            this.btnProfile2D.setMnemonic('S');
        }

        private void addComponents() {
            JPanel multiLayerLeft = new JPanel();
            multiLayerLeft.setLayout(new BorderLayout());
            multiLayerLeft.add((Component)this.lblResolutions, "North");
            multiLayerLeft.add((Component)new JScrollPane(this.listResolutions), "Center");
            JPanel multiLayerMiddle = new JPanel();
            multiLayerMiddle.setLayout(new BorderLayout());
            multiLayerMiddle.add((Component)this.lblNPoints, "North");
            multiLayerMiddle.add((Component)new JScrollPane(this.listNPoints), "Center");
            JPanel multiLayerRight = new JPanel();
            multiLayerRight.setLayout(new BorderLayout());
            multiLayerRight.add((Component)VisualProfiler.this.blankPanel(this.btnProfile2D), "North");
            final JSplitPane multiLayerInner = new JSplitPane();
            multiLayerInner.setLeftComponent(multiLayerLeft);
            multiLayerInner.setRightComponent(multiLayerMiddle);
            this.setLeftComponent(multiLayerInner);
            this.setRightComponent(multiLayerRight);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Profile2DTable.this.setDividerLocation(0.8);
                    multiLayerInner.setDividerLocation(0.8);
                }
            });
        }

        private void loadLists() {
            this.modelResolutions = new DefaultListModel();
            this.modelNPoints = new DefaultListModel();
            for (Resolution resolution : Resolution.defaultResolutions()) {
                this.modelResolutions.addElement(resolution);
            }
            for (Integer datasetSize : DatasetFactory.defaultDatasetSizes()) {
                this.modelNPoints.addElement(datasetSize);
            }
            this.listResolutions.setModel(this.modelResolutions);
            this.listNPoints.setModel(this.modelNPoints);
        }
    }

    private class Profile1DTable
    extends JPanel {
        private JLabel lblDatasetSize;
        private JTextField txtDatasetSize;
        private JLabel lblImageWidth;
        private JTextField txtImageWidth;
        private JLabel lblImageHeight;
        private JTextField txtImageHeight;
        private JLabel lblShowGraph;
        private JCheckBox chkShowGraph;
        public JButton btnProfile1D;
        public JButton btnProfile1DAll;

        public Profile1DTable() {
            this.initComponents();
            this.initMnemonics();
            this.addComponents();
        }

        private void initComponents() {
            this.lblDatasetSize = new JLabel("Number of Data Points: ");
            this.lblDatasetSize.setToolTipText("Format for IntensityGraph2D: 1000x1000");
            this.txtDatasetSize = new JTextField("10000");
            this.lblImageWidth = new JLabel("Image Width: ");
            this.txtImageWidth = new JTextField("640");
            this.lblImageHeight = new JLabel("Image Height: ");
            this.txtImageHeight = new JTextField("480");
            this.lblShowGraph = new JLabel("Graph Results: ");
            this.chkShowGraph = new JCheckBox("Show Graph");
            this.btnProfile1D = new JButton("Profile");
            VisualProfiler.this.actionButtons.add(this.btnProfile1D);
            this.btnProfile1DAll = new JButton("Profile For All Renderers");
            VisualProfiler.this.actionButtons.add(this.btnProfile1DAll);
        }

        private void initMnemonics() {
            this.btnProfile1D.setMnemonic('P');
            this.btnProfile1DAll.setMnemonic('A');
        }

        private void addComponents() {
            this.setLayout(new GridLayout(0, 2));
            this.add(this.lblDatasetSize);
            this.add(this.txtDatasetSize);
            this.add(this.lblImageWidth);
            this.add(this.txtImageWidth);
            this.add(this.lblImageHeight);
            this.add(this.txtImageHeight);
            this.add(this.lblShowGraph);
            this.add(this.chkShowGraph);
            this.add(VisualProfiler.this.blankPanel(this.btnProfile1D));
            this.add(VisualProfiler.this.blankPanel(this.btnProfile1DAll));
        }

        public boolean getShowGraph() {
            return ((VisualProfiler)VisualProfiler.this).profile1DTable.chkShowGraph.isSelected();
        }
    }

    private class SettingsPanel
    extends JPanel {
        public JComboBox listRendererTypes;
        private JLabel lblRendererTypes;
        private JTextField txtTestTime;
        private JLabel lblTestTime;
        private JTextField txtMaxAttempts;
        private JLabel lblMaxAttempts;
        private JComboBox listTimeTypes;
        private JLabel lblTimeTypes;
        private JLabel lblSaveImage;
        private JCheckBox chkSaveImage;
        private JList listUpdateTypes;
        private JLabel lblUpdateTypes;
        private JLabel lblSaveMessage;
        private JTextField txtSaveMessage;
        private JLabel lblAuthorMessage;
        private JTextField txtAuthorMessage;

        public SettingsPanel() {
            this.initComponents();
            this.addComponents();
        }

        private void initComponents() {
            this.listRendererTypes = new JComboBox<String>(SUPPORTED_PROFILERS);
            this.lblRendererTypes = new JLabel("Renderer Type: ");
            this.txtTestTime = new JTextField("20");
            this.lblTestTime = new JLabel("Test Time: ");
            this.txtMaxAttempts = new JTextField("1000000");
            this.lblMaxAttempts = new JLabel("Max Attempts: ");
            this.listTimeTypes = new JComboBox<StopWatch.TimeType>(StopWatch.TimeType.values());
            this.lblTimeTypes = new JLabel("Timing Based Off: ");
            this.lblSaveImage = new JLabel("Save Images: ");
            this.chkSaveImage = new JCheckBox("Save Image");
            this.listUpdateTypes = new JList();
            this.lblUpdateTypes = new JLabel("Apply Update: ");
            this.lblSaveMessage = new JLabel("Save Message: ");
            this.txtSaveMessage = new JTextField("");
            this.lblAuthorMessage = new JLabel("Author: ");
            this.txtAuthorMessage = new JTextField("");
        }

        private void addComponents() {
            JPanel right = new JPanel();
            right.setLayout(new BorderLayout());
            right.add((Component)this.lblUpdateTypes, "North");
            right.add((Component)new JScrollPane(this.listUpdateTypes), "Center");
            JPanel left = new JPanel();
            left.setLayout(new GridLayout(0, 2));
            left.add(this.lblRendererTypes);
            left.add(this.listRendererTypes);
            left.add(this.lblTestTime);
            left.add(this.txtTestTime);
            left.add(this.lblMaxAttempts);
            left.add(this.txtMaxAttempts);
            left.add(this.lblTimeTypes);
            left.add(this.listTimeTypes);
            left.add(this.lblSaveImage);
            left.add(this.chkSaveImage);
            left.add(this.lblSaveMessage);
            left.add(this.txtSaveMessage);
            left.add(this.lblAuthorMessage);
            left.add(this.txtAuthorMessage);
            this.setLayout(new GridLayout(0, 2));
            this.add(left);
            this.add(right);
        }
    }
}

