/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.image;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.epics.graphene.AreaGraph2DRenderer;
import org.epics.graphene.AreaGraph2DRendererUpdate;
import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.LineGraph2DRenderer;
import org.epics.graphene.LineGraph2DRendererUpdate;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.profile.image.ImagePanel;

public class ShowResizableGraph
extends JFrame {
    private final Renderer renderer;
    private ImagePanel imagePanel;

    public ShowResizableGraph(Renderer renderer) {
        this.initComponents();
        this.renderer = renderer;
        this.imagePanel.setImage(new BufferedImage(this.getRootPane().getWidth(), this.getRootPane().getHeight(), 5));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ShowResizableGraph.this.redrawGraph();
            }
        });
        this.redrawGraph();
    }

    private void initComponents() {
        this.imagePanel = new ImagePanel();
        this.setDefaultCloseOperation(3);
        this.imagePanel.setLayout(new FlowLayout());
        this.getContentPane().add((Component)this.imagePanel, "Center");
        this.pack();
    }

    private void redrawGraph() {
        BufferedImage newImage = new BufferedImage(this.getRootPane().getWidth(), this.getRootPane().getHeight(), 5);
        this.renderer.redrawHistogram(newImage);
        this.imagePanel.setImage(newImage);
    }

    public static void showGraph(final Renderer renderer) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowResizableGraph frame = new ShowResizableGraph(renderer);
                frame.setSize(600, 400);
                frame.setVisible(true);
            }
        });
    }

    public static void showHistogram(final Cell1DDataset hist) {
        final AreaGraph2DRenderer renderer = new AreaGraph2DRenderer(200, 300);
        ShowResizableGraph.showGraph(new Renderer(){

            @Override
            public void redrawHistogram(BufferedImage image) {
                renderer.update((AreaGraph2DRendererUpdate)((AreaGraph2DRendererUpdate)new AreaGraph2DRendererUpdate().imageHeight(image.getHeight())).imageWidth(image.getWidth()));
                renderer.draw(image.createGraphics(), hist);
            }
        });
    }

    public static void showLineGraph(final Point2DDataset dataset) {
        final LineGraph2DRenderer renderer = new LineGraph2DRenderer(200, 300);
        ShowResizableGraph.showGraph(new Renderer(){

            @Override
            public void redrawHistogram(BufferedImage image) {
                renderer.update((LineGraph2DRendererUpdate)((LineGraph2DRendererUpdate)new LineGraph2DRendererUpdate().imageHeight(image.getHeight())).imageWidth(image.getWidth()));
                renderer.draw(image.createGraphics(), dataset);
            }
        });
    }

    public static abstract class Renderer {
        public abstract void redrawHistogram(BufferedImage var1);
    }
}

