/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.impl;

import java.awt.Graphics2D;
import java.util.LinkedHashMap;
import java.util.Random;
import org.epics.graphene.AreaGraph2DRenderer;
import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.Cell1DDatasets;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.profile.ProfileGraph2D;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;

public class ProfileHistogram1D
extends ProfileGraph2D<AreaGraph2DRenderer, Cell1DDataset> {
    @Override
    protected Cell1DDataset getDataset() {
        int nSamples = this.getNumDataPoints();
        Random rand = new Random(1L);
        double[] data = new double[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            data[i] = rand.nextGaussian();
        }
        return Cell1DDatasets.datasetFrom((ListNumber)new ArrayDouble(data), (ListNumber)ListNumbers.linearList((double)0.0, (double)1.0, (int)nSamples));
    }

    @Override
    protected AreaGraph2DRenderer getRenderer(int imageWidth, int imageHeight) {
        return new AreaGraph2DRenderer(imageWidth, imageHeight);
    }

    @Override
    protected void render(Graphics2D graphics, AreaGraph2DRenderer renderer, Cell1DDataset data) {
        renderer.draw(graphics, data);
    }

    @Override
    public String getGraphTitle() {
        return "Histogram1D";
    }

    @Override
    public LinkedHashMap<String, Graph2DRendererUpdate> getVariations() {
        LinkedHashMap<String, Graph2DRendererUpdate> map = new LinkedHashMap<String, Graph2DRendererUpdate>();
        map.put("None", null);
        return map;
    }
}

