/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.impl;

import java.awt.Graphics2D;
import java.util.LinkedHashMap;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.ScatterGraph2DRenderer;
import org.epics.graphene.ScatterGraph2DRendererUpdate;
import org.epics.graphene.profile.ProfileGraph2D;
import org.epics.graphene.profile.utils.DatasetFactory;

public class ProfileScatterGraph2D
extends ProfileGraph2D<ScatterGraph2DRenderer, Point2DDataset> {
    @Override
    protected Point2DDataset getDataset() {
        return DatasetFactory.makePoint2DGaussianRandomData(this.getNumDataPoints());
    }

    @Override
    protected ScatterGraph2DRenderer getRenderer(int imageWidth, int imageHeight) {
        return new ScatterGraph2DRenderer(imageWidth, imageHeight);
    }

    @Override
    protected void render(Graphics2D graphics, ScatterGraph2DRenderer renderer, Point2DDataset data) {
        renderer.draw(graphics, data);
    }

    @Override
    public String getGraphTitle() {
        return "ScatterGraph2D";
    }

    @Override
    public LinkedHashMap<String, Graph2DRendererUpdate> getVariations() {
        LinkedHashMap<String, Graph2DRendererUpdate> map = new LinkedHashMap<String, Graph2DRendererUpdate>();
        map.put("None", null);
        map.put("Linear Interpolation", (Graph2DRendererUpdate)new ScatterGraph2DRendererUpdate().interpolation(InterpolationScheme.LINEAR));
        map.put("Cubic Interpolation", (Graph2DRendererUpdate)new ScatterGraph2DRendererUpdate().interpolation(InterpolationScheme.CUBIC));
        return map;
    }
}

