/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.impl;

import java.awt.Graphics2D;
import java.util.LinkedHashMap;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.SparklineGraph2DRenderer;
import org.epics.graphene.SparklineGraph2DRendererUpdate;
import org.epics.graphene.profile.ProfileGraph2D;
import org.epics.graphene.profile.utils.DatasetFactory;

public class ProfileSparklineGraph2D
extends ProfileGraph2D<SparklineGraph2DRenderer, Point2DDataset> {
    @Override
    protected Point2DDataset getDataset() {
        return DatasetFactory.makePoint2DGaussianRandomData(this.getNumDataPoints());
    }

    @Override
    protected SparklineGraph2DRenderer getRenderer(int imageWidth, int imageHeight) {
        SparklineGraph2DRenderer renderer = new SparklineGraph2DRenderer(imageWidth, imageHeight);
        return renderer;
    }

    @Override
    protected void render(Graphics2D graphics, SparklineGraph2DRenderer renderer, Point2DDataset data) {
        renderer.draw(graphics, data);
    }

    @Override
    public String getGraphTitle() {
        return "SparklineGraph2D";
    }

    @Override
    public LinkedHashMap<String, Graph2DRendererUpdate> getVariations() {
        LinkedHashMap<String, Graph2DRendererUpdate> map = new LinkedHashMap<String, Graph2DRendererUpdate>();
        map.put("None", null);
        map.put("Linear Interpolation", (Graph2DRendererUpdate)new SparklineGraph2DRendererUpdate().interpolation(InterpolationScheme.LINEAR));
        map.put("Cubic Interpolation", (Graph2DRendererUpdate)new SparklineGraph2DRendererUpdate().interpolation(InterpolationScheme.CUBIC));
        map.put("Nearest Neighbor Interpolation", (Graph2DRendererUpdate)new SparklineGraph2DRendererUpdate().interpolation(InterpolationScheme.NEAREST_NEIGHBOR));
        map.put("Not Draw Circles", (Graph2DRendererUpdate)new SparklineGraph2DRendererUpdate().drawCircles(false));
        return map;
    }
}

