/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CSVFinder {
    public static String[] SUPPORTED_TABLES_1D = new String[]{"Histogram1D.csv", "IntensityGraph2D.csv", "LineGraph2D.csv", "ScatterGraph2D.csv", "SparklineGraph2D.csv"};

    private CSVFinder() {
    }

    public static File browseCSV() {
        JFileChooser fc = new JFileChooser("ProfileResults\\");
        fc.setFileFilter(new FileNameExtensionFilter("Graphene Tables (*.csv)", "csv"));
        int returnValue = fc.showOpenDialog(null);
        if (returnValue == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static List<File> findTables1D() {
        ArrayList<File> tables1D = new ArrayList<File>();
        File root = new File("ProfileResults\\");
        for (File subfile : root.listFiles()) {
            for (int i = 0; i < SUPPORTED_TABLES_1D.length; ++i) {
                if (!SUPPORTED_TABLES_1D[i].equals(subfile.getName())) continue;
                tables1D.add(subfile);
                i = SUPPORTED_TABLES_1D.length;
            }
        }
        return tables1D;
    }

    public static void validateCSV(File csvFile) {
        if (csvFile == null) {
            throw new IllegalArgumentException("The CSV file must not be null.");
        }
        if (!csvFile.exists()) {
            throw new IllegalArgumentException("The CSV file must exist.");
        }
    }
}

