/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CSVWriter {
    public static final String QUOTE = "\"";
    public static final String DELIM = ",";

    private CSVWriter() {
    }

    public static File createNewFile(String filename) {
        try {
            File outputFile = new File(filename + ".csv");
            outputFile.createNewFile();
            return outputFile;
        }
        catch (IOException ex) {
            Logger.getLogger(CSVWriter.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static File createFile(String filename) {
        try {
            File outputFile = new File(filename + ".csv");
            int tmp = 1;
            while (outputFile.exists()) {
                outputFile = new File(filename + ".csv" + "." + tmp);
                ++tmp;
            }
            outputFile.createNewFile();
            return outputFile;
        }
        catch (IOException ex) {
            Logger.getLogger(CSVWriter.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void writeData(File csvFile, List<List> rows) {
        if (csvFile == null) {
            throw new IllegalArgumentException("Cannot write to a null file.");
        }
        if (rows == null) {
            throw new IllegalArgumentException("Must have non-null data to write.");
        }
        for (List row : rows) {
            CSVWriter.writeRow(csvFile, row);
        }
    }

    public static void writeRow(File csvFile, List row) {
        if (csvFile == null) {
            throw new IllegalArgumentException("Cannot write to a null file.");
        }
        if (row == null) {
            throw new IllegalArgumentException("Must have non-null data to write.");
        }
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(csvFile, true)));){
            for (Object entry : row) {
                if (entry == null) continue;
                out.print(CSVWriter.formatEntry(entry));
            }
            out.println();
            out.close();
        }
        catch (IOException e) {
            System.err.println("Output errors exist.");
        }
    }

    public static void writeRow(File csvFile, Object data) {
        ArrayList<Object> rows = new ArrayList<Object>();
        rows.add(data);
        CSVWriter.writeRow(csvFile, rows);
    }

    private static String formatEntry(Object entry) {
        return QUOTE + entry.toString() + QUOTE + DELIM;
    }

    public static List arrayCombine(Object ... items) {
        if (items == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object item : items) {
            if (item == null) continue;
            if (item instanceof Object[]) {
                Object[] entries = (Object[])item;
                for (int i = 0; i < entries.length; ++i) {
                    l.add(entries[i]);
                }
                continue;
            }
            l.add(item);
        }
        return l;
    }
}

