/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.profile.ProfileGraph2D;
import org.epics.graphene.profile.settings.Settings;

public class RenderSettings
implements Settings {
    private List<Graph2DRendererUpdate> updates;
    private List<String> updateDescriptions;
    private boolean bufferInLoop = false;
    private ProfileGraph2D profiler;

    public RenderSettings(ProfileGraph2D profiler) {
        if (profiler == null) {
            throw new IllegalArgumentException("Use a non-null profiler");
        }
        this.updates = new ArrayList<Graph2DRendererUpdate>();
        this.updateDescriptions = new ArrayList<String>();
        this.profiler = profiler;
    }

    public void setBufferInLoop(boolean bufferInLoop) {
        this.bufferInLoop = bufferInLoop;
    }

    public void setUpdate(String description) {
        this.setUpdate(Arrays.asList(description));
    }

    public void setUpdate(List<String> descriptions) {
        if (descriptions == null) {
            throw new IllegalArgumentException("Invalid descriptions");
        }
        this.updateDescriptions = descriptions;
        this.updates.clear();
        for (String description : descriptions) {
            Graph2DRendererUpdate tmp = this.profiler.getVariations().get(description);
            if (tmp == null) {
                throw new IllegalArgumentException("Update is not supported!");
            }
            this.updates.add(tmp);
        }
    }

    public boolean getBufferInLoop() {
        return this.bufferInLoop;
    }

    public List<Graph2DRendererUpdate> getUpdates() {
        return this.updates;
    }

    public String getUpdateDescription() {
        String tmp = "";
        for (int i = 0; i < this.updateDescriptions.size() - 1; ++i) {
            tmp = tmp + this.updateDescriptions.get(i) + " & ";
        }
        tmp = tmp + this.updateDescriptions.get(this.updateDescriptions.size() - 1);
        return tmp;
    }

    @Override
    public Object[] getTitle() {
        return new Object[]{"Update Applied"};
    }

    @Override
    public Object[] getOutput() {
        return new Object[]{this.getUpdateDescription()};
    }
}

