/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.settings;

import com.sun.management.OperatingSystemMXBean;
import java.awt.image.BufferedImage;
import java.lang.management.ManagementFactory;
import org.epics.graphene.profile.settings.Settings;

public class SaveSettings
implements Settings {
    private static final double BYTES_TO_GB = 1.073741824E9;
    private String datasetMessage = "";
    private String saveMessage = "";
    private String authorMessage = "";
    private BufferedImage saveImage = null;

    public void setDatasetMessage(String message) {
        this.datasetMessage = message;
    }

    public void setSaveMessage(String message) {
        this.saveMessage = message;
    }

    public void setAuthorMessage(String author) {
        this.authorMessage = author;
    }

    public void setSaveImage(BufferedImage saveImage) {
        this.saveImage = saveImage;
    }

    public String getDatasetMessage() {
        return this.datasetMessage;
    }

    public String getSaveMessage() {
        return this.saveMessage;
    }

    public String getAuthorMessage() {
        return this.authorMessage;
    }

    public BufferedImage getSaveImage() {
        return this.saveImage;
    }

    private String[] getSaveOutputHeader() {
        return new String[]{"Dataset Comments", "Author", "General Message"};
    }

    private String[] getSaveOutputMessage() {
        String quote = "\"";
        String delim = ",";
        return new String[]{this.getDatasetMessage(), this.getAuthorMessage(), this.getSaveMessage()};
    }

    private String[] getHardwareTitle() {
        return new String[]{"JVM Version", "Available Memory (GB)", "RAM (GB)", "OS", "OS Version"};
    }

    private String[] getHardwareMessage() {
        String javaVersion = System.getProperty("java.version");
        String os = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        javaVersion = javaVersion == null ? "" : javaVersion;
        os = os == null ? "" : os;
        osVersion = osVersion == null ? "" : osVersion;
        double runtime = (double)Runtime.getRuntime().maxMemory() / 1.073741824E9;
        double memorySize = (double)((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() / 1.073741824E9;
        return new String[]{javaVersion, String.format("%.3f", runtime), String.format("%.3f", memorySize), os, osVersion};
    }

    @Override
    public Object[] getTitle() {
        String[] s = this.getSaveOutputHeader();
        String[] h = this.getHardwareTitle();
        Object[] entries = new Object[s.length + h.length];
        System.arraycopy(s, 0, entries, 0, s.length);
        System.arraycopy(h, 0, entries, s.length, h.length);
        return entries;
    }

    @Override
    public Object[] getOutput() {
        String[] s = this.getSaveOutputMessage();
        String[] h = this.getHardwareMessage();
        Object[] entries = new Object[s.length + h.length];
        System.arraycopy(s, 0, entries, 0, s.length);
        System.arraycopy(h, 0, entries, s.length, h.length);
        return entries;
    }
}

