/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.Cell1DDatasets;
import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.Cell2DDatasets;
import org.epics.graphene.Point1DDataset;
import org.epics.graphene.Point1DDatasets;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Point2DDatasets;
import org.epics.graphene.Point3DWithLabelDataset;
import org.epics.graphene.Point3DWithLabelDatasets;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListNumber;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;

public final class DatasetFactory {
    private DatasetFactory() {
    }

    public static List<Integer> defaultDatasetSizes() {
        return DatasetFactory.logarathmicDatasetSizes(1, 6, 10);
    }

    public static List<Integer> logarathmicDatasetSizes(int min, int max, int base) {
        ArrayList<Integer> sizes = new ArrayList<Integer>(max);
        for (int power = min; power <= max; ++power) {
            sizes.add((int)Math.pow(base, power));
        }
        return sizes;
    }

    public static Point1DDataset makePoint1DGaussianRandomData(int nSamples) {
        int seed = 1;
        Random rand = new Random(seed);
        double[] data = new double[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            data[i] = rand.nextGaussian();
        }
        Point1DDataset dataset = Point1DDatasets.of((ListNumber)new ArrayDouble(data));
        return dataset;
    }

    public static Point2DDataset makePoint2DGaussianRandomData(int nSamples) {
        double[] waveform = new double[nSamples];
        int seed = 1;
        Random rand = new Random(seed);
        for (int i = 0; i < nSamples; ++i) {
            waveform[i] = rand.nextGaussian();
        }
        return Point2DDatasets.lineData((double[])waveform);
    }

    public static Point3DWithLabelDataset makePoint3DWithLabelGaussianRandomData(int nSamples) {
        ArrayDouble x = new ArrayDouble(new double[nSamples], false);
        ArrayDouble y = new ArrayDouble(new double[nSamples], false);
        ArrayDouble z = new ArrayDouble(new double[nSamples], false);
        int seed = 1;
        ArrayList<String> labels = new ArrayList<String>(nSamples);
        String[] labelSet = new String[]{"First", "Second", "Third", "Fourth", "Fifth"};
        Random rand = new Random(seed);
        for (int i = 0; i < nSamples; ++i) {
            x.setDouble(i, rand.nextGaussian());
            y.setDouble(i, rand.nextGaussian());
            z.setDouble(i, rand.nextGaussian());
            labels.add(labelSet[rand.nextInt(labelSet.length)]);
        }
        return Point3DWithLabelDatasets.build((ListNumber)x, (ListNumber)y, (ListNumber)z, labels);
    }

    public static Cell1DDataset makeCell1DGaussianRandomData(int nSamples) {
        double[] waveform = new double[nSamples];
        int seed = 1;
        Random rand = new Random(seed);
        for (int i = 0; i < nSamples; ++i) {
            waveform[i] = rand.nextGaussian();
        }
        Statistics stats = StatisticsUtil.statisticsOf((CollectionNumber)new ArrayDouble(waveform));
        return Cell1DDatasets.linearRange((ListNumber)new ArrayDouble(waveform), (double)stats.getMinimum().doubleValue(), (double)stats.getMaximum().doubleValue());
    }

    public static Cell2DDataset makeCell2DGaussianRandomData(int xSamples, int ySamples) {
        int nSamples = xSamples * ySamples;
        double[] waveform = new double[nSamples];
        int seed = 1;
        Random rand = new Random(seed);
        for (int i = 0; i < nSamples; ++i) {
            waveform[i] = rand.nextGaussian();
        }
        return Cell2DDatasets.linearRange((ListNumber)new ArrayDouble(waveform), (Range)Ranges.range((double)0.0, (double)xSamples), (int)xSamples, (Range)Ranges.range((double)0.0, (double)ySamples), (int)ySamples);
    }
}

