/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.epics.graphene.profile.io.CSVFinder;
import org.epics.graphene.profile.io.CSVReader;
import org.epics.graphene.profile.io.CSVWriter;
import org.epics.graphene.profile.io.DateUtils;

public class ProfileAnalysis {
    public static final double STATISTICALLY_SIGNIFICANT = 0.05;

    private ProfileAnalysis() {
    }

    public static void compareTables2D() {
        String message = "Select two Graphene table files (*.csv) to compute the timing differences of.";
        String hint = "Note that the differences are calculated by: first file cell minus second file cell.";
        JOptionPane.showMessageDialog(null, message);
        JOptionPane.showMessageDialog(null, hint);
        File fileA = CSVFinder.browseCSV();
        if (fileA == null) {
            return;
        }
        File fileB = CSVFinder.browseCSV();
        if (fileB == null) {
            return;
        }
        ProfileAnalysis.compareTables2D(fileA, fileB);
    }

    public static void compareTables2D(File fileA, File fileB) {
        CSVReader.validate2DTablesNames(fileA, fileB);
        List<List<String>> dataA = CSVReader.parseCSV(fileA);
        List<List<String>> dataB = CSVReader.parseCSV(fileB);
        CSVReader.validate2DTables(dataA, dataB);
        if (dataA.isEmpty() || dataB.isEmpty()) {
            return;
        }
        String badCell = "*Error in reading this cell*";
        ArrayList<List> output = new ArrayList<List>();
        ArrayList<String> outputHeader = new ArrayList<String>();
        for (int c = 0; c < dataA.get(0).size(); ++c) {
            if (dataA.get(0).get(c).equals(dataB.get(0).get(c))) {
                outputHeader.add(dataA.get(0).get(c));
                continue;
            }
            outputHeader.add(badCell);
        }
        output.add(outputHeader);
        for (int r = 1; r < dataA.size(); ++r) {
            ArrayList<String> outputRow = new ArrayList<String>();
            for (int c = 0; c < dataA.get(r).size(); ++c) {
                try {
                    double numA = Double.parseDouble(dataA.get(r).get(c));
                    double numB = Double.parseDouble(dataB.get(r).get(c));
                    double diff = (numA - numB) / numA * 100.0;
                    outputRow.add(String.format("%.3f", diff + "%"));
                    continue;
                }
                catch (NumberFormatException ex) {
                    outputRow.add(badCell);
                }
            }
            output.add(outputRow);
        }
        String[] compA = fileA.getName().split("-");
        String[] compB = fileB.getName().split("-");
        String date = DateUtils.getDate(DateUtils.DateFormat.NONDELIMITED);
        String dateA = compA[0];
        String dateB = compB[0];
        String graphType = compA[1];
        File outputFile = CSVWriter.createNewFile("ProfileResults\\" + date + "-" + graphType + "-Table2D Difference-" + dateA + "vs" + dateB + ".csv");
        CSVWriter.writeData(outputFile, output);
    }

    public static List<String> analyzeTables1D() {
        List<File> files = CSVFinder.findTables1D();
        ArrayList<String> results = new ArrayList<String>();
        for (File tableFile : files) {
            List<List<String>> tableRows;
            if (tableFile == null || (tableRows = CSVReader.parseCSV(tableFile)).size() <= 2) continue;
            List<String> previous = tableRows.get(tableRows.size() - 2);
            List<String> recent = tableRows.get(tableRows.size() - 1);
            String graphType = previous.get(0);
            double percentChange = ProfileAnalysis.percentChange(Double.parseDouble(previous.get(2)), Double.parseDouble(recent.get(2)));
            String performance = ProfileAnalysis.performanceChange(Double.parseDouble(previous.get(2)), Double.parseDouble(recent.get(2)));
            results.add(graphType + ": " + performance + ": " + String.format("%.3f", percentChange) + "% changed");
        }
        results.add("\n" + results.size() + " files analyzed.");
        return results;
    }

    public static double percentChange(double valInit, double valFinal) {
        return (valFinal - valInit) / valInit * 100.0;
    }

    public static String performanceChange(double valInit, double valFinal) {
        double percentChange = ProfileAnalysis.percentChange(valInit, valFinal);
        if (percentChange > 5.0) {
            return "Performance Decrease";
        }
        if (percentChange < 5.0) {
            return "Performance Increase";
        }
        return "Performance Stable";
    }
}

