/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene.profile.utils;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.util.Arrays;
import org.epics.graphene.profile.settings.Settings;
import org.epics.util.array.ArrayLong;
import org.epics.util.array.ListLong;

public class StopWatch
implements Settings {
    private long start;
    private int nAttempts = 0;
    private final long[] timings;
    private TimeType timeType = TimeType.Cpu;
    private OperatingSystemMXBean bean;

    public StopWatch(int maxAttempts) {
        this.timings = new long[maxAttempts];
        this.bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    public void start() {
        if (this.nAttempts >= this.timings.length) {
            throw new ArrayIndexOutOfBoundsException("The stop watch has reached the maximum timings it can track.");
        }
        this.start = this.timeType == TimeType.System ? System.nanoTime() : this.bean.getProcessCpuTime();
    }

    public void stop() {
        this.timings[this.nAttempts] = this.timeType == TimeType.System ? System.nanoTime() - this.start : this.bean.getProcessCpuTime() - this.start;
        ++this.nAttempts;
    }

    public double getAverageMs() {
        double average = 0.0;
        for (int i = 0; i < this.nAttempts; ++i) {
            average += (double)this.timings[i] / 1000000.0;
        }
        return average / (double)this.nAttempts;
    }

    public long getTotalMs() {
        long total = 0L;
        for (int i = 0; i < this.nAttempts; ++i) {
            total = (long)((double)total + (double)this.timings[i] / 1000000.0);
        }
        return total;
    }

    public ListLong getNanoTimings() {
        return new ArrayLong(Arrays.copyOfRange(this.timings, 0, this.nAttempts));
    }

    public ListLong getNanoAverages(int start) {
        long[] averages = new long[this.nAttempts - start];
        BigInteger total = BigInteger.ZERO;
        for (int i = 0; i < averages.length; ++i) {
            total = total.add(BigInteger.valueOf(this.timings[i + start]));
            averages[i] = total.divide(BigInteger.valueOf(i + 1)).longValue();
        }
        return new ArrayLong(averages);
    }

    public TimeType getTimeType() {
        return this.timeType;
    }

    public void setTimeType(TimeType type) {
        this.timeType = type;
    }

    public String[] getTitle() {
        return new String[]{"Average Time (ms)", "Total Time (ms)"};
    }

    @Override
    public Object[] getOutput() {
        return new String[]{Double.valueOf(this.getAverageMs()).toString(), Long.valueOf(this.getTotalMs()).toString()};
    }

    public static enum TimeType {
        System,
        Cpu;

    }
}

