/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.epics.graphene.AxisRange;
import org.epics.graphene.AxisRanges;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.LabelColorScheme;
import org.epics.graphene.LabelColorSchemes;
import org.epics.graphene.NumberUtil;
import org.epics.graphene.Point3DWithLabelDataset;
import org.epics.graphene.Range;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;

public class BubbleGraph2DRenderer
extends Graph2DRenderer<Graph2DRendererUpdate> {
    private Range zAggregatedRange;
    private AxisRange zAxisRange = AxisRanges.integrated();
    private Range zPlotRange;

    public BubbleGraph2DRenderer(int width, int height) {
        super(width, height);
    }

    protected void calculateRanges(Range xDataRange, Range yDataRange, Range zDataRange) {
        super.calculateRanges(xDataRange, yDataRange);
        this.zAggregatedRange = BubbleGraph2DRenderer.aggregateRange(zDataRange, this.zAggregatedRange);
        this.zPlotRange = this.zAxisRange.axisRange(zDataRange, this.zAggregatedRange);
    }

    public void draw(Graphics2D g, Point3DWithLabelDataset data) {
        this.g = g;
        this.calculateRanges(data.getXStatistics(), data.getYStatistics(), data.getZStatistics());
        this.drawBackground();
        this.calculateGraphArea();
        this.drawGraphArea();
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        LabelColorScheme labelColor = LabelColorSchemes.orderedHueColor(data.getLabels());
        ListInt indexes = ListNumbers.sortedView((ListNumber)data.getZValues()).getIndexes();
        this.setClip(g);
        for (int j = indexes.size() - 1; j >= 0; --j) {
            int i = indexes.getInt(j);
            double size = this.radiusScale(this.zPlotRange.getMinimum().doubleValue(), data.getZValues().getDouble(i), this.zPlotRange.getMaximum().doubleValue(), 3.0, 15.0);
            double x = this.scaledX(data.getXValues().getDouble(i));
            double y = this.scaledY(data.getYValues().getDouble(i));
            Shape bubble = this.createShape(x, y, size);
            this.newValue(x, y, size, i);
            g.setColor(new Color(labelColor.getColor(data.getLabels().get(i))));
            g.fill(bubble);
            g.setColor(Color.BLACK);
            g.draw(bubble);
        }
    }

    private double radiusScale(double minValue, double value, double maxValue, double minRadius, double maxRadius) {
        if (minValue < 0.0) {
            throw new UnsupportedOperationException("For now, the value for the size has to be always positive");
        }
        if (value <= minValue) {
            return minRadius;
        }
        if (value >= maxValue) {
            return maxRadius;
        }
        return minRadius + NumberUtil.scale(Math.sqrt(value), Math.sqrt(minValue), Math.sqrt(maxValue), maxRadius - minRadius);
    }

    protected void newValue(double x, double y, double size, int index) {
    }

    private Shape createShape(double x, double y, double size) {
        double halfSize = size / 2.0;
        Ellipse2D.Double circle = new Ellipse2D.Double(x - halfSize, y - halfSize, size, size);
        return circle;
    }

    @Override
    public Graph2DRendererUpdate newUpdate() {
        return new Graph2DRendererUpdate();
    }
}

