/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.ListNumbers;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;
import org.epics.graphene.Statistics;
import org.epics.graphene.StatisticsUtil;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListNumber;

public class Cell1DDatasets {
    public static Cell1DDataset linearRange(final ListNumber values, double minValue, double maxValue) {
        final Statistics statistics = StatisticsUtil.statisticsOf((CollectionNumber)values);
        final Range range = RangeUtil.range(minValue, maxValue);
        final ListNumber xBoundaries = ListNumbers.linearRange(minValue, maxValue, values.size() + 1);
        return new Cell1DDataset(){

            @Override
            public double getValue(int x) {
                return values.getDouble(x);
            }

            @Override
            public Statistics getStatistics() {
                return statistics;
            }

            @Override
            public ListNumber getXBoundaries() {
                return xBoundaries;
            }

            @Override
            public Range getXRange() {
                return range;
            }

            @Override
            public int getXCount() {
                return values.size();
            }
        };
    }
}

