/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.ListNumbers;
import org.epics.graphene.Range;
import org.epics.graphene.Statistics;
import org.epics.graphene.StatisticsUtil;
import org.epics.util.array.CollectionDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.IteratorDouble;
import org.epics.util.array.ListNumber;

public class Cell2DDatasets {
    public static Cell2DDataset linearRange(final Function2D function, final Range xRange, final int xCount, final Range yRange, final int yCount) {
        final ListNumber xBoundaries = ListNumbers.linearRange(xRange.getMinimum().doubleValue(), xRange.getMaximum().doubleValue(), xCount + 1);
        final ListNumber yBoundaries = ListNumbers.linearRange(yRange.getMinimum().doubleValue(), yRange.getMaximum().doubleValue(), yCount + 1);
        final double xHalfStep = (xBoundaries.getDouble(1) - xBoundaries.getDouble(0)) / 2.0;
        final double yHalfStep = (yBoundaries.getDouble(1) - yBoundaries.getDouble(0)) / 2.0;
        CollectionDouble data = new CollectionDouble(){

            public IteratorDouble iterator() {
                return new IteratorDouble(){
                    int x;
                    int y;

                    public boolean hasNext() {
                        return this.y < yCount;
                    }

                    public double nextDouble() {
                        double value = function.getValue(xBoundaries.getDouble(this.x) + xHalfStep, yBoundaries.getDouble(this.y) + yHalfStep);
                        ++this.x;
                        if (this.x == xCount) {
                            this.x = 0;
                            ++this.y;
                        }
                        return value;
                    }
                };
            }

            public int size() {
                return xCount * yCount;
            }
        };
        final Statistics stats = StatisticsUtil.statisticsOf((CollectionNumber)data);
        return new Cell2DDataset(){

            @Override
            public double getValue(int x, int y) {
                return function.getValue(xBoundaries.getDouble(x) + xHalfStep, yBoundaries.getDouble(y) + yHalfStep);
            }

            @Override
            public Statistics getStatistics() {
                return stats;
            }

            @Override
            public ListNumber getXBoundaries() {
                return xBoundaries;
            }

            @Override
            public Range getXRange() {
                return xRange;
            }

            @Override
            public int getXCount() {
                return xCount;
            }

            @Override
            public ListNumber getYBoundaries() {
                return yBoundaries;
            }

            @Override
            public Range getYRange() {
                return yRange;
            }

            @Override
            public int getYCount() {
                return yCount;
            }
        };
    }

    public static interface Function2D {
        public double getValue(double var1, double var3);
    }
}

