/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.AxisRange;
import org.epics.graphene.AxisRanges;
import org.epics.graphene.FontUtil;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.Java2DStringUtilities;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;
import org.epics.graphene.ValueAxis;
import org.epics.graphene.ValueScale;
import org.epics.graphene.ValueScales;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;

public abstract class Graph2DRenderer<T extends Graph2DRendererUpdate> {
    protected double xPlotValueStart;
    protected double yPlotValueStart;
    protected double xPlotValueEnd;
    protected double yPlotValueEnd;
    protected double yPlotCoordHeight;
    protected double xPlotCoordWidth;
    protected double xPlotCoordStart;
    protected double yPlotCoordStart;
    protected double yPlotCoordEnd;
    protected double xPlotCoordEnd;
    protected int xAreaStart;
    protected int yAreaStart;
    protected int yAreaEnd;
    protected int xAreaEnd;
    protected Graphics2D g;
    private int imageWidth;
    private int imageHeight;
    private AxisRange xAxisRange = AxisRanges.integrated();
    private AxisRange yAxisRange = AxisRanges.integrated();
    private ValueScale xValueScale = ValueScales.linearScale();
    private ValueScale yValueScale = ValueScales.linearScale();
    protected Color backgroundColor = Color.WHITE;
    protected Color labelColor = Color.BLACK;
    protected Color referenceLineColor = new Color(240, 240, 240);
    protected Font labelFont = FontUtil.getLiberationSansRegular();
    protected int bottomMargin = 2;
    protected int topMargin = 2;
    protected int leftMargin = 2;
    protected int rightMargin = 2;
    protected int bottomAreaMargin = 0;
    protected int topAreaMargin = 0;
    protected int leftAreaMargin = 0;
    protected int rightAreaMargin = 0;
    protected int xLabelMargin = 3;
    protected int yLabelMargin = 3;
    private Range xAggregatedRange;
    private Range yAggregatedRange;
    private Range xPlotRange;
    private Range yPlotRange;
    protected FontMetrics labelFontMetrics;
    protected ListDouble xReferenceCoords;
    protected ListDouble xReferenceValues;
    protected List<String> xReferenceLabels;
    protected ListDouble yReferenceCoords;
    protected ListDouble yReferenceValues;
    protected List<String> yReferenceLabels;
    private int xLabelMaxHeight;
    private int yLabelMaxWidth;
    private static final int MIN = 0;
    private static final int MAX = 1;

    public Graph2DRenderer(int graphWidth, int graphHeight) {
        this.imageWidth = graphWidth;
        this.imageHeight = graphHeight;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public AxisRange getXAxisRange() {
        return this.xAxisRange;
    }

    public AxisRange getYAxisRange() {
        return this.yAxisRange;
    }

    public Range getXAggregatedRange() {
        return this.xAggregatedRange;
    }

    public Range getYAggregatedRange() {
        return this.yAggregatedRange;
    }

    public Range getXPlotRange() {
        return this.xPlotRange;
    }

    public Range getYPlotRange() {
        return this.yPlotRange;
    }

    public void update(T update) {
        if (((Graph2DRendererUpdate)update).getImageHeight() != null) {
            this.imageHeight = ((Graph2DRendererUpdate)update).getImageHeight();
        }
        if (((Graph2DRendererUpdate)update).getImageWidth() != null) {
            this.imageWidth = ((Graph2DRendererUpdate)update).getImageWidth();
        }
        if (((Graph2DRendererUpdate)update).getXAxisRange() != null) {
            this.xAxisRange = ((Graph2DRendererUpdate)update).getXAxisRange();
        }
        if (((Graph2DRendererUpdate)update).getYAxisRange() != null) {
            this.yAxisRange = ((Graph2DRendererUpdate)update).getYAxisRange();
        }
        if (((Graph2DRendererUpdate)update).getXValueScale() != null) {
            this.xValueScale = ((Graph2DRendererUpdate)update).getXValueScale();
        }
        if (((Graph2DRendererUpdate)update).getYValueScale() != null) {
            this.yValueScale = ((Graph2DRendererUpdate)update).getYValueScale();
        }
    }

    static Range aggregateRange(Range dataRange, Range aggregatedRange) {
        if (aggregatedRange == null) {
            return dataRange;
        }
        return RangeUtil.sum(dataRange, aggregatedRange);
    }

    public abstract T newUpdate();

    protected void calculateRanges(Range xDataRange, Range yDataRange) {
        this.xAggregatedRange = Graph2DRenderer.aggregateRange(xDataRange, this.xAggregatedRange);
        this.yAggregatedRange = Graph2DRenderer.aggregateRange(yDataRange, this.yAggregatedRange);
        this.xPlotRange = this.xAxisRange.axisRange(xDataRange, this.xAggregatedRange);
        this.yPlotRange = this.yAxisRange.axisRange(yDataRange, this.yAggregatedRange);
    }

    protected void drawHorizontalReferenceLines() {
        this.g.setColor(this.referenceLineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ListDouble yTicks = this.yReferenceCoords;
        for (int i = 0; i < yTicks.size(); ++i) {
            Line2D.Double line = new Line2D.Double(this.xAreaStart, yTicks.getDouble(i), this.xAreaEnd, yTicks.getDouble(i));
            this.g.draw(line);
        }
    }

    protected void drawVerticalReferenceLines() {
        this.g.setColor(this.referenceLineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ListDouble xTicks = this.xReferenceCoords;
        for (int i = 0; i < xTicks.size(); ++i) {
            Line2D.Double line = new Line2D.Double(xTicks.getDouble(i), this.yAreaStart, xTicks.getDouble(i), this.yAreaEnd);
            this.g.draw(line);
        }
    }

    protected void calculateGraphArea() {
        ValueAxis xAxis = this.xValueScale.references(this.xPlotRange, 2, Math.max(2, this.getImageWidth() / 60));
        ValueAxis yAxis = this.yValueScale.references(this.yPlotRange, 2, Math.max(2, this.getImageHeight() / 60));
        this.xReferenceLabels = Arrays.asList(xAxis.getTickLabels());
        this.yReferenceLabels = Arrays.asList(yAxis.getTickLabels());
        this.xReferenceValues = new ArrayDouble(xAxis.getTickValues());
        this.yReferenceValues = new ArrayDouble(yAxis.getTickValues());
        this.labelFontMetrics = this.g.getFontMetrics(this.labelFont);
        this.xLabelMaxHeight = this.labelFontMetrics.getHeight() - this.labelFontMetrics.getLeading();
        int areaFromBottom = this.bottomMargin + this.xLabelMaxHeight + this.xLabelMargin;
        int[] yLabelWidths = new int[this.yReferenceLabels.size()];
        this.yLabelMaxWidth = 0;
        for (int i = 0; i < yLabelWidths.length; ++i) {
            yLabelWidths[i] = this.labelFontMetrics.stringWidth(this.yReferenceLabels.get(i));
            this.yLabelMaxWidth = Math.max(this.yLabelMaxWidth, yLabelWidths[i]);
        }
        int areaFromLeft = this.leftMargin + this.yLabelMaxWidth + this.yLabelMargin;
        this.xPlotValueStart = this.getXPlotRange().getMinimum().doubleValue();
        this.yPlotValueStart = this.getYPlotRange().getMinimum().doubleValue();
        this.xPlotValueEnd = this.getXPlotRange().getMaximum().doubleValue();
        this.yPlotValueEnd = this.getYPlotRange().getMaximum().doubleValue();
        this.xAreaStart = areaFromLeft;
        this.yAreaStart = this.topMargin;
        this.xAreaEnd = this.getImageWidth() - this.rightMargin - 1;
        this.yAreaEnd = this.getImageHeight() - areaFromBottom - 1;
        this.xPlotCoordStart = (double)(this.xAreaStart + this.topAreaMargin) + 0.5;
        this.yPlotCoordStart = (double)(this.yAreaStart + this.leftAreaMargin) + 0.5;
        this.xPlotCoordEnd = (double)(this.xAreaEnd - this.bottomAreaMargin) + 0.5;
        this.yPlotCoordEnd = (double)(this.yAreaEnd - this.rightAreaMargin) + 0.5;
        this.xPlotCoordWidth = this.xPlotCoordEnd - this.xPlotCoordStart;
        this.yPlotCoordHeight = this.yPlotCoordEnd - this.yPlotCoordStart;
        double[] xRefCoords = new double[this.xReferenceValues.size()];
        for (int i = 0; i < xRefCoords.length; ++i) {
            xRefCoords[i] = this.scaledX(this.xReferenceValues.getDouble(i));
        }
        this.xReferenceCoords = new ArrayDouble(xRefCoords);
        double[] yRefCoords = new double[this.yReferenceValues.size()];
        for (int i = 0; i < yRefCoords.length; ++i) {
            yRefCoords[i] = this.scaledY(this.yReferenceValues.getDouble(i));
        }
        this.yReferenceCoords = new ArrayDouble(yRefCoords);
    }

    protected void drawBackground() {
        this.g.setColor(this.backgroundColor);
        this.g.fillRect(0, 0, this.getImageWidth(), this.getImageHeight());
    }

    protected void drawGraphArea() {
        this.drawBackground();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawVerticalReferenceLines();
        this.drawHorizontalReferenceLines();
        this.drawYLabels();
        this.drawXLabels();
    }

    protected void drawValueLine(ListNumber xValues, ListNumber yValues, InterpolationScheme interpolation) {
        Path2D.Double path;
        int dataCount = xValues.size();
        double[] scaledX = new double[dataCount];
        double[] scaledY = new double[dataCount];
        for (int i = 0; i < scaledY.length; ++i) {
            scaledX[i] = this.scaledX(xValues.getDouble(i));
            scaledY[i] = this.scaledY(yValues.getDouble(i));
        }
        switch (interpolation) {
            default: {
                path = Graph2DRenderer.nearestNeighbour(scaledX, scaledY);
                break;
            }
            case LINEAR: {
                path = Graph2DRenderer.linearInterpolation(scaledX, scaledY);
                break;
            }
            case CUBIC: {
                path = Graph2DRenderer.cubicInterpolation(scaledX, scaledY);
            }
        }
        this.g.draw(path);
    }

    private static Path2D.Double nearestNeighbour(double[] scaledX, double[] scaledY) {
        Path2D.Double line = new Path2D.Double();
        line.moveTo(scaledX[0], scaledY[0]);
        for (int i = 1; i < scaledY.length; ++i) {
            double halfX = scaledX[i - 1] + (scaledX[i] - scaledX[i - 1]) / 2.0;
            if (!Double.isNaN(scaledY[i - 1])) {
                line.lineTo(halfX, scaledY[i - 1]);
                if (Double.isNaN(scaledY[i])) continue;
                line.lineTo(halfX, scaledY[i]);
                continue;
            }
            line.moveTo(halfX, scaledY[i]);
        }
        line.lineTo(scaledX[scaledX.length - 1], scaledY[scaledY.length - 1]);
        return line;
    }

    private static Path2D.Double linearInterpolation(double[] scaledX, double[] scaledY) {
        Path2D.Double line = new Path2D.Double();
        line.moveTo(scaledX[0], scaledY[0]);
        for (int i = 1; i < scaledY.length; ++i) {
            line.lineTo(scaledX[i], scaledY[i]);
        }
        return line;
    }

    private static Path2D.Double cubicInterpolation(double[] scaledX, double[] scaledY) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(scaledX[0], scaledY[0]);
        for (int i = 1; i < scaledY.length; ++i) {
            double x3;
            double y3;
            double x0;
            double y0;
            double y1 = scaledY[i - 1];
            double y2 = scaledY[i];
            double x1 = scaledX[i - 1];
            double x2 = scaledX[i];
            if (i > 1) {
                y0 = scaledY[i - 2];
                x0 = scaledX[i - 2];
            } else {
                y0 = y1 - (y2 - y1) / 2.0;
                x0 = x1 - (x2 - x1);
            }
            if (i < scaledY.length - 1) {
                y3 = scaledY[i + 1];
                x3 = scaledX[i + 1];
            } else {
                y3 = y2 + (y2 - y1) / 2.0;
                x3 = x2 + (x2 - x1) / 2.0;
            }
            double bx0 = x1;
            double by0 = y1;
            double bx3 = x2;
            double by3 = y2;
            double bdy0 = (y2 - y0) / (x2 - x0);
            double bdy3 = (y3 - y1) / (x3 - x1);
            double bx1 = bx0 + (x2 - x0) / 6.0;
            double by1 = (bx1 - bx0) * bdy0 + by0;
            double bx2 = bx3 - (x3 - x1) / 6.0;
            double by2 = (bx2 - bx3) * bdy3 + by3;
            path.curveTo(bx1, by1, bx2, by2, bx3, by3);
        }
        return path;
    }

    private static void drawHorizontalReferencesLabel(Graphics2D graphics, FontMetrics metrics, String text, int yCenter, int[] drawRange, int xRight, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < yCenter || drawRange[0] > yCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.RIGHT;
        int targetY = yCenter;
        int halfHeight = metrics.getAscent() / 2;
        if (yCenter < drawRange[0] + halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetY = drawRange[0];
        } else if (yCenter > drawRange[1] - halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.BOTTOM_RIGHT;
            targetY = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, xRight, targetY, text);
        if (updateMin) {
            drawRange[1] = targetY - metrics.getHeight();
        } else {
            drawRange[0] = targetY + metrics.getHeight();
        }
    }

    private static void drawVerticalReferenceLabel(Graphics2D graphics, FontMetrics metrics, String text, int xCenter, int[] drawRange, int yTop, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < xCenter || drawRange[0] > xCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.TOP;
        int targetX = xCenter;
        int halfWidth = metrics.stringWidth(text) / 2;
        if (xCenter < drawRange[0] + halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_LEFT;
            targetX = drawRange[0];
        } else if (xCenter > drawRange[1] - halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetX = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, targetX, yTop, text);
        if (updateMin) {
            drawRange[0] = targetX + metrics.getHeight();
        } else {
            drawRange[1] = targetX - metrics.getHeight();
        }
    }

    protected final double scaledX(double value) {
        return this.xValueScale.scaleValue(value, this.xPlotValueStart, this.xPlotValueEnd, this.xPlotCoordStart, this.xPlotCoordEnd);
    }

    protected final double scaledY(double value) {
        return this.yValueScale.scaleValue(value, this.yPlotValueStart, this.yPlotValueEnd, this.yPlotCoordEnd, this.yPlotCoordStart);
    }

    protected void setClip(Graphics2D g) {
        g.setClip(this.xAreaStart, this.yAreaStart, this.xAreaEnd - this.xAreaStart + 1, this.yAreaEnd - this.yAreaStart + 1);
    }

    protected void drawYLabels() {
        ListDouble yTicks = this.yReferenceCoords;
        if (this.yReferenceLabels != null && !this.yReferenceLabels.isEmpty()) {
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{this.yAreaStart, this.yAreaEnd};
            int xRightLabel = this.xAreaStart - this.yLabelMargin - 1;
            Graph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.yReferenceLabels.get(0), (int)Math.floor(yTicks.getDouble(0)), drawRange, xRightLabel, true, false);
            Graph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.yReferenceLabels.get(this.yReferenceLabels.size() - 1), (int)Math.floor(yTicks.getDouble(this.yReferenceLabels.size() - 1)), drawRange, xRightLabel, false, false);
            for (int i = 1; i < this.yReferenceLabels.size() - 1; ++i) {
                Graph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.yReferenceLabels.get(i), (int)Math.floor(yTicks.getDouble(i)), drawRange, xRightLabel, true, false);
            }
        }
    }

    protected void drawXLabels() {
        ListDouble xTicks = this.xReferenceCoords;
        if (this.xReferenceLabels != null && !this.xReferenceLabels.isEmpty()) {
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{this.xAreaStart, this.xAreaEnd};
            int yTop = this.yAreaEnd + this.xLabelMargin + 1;
            Graph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.xReferenceLabels.get(0), (int)Math.floor(xTicks.getDouble(0)), drawRange, yTop, true, false);
            Graph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.xReferenceLabels.get(this.xReferenceLabels.size() - 1), (int)Math.floor(xTicks.getDouble(this.xReferenceLabels.size() - 1)), drawRange, yTop, false, false);
            for (int i = 1; i < this.xReferenceLabels.size() - 1; ++i) {
                Graph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.xReferenceLabels.get(i), (int)Math.floor(xTicks.getDouble(i)), drawRange, yTop, true, false);
            }
        }
    }
}

