/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.LineGraph2DRendererUpdate;
import org.epics.graphene.Point2DDataset;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.array.SortedListView;

public class LineGraph2DRenderer
extends Graph2DRenderer<LineGraph2DRendererUpdate> {
    public static List<InterpolationScheme> supportedInterpolationScheme = Arrays.asList(InterpolationScheme.NEAREST_NEIGHBOUR, InterpolationScheme.LINEAR, InterpolationScheme.CUBIC);
    private InterpolationScheme interpolation = InterpolationScheme.NEAREST_NEIGHBOUR;

    @Override
    public LineGraph2DRendererUpdate newUpdate() {
        return new LineGraph2DRendererUpdate();
    }

    public LineGraph2DRenderer(int imageWidth, int imageHeight) {
        super(imageWidth, imageHeight);
    }

    public InterpolationScheme getInterpolation() {
        return this.interpolation;
    }

    @Override
    public void update(LineGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getInterpolation() != null) {
            this.interpolation = update.getInterpolation();
        }
    }

    public void draw(Graphics2D g, Point2DDataset data) {
        this.g = g;
        this.calculateRanges(data.getXStatistics(), data.getYStatistics());
        this.calculateGraphArea();
        this.drawBackground();
        this.drawGraphArea();
        SortedListView xValues = ListNumbers.sortedView((ListNumber)data.getXValues());
        SortedListView yValues = ListNumbers.sortedView((ListNumber)data.getYValues(), (ListInt)xValues.getIndexes());
        this.setClip(g);
        g.setColor(Color.BLACK);
        this.drawValueLine((ListNumber)xValues, (ListNumber)yValues, this.interpolation);
    }
}

