/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.epics.graphene.Range;
import org.epics.graphene.TimeAxis;
import org.epics.graphene.TimeScale;
import org.epics.graphene.ValueAxis;
import org.epics.util.text.NumberFormats;
import org.epics.util.time.TimeInterval;
import org.epics.util.time.Timestamp;

final class LinearAbsoluteTimeScale
implements TimeScale {
    private static final DecimalFormat defaultFormat = new DecimalFormat("0.###");

    LinearAbsoluteTimeScale() {
    }

    public double scaleValue(double value, double minValue, double maxValue, double newMinValue, double newMaxValue) {
        double oldRange = maxValue - minValue;
        double newRange = newMaxValue - newMinValue;
        return newMinValue + (value - minValue) / oldRange * newRange;
    }

    public ValueAxis references(Range range, int minRefs, int maxRefs) {
        double minIncrement;
        double increment;
        double maxValue;
        double minValue = range.getMinimum().doubleValue();
        double[] ticks = LinearAbsoluteTimeScale.createTicks(minValue, maxValue = range.getMaximum().doubleValue(), increment = LinearAbsoluteTimeScale.incrementForRange(minValue, maxValue, maxRefs, minIncrement = Double.MIN_VALUE));
        if (ticks.length < 2) {
            ticks = LinearAbsoluteTimeScale.createSmallerTicks(minValue, maxValue, increment);
        }
        int rangeOrder = (int)LinearAbsoluteTimeScale.orderOfMagnitude(minValue, maxValue);
        int incrementOrder = (int)LinearAbsoluteTimeScale.orderOfMagnitude(increment);
        int nDigits = rangeOrder - incrementOrder;
        NumberFormat format = defaultFormat;
        double normalization = 1.0;
        String exponent = null;
        if (rangeOrder >= -3 && rangeOrder <= 3) {
            format = incrementOrder < 0 ? NumberFormats.format((int)(-incrementOrder)) : NumberFormats.format((int)0);
        } else if (rangeOrder > 3) {
            format = NumberFormats.format((int)nDigits);
            normalization = Math.pow(10.0, rangeOrder);
            exponent = Integer.toString(rangeOrder);
        } else if (rangeOrder < -3) {
            format = NumberFormats.format((int)nDigits);
            normalization = Math.pow(10.0, rangeOrder);
            exponent = Integer.toString(rangeOrder);
        }
        String[] labels = new String[ticks.length];
        for (int i = 0; i < ticks.length; ++i) {
            double value = ticks[i];
            labels[i] = LinearAbsoluteTimeScale.format(value, format, exponent, normalization);
        }
        return new ValueAxis(minValue, maxValue, ticks, labels);
    }

    static String format(double number, NumberFormat format, String exponent, double normalization) {
        if (exponent != null) {
            return format.format(number / normalization) + "e" + exponent;
        }
        return format.format(number / normalization);
    }

    static double incrementForRange(double min, double max, int maxTick, double minIncrement) {
        int order;
        BigDecimal magnitude;
        double range = max - min;
        double increment = Math.max(range / (double)maxTick, minIncrement);
        double normalizedIncrement = increment / (magnitude = BigDecimal.ONE.scaleByPowerOfTen(order = (int)LinearAbsoluteTimeScale.orderOfMagnitude(increment))).doubleValue();
        if (normalizedIncrement <= 1.0) {
            return magnitude.doubleValue();
        }
        if (normalizedIncrement <= 2.0) {
            return magnitude.multiply(BigDecimal.valueOf(2L)).doubleValue();
        }
        if (normalizedIncrement <= 5.0) {
            return magnitude.multiply(BigDecimal.valueOf(5L)).doubleValue();
        }
        return magnitude.multiply(BigDecimal.valueOf(10L)).doubleValue();
    }

    static double orderOfMagnitude(double value) {
        return Math.floor(Math.log10(value));
    }

    static double orderOfMagnitude(double min, double max) {
        return LinearAbsoluteTimeScale.orderOfMagnitude(Math.max(Math.abs(max), Math.abs(min)));
    }

    static double[] createTicks(double min, double max, double increment) {
        long start = (long)Math.ceil(min / increment);
        long end = (long)Math.floor(max / increment);
        double[] ticks = new double[(int)(end - start + 1L)];
        for (int i = 0; i < ticks.length; ++i) {
            ticks[i] = (double)((long)i + start) * increment;
        }
        return ticks;
    }

    private static double[] createSmallerTicks(double minValue, double maxValue, double increment) {
        int order = (int)LinearAbsoluteTimeScale.orderOfMagnitude(increment);
        BigDecimal magnitude = BigDecimal.ONE.scaleByPowerOfTen(order);
        double normalizedIncrement = increment / magnitude.doubleValue();
        double smallerIncrement = normalizedIncrement < 1.1 ? BigDecimal.ONE.scaleByPowerOfTen(order - 1).multiply(BigDecimal.valueOf(5L)).doubleValue() : (normalizedIncrement < 2.1 ? magnitude.doubleValue() : (normalizedIncrement < 5.1 ? magnitude.multiply(BigDecimal.valueOf(2L)).doubleValue() : magnitude.multiply(BigDecimal.valueOf(5L)).doubleValue()));
        return LinearAbsoluteTimeScale.createTicks(minValue, maxValue, smallerIncrement);
    }

    @Override
    public double scaleNormalizedTime(double value, double newMinValue, double newMaxValue) {
        double newRange = newMaxValue - newMinValue;
        return newMinValue + value * newRange;
    }

    @Override
    public double scaleTimestamp(Timestamp value, TimeInterval timeInterval, double newMinValue, double newMaxValue) {
        double fromStart = value.durationFrom(timeInterval.getStart()).toSeconds();
        double range = timeInterval.getEnd().durationFrom(timeInterval.getStart()).toSeconds();
        double newRange = newMaxValue - newMinValue;
        return newMinValue + fromStart / range * newRange;
    }

    @Override
    public TimeAxis references(TimeInterval range, int minRefs, int maxRefs) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

