/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;

public class ListNumbers {
    public static ListNumber linearRange(final double minValue, final double maxValue, final int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive (was " + size + " )");
        }
        return new ListDouble(){

            public double getDouble(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                return minValue + (double)index * (maxValue - minValue) / (double)(size - 1);
            }

            public int size() {
                return size;
            }
        };
    }

    public static ListNumber linearList(final double initialValue, final double increment, final int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive (was " + size + " )");
        }
        return new ListDouble(){

            public double getDouble(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                return initialValue + (double)index * increment;
            }

            public int size() {
                return size;
            }
        };
    }
}

