/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.Iterators;
import org.epics.util.array.IteratorDouble;

public class NumberUtil {
    public static double normalize(double value, double min, double max) {
        return (value - min) / (max - min);
    }

    public static double scale(double value, double min, double max, double newWidth) {
        return (value - min) * newWidth / (max - min);
    }

    public static int[] minMax(int[] array) {
        if (array.length == 0) {
            return null;
        }
        int[] minMax = new int[]{array[0], array[0]};
        for (int i = 1; i < array.length; ++i) {
            int value = array[i];
            if (value > minMax[1]) {
                minMax[1] = value;
            }
            if (value >= minMax[0]) continue;
            minMax[0] = value;
        }
        return minMax;
    }

    public static double[] minMax(double[] array) {
        return NumberUtil.minMax(Iterators.arrayIterator(array));
    }

    public static double[] minMax(IteratorDouble iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        double firstValue = iterator.nextDouble();
        double[] minMax = new double[]{firstValue, firstValue};
        while (iterator.hasNext()) {
            double value = iterator.nextDouble();
            if (value > minMax[1]) {
                minMax[1] = value;
            }
            if (!(value < minMax[0])) continue;
            minMax[0] = value;
        }
        return minMax;
    }
}

