/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.ListNumbers;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Statistics;
import org.epics.graphene.StatisticsUtil;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListNumber;

public class Point2DDatasets {
    public static Point2DDataset lineData(double[] data) {
        return Point2DDatasets.lineData((ListNumber)new ArrayDouble(data));
    }

    public static Point2DDataset lineData(ListNumber data) {
        return Point2DDatasets.lineData(ListNumbers.linearList(0.0, 1.0, data.size()), data);
    }

    public static Point2DDataset lineData(double[] data, double xInitialOffset, double xIncrementSize) {
        return Point2DDatasets.lineData((ListNumber)new ArrayDouble(data), xInitialOffset, xIncrementSize);
    }

    public static Point2DDataset lineData(ListNumber data, double xInitialOffset, double xIncrementSize) {
        return Point2DDatasets.lineData(ListNumbers.linearList(xInitialOffset, xIncrementSize, data.size()), data);
    }

    public static Point2DDataset lineData(double[] x, double[] y) {
        return Point2DDatasets.lineData((ListNumber)new ArrayDouble(x), (ListNumber)new ArrayDouble(y));
    }

    public static Point2DDataset lineData(final ListNumber x, final ListNumber y) {
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("Arrays length don't match: " + x.size() + " - " + y.size());
        }
        return new Point2DDataset(){
            private final Statistics xStatistics;
            private final Statistics yStatistics;
            {
                this.xStatistics = StatisticsUtil.statisticsOf((CollectionNumber)x);
                this.yStatistics = StatisticsUtil.statisticsOf((CollectionNumber)y);
            }

            @Override
            public ListNumber getXValues() {
                return x;
            }

            @Override
            public ListNumber getYValues() {
                return y;
            }

            @Override
            public Statistics getXStatistics() {
                return this.xStatistics;
            }

            @Override
            public Statistics getYStatistics() {
                return this.yStatistics;
            }

            @Override
            public int getCount() {
                return x.size();
            }
        };
    }
}

