/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import org.epics.graphene.NumberUtil;
import org.epics.graphene.Range;
import org.epics.graphene.ValueColorScheme;

public class ValueColorSchemes {
    public static ValueColorScheme grayScale(Range range) {
        return ValueColorSchemes.singleRangeGradient(range, Color.BLACK, Color.WHITE, Color.RED);
    }

    public static ValueColorScheme singleRangeGradient(final Range range, final Color minValueColor, final Color maxValueColor, final Color nanColor) {
        return new ValueColorScheme(){

            @Override
            public int colorFor(double value) {
                if (Double.isNaN(value)) {
                    return nanColor.getRGB();
                }
                double normalValue = NumberUtil.normalize(value, range.getMinimum().doubleValue(), range.getMaximum().doubleValue());
                normalValue = Math.min(normalValue, 1.0);
                normalValue = Math.max(normalValue, 0.0);
                int alpha = 255;
                int red = (int)((double)minValueColor.getRed() + (double)(maxValueColor.getRed() - minValueColor.getRed()) * normalValue);
                int green = (int)((double)minValueColor.getGreen() + (double)(maxValueColor.getGreen() - minValueColor.getGreen()) * normalValue);
                int blue = (int)((double)minValueColor.getBlue() + (double)(maxValueColor.getBlue() - minValueColor.getBlue()) * normalValue);
                return alpha << 24 | red << 16 | green << 8 | blue;
            }
        };
    }
}

