/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.HorizontalAxisRenderer;
import org.epics.graphene.IntensityGraph2DRendererUpdate;
import org.epics.graphene.ValueAxis;
import org.epics.graphene.ValueColorScheme;
import org.epics.graphene.ValueColorSchemes;
import org.epics.graphene.VerticalAxisRenderer;

public class IntensityGraph2DRenderer {
    private int width = 300;
    private int height = 200;
    private ValueColorScheme colorScheme;
    private boolean rangeFromDataset = true;
    private double startPlotX = Double.MIN_VALUE;
    private double endPlotX = Double.MAX_VALUE;
    private double startPlotY = Double.MIN_VALUE;
    private double endPlotY = Double.MAX_VALUE;
    private double integratedMinX = Double.MAX_VALUE;
    private double integratedMinY = Double.MAX_VALUE;
    private double integratedMaxX = Double.MIN_VALUE;
    private double integratedMaxY = Double.MIN_VALUE;

    public IntensityGraph2DRenderer(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public IntensityGraph2DRenderer() {
        this(300, 200);
    }

    public int getImageHeight() {
        return this.height;
    }

    public int getImageWidth() {
        return this.width;
    }

    public double getEndPlotX() {
        return this.endPlotX;
    }

    public double getEndPlotY() {
        return this.endPlotY;
    }

    public double getIntegratedMaxX() {
        return this.integratedMaxX;
    }

    public double getIntegratedMaxY() {
        return this.integratedMaxY;
    }

    public double getIntegratedMinX() {
        return this.integratedMinX;
    }

    public double getIntegratedMinY() {
        return this.integratedMinY;
    }

    public double getStartPlotX() {
        return this.startPlotX;
    }

    public double getStartPlotY() {
        return this.startPlotY;
    }

    public void update(IntensityGraph2DRendererUpdate update) {
        if (update.getImageHeight() != null) {
            this.height = update.getImageHeight();
        }
        if (update.getImageWidth() != null) {
            this.width = update.getImageWidth();
        }
        if (update.isRangeFromDataset() != null) {
            this.rangeFromDataset = update.isRangeFromDataset();
        }
        if (update.getStartX() != null) {
            this.startPlotX = update.getStartX();
        }
        if (update.getStartY() != null) {
            this.startPlotY = update.getStartY();
        }
        if (update.getEndX() != null) {
            this.endPlotX = update.getEndX();
        }
        if (update.getEndY() != null) {
            this.endPlotY = update.getEndY();
        }
    }

    public void draw(Graphics2D g, Cell2DDataset data) {
        int initCellHeight;
        int[] yTicks;
        int[] xTicks;
        double endYPlot;
        double endXPlot;
        double startYPlot;
        double startXPlot;
        this.integratedMinX = Double.isNaN(data.getXRange().getMinimum().doubleValue()) ? this.integratedMinX : Math.min(this.integratedMinX, data.getXRange().getMinimum().doubleValue());
        this.integratedMinY = Double.isNaN(data.getYRange().getMinimum().doubleValue()) ? this.integratedMinY : Math.min(this.integratedMinY, data.getYRange().getMinimum().doubleValue());
        this.integratedMaxX = Double.isNaN(data.getXRange().getMaximum().doubleValue()) ? this.integratedMaxX : Math.max(this.integratedMaxX, data.getXRange().getMaximum().doubleValue());
        double d = this.integratedMaxY = Double.isNaN(data.getYRange().getMaximum().doubleValue()) ? this.integratedMaxY : Math.max(this.integratedMaxY, data.getYRange().getMaximum().doubleValue());
        if (this.rangeFromDataset) {
            startXPlot = this.integratedMinX;
            startYPlot = this.integratedMinY;
            endXPlot = this.integratedMaxX;
            endYPlot = this.integratedMaxY;
        } else {
            startXPlot = this.startPlotX;
            startYPlot = this.startPlotY;
            endXPlot = this.endPlotX;
            endYPlot = this.endPlotY;
        }
        int margin = 3;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.BLACK);
        ValueAxis xAxis = ValueAxis.createAutoAxis(startXPlot, endXPlot, Math.max(2, this.width / 60));
        ValueAxis yAxis = ValueAxis.createAutoAxis(startYPlot, endYPlot, Math.max(2, this.height / 60));
        HorizontalAxisRenderer xAxisRenderer = new HorizontalAxisRenderer(xAxis, margin, g);
        VerticalAxisRenderer yAxisRenderer = new VerticalAxisRenderer(yAxis, margin, g);
        int xStartGraph = yAxisRenderer.getAxisWidth();
        int xEndGraph = this.width - margin;
        int yStartGraph = margin;
        int yEndGraph = this.height - xAxisRenderer.getAxisHeight();
        int plotWidth = xEndGraph - xStartGraph;
        int plotHeight = yEndGraph - yStartGraph;
        xAxisRenderer.draw(g, 0, xStartGraph, xEndGraph, this.width, yEndGraph);
        yAxisRenderer.draw(g, 0, yStartGraph, yEndGraph, this.height, xStartGraph);
        double rangeX = endXPlot - startXPlot;
        double rangeY = endYPlot - startYPlot;
        g.setColor(new Color(240, 240, 240));
        for (int xTick : xTicks = xAxisRenderer.horizontalTickPositions()) {
            g.drawLine(xTick, yStartGraph, xTick, yEndGraph);
        }
        for (int yTick : yTicks = yAxisRenderer.verticalTickPositions()) {
            g.drawLine(xStartGraph, this.height - yTick, xEndGraph, this.height - yTick);
        }
        this.colorScheme = ValueColorSchemes.grayScale(data.getStatistics());
        int countY = 0;
        int countX = 0;
        int xWidthTotal = xEndGraph - xStartGraph;
        int yHeightTotal = yEndGraph - yStartGraph;
        int xRange = data.getXBoundaries().getInt(data.getXCount()) - data.getXBoundaries().getInt(0);
        int yRange = data.getYBoundaries().getInt(data.getYCount()) - data.getYBoundaries().getInt(0);
        double initCellHeights = (data.getYBoundaries().getDouble(1) - data.getYBoundaries().getDouble(0)) * (double)yHeightTotal / (double)yRange;
        if (initCellHeights - (double)(initCellHeight = (int)Math.floor(initCellHeights)) > 0.5) {
            ++initCellHeight;
        }
        int yPosition = yEndGraph - initCellHeight;
        while ((double)countY <= data.getYBoundaries().getDouble(data.getYCount() - 1)) {
            int cellHeight;
            countX = 0;
            int xPosition = xStartGraph;
            double cellHeights = (data.getYBoundaries().getDouble(countY + 1) - data.getYBoundaries().getDouble(countY)) * (double)yHeightTotal / (double)yRange;
            if (cellHeights - (double)(cellHeight = (int)Math.floor(cellHeights)) > 0.5) {
                ++cellHeight;
            }
            while ((double)countX <= data.getXBoundaries().getDouble(data.getXCount() - 1)) {
                double cellWidths = (data.getXBoundaries().getDouble(countX + 1) - data.getXBoundaries().getDouble(countX)) * (double)xWidthTotal / (double)xRange;
                int cellWidth = (int)Math.floor(cellWidths);
                System.out.println(cellWidth);
                if (cellWidths - (double)cellWidth > 0.0) {
                    ++cellWidth;
                }
                System.out.println(cellWidth);
                g.setColor(new Color(this.colorScheme.colorFor(data.getValue(countX, countY))));
                g.fillRect(xPosition, yPosition, cellWidth, cellHeight);
                xPosition += cellWidth;
                ++countX;
            }
            yPosition -= cellHeight;
            ++countY;
        }
    }
}

