/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.Point1DDataset;
import org.epics.graphene.Point1DDatasetUpdate;
import org.epics.graphene.Statistics;
import org.epics.graphene.StatisticsUtil;
import org.epics.util.array.CircularBufferDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.IteratorNumber;
import org.epics.util.array.ListNumber;

public class Point1DCircularBuffer
implements Point1DDataset {
    private final CircularBufferDouble buffer;
    private Statistics statistics;

    public Point1DCircularBuffer(int capacity) {
        this.buffer = new CircularBufferDouble(capacity);
    }

    @Override
    public ListNumber getValues() {
        return this.buffer;
    }

    @Override
    public int getCount() {
        return this.buffer.size();
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    public void update(Point1DDatasetUpdate update) {
        if (update.isToClear()) {
            this.buffer.clear();
        }
        IteratorNumber iteratorDouble = update.getNewData();
        while (iteratorDouble.hasNext()) {
            this.buffer.addDouble(iteratorDouble.nextDouble());
        }
        this.statistics = StatisticsUtil.statisticsOf((CollectionNumber)this.getValues());
    }
}

