/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.NumberUtil;
import org.epics.graphene.Range;

public class RangeUtil {
    public static Range range(final double minValue, final double maxValue) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue should be less then or equal to maxValue (" + minValue + ", " + maxValue + ")");
        }
        return new Range(){

            @Override
            public Number getMinimum() {
                return minValue;
            }

            @Override
            public Number getMaximum() {
                return maxValue;
            }

            public String toString() {
                return RangeUtil.toString(this);
            }
        };
    }

    public static boolean contains(Range range, Range subrange) {
        return range.getMinimum().doubleValue() <= subrange.getMinimum().doubleValue() && range.getMaximum().doubleValue() >= subrange.getMaximum().doubleValue();
    }

    public static Range sum(Range range1, Range range2) {
        if (range1.getMinimum().doubleValue() <= range2.getMinimum().doubleValue()) {
            if (range1.getMaximum().doubleValue() >= range2.getMaximum().doubleValue()) {
                return range1;
            }
            return RangeUtil.range(range1.getMinimum().doubleValue(), range2.getMaximum().doubleValue());
        }
        if (range1.getMaximum().doubleValue() >= range2.getMaximum().doubleValue()) {
            return RangeUtil.range(range2.getMinimum().doubleValue(), range1.getMaximum().doubleValue());
        }
        return range2;
    }

    public static String toString(Range range) {
        return "[" + range.getMinimum() + " - " + range.getMaximum() + "]";
    }

    public static double normalize(Range range, double value) {
        return NumberUtil.normalize(value, range.getMinimum().doubleValue(), range.getMaximum().doubleValue());
    }

    public static double[] createBins(double min, double max, int nBins) {
        double increment = (max - min) / (double)nBins;
        double[] boundary = new double[nBins + 1];
        boundary[0] = min;
        for (int i = 1; i < boundary.length; ++i) {
            boundary[i] = min + (max - min) * (double)i / (double)nBins;
        }
        return boundary;
    }

    public static boolean contains(Range xRange, double value) {
        return value >= xRange.getMinimum().doubleValue() && value <= xRange.getMaximum().doubleValue();
    }
}

