/**
 * Copyright (C) 2012 Brookhaven National Laboratory
 * All rights reserved. Use is subject to license terms.
 */
package org.epics.graphene;

/**
 *
 * @author carcassi
 */
public class LineTimeGraph2DRendererUpdate extends TemporalGraph2DRendererUpdate<LineTimeGraph2DRendererUpdate> {

    private InterpolationScheme interpolation;
    
    public LineTimeGraph2DRendererUpdate interpolation(InterpolationScheme scheme) {
        if (scheme == null) {
            throw new NullPointerException("Interpolation scheme chan't be null");
        }
        if (!LineTimeGraph2DRenderer.supportedInterpolationScheme.contains(scheme)) {
            throw new IllegalArgumentException("Interpolation " + scheme + " is not supported");
        }
        this.interpolation = scheme;
        return this;
    }
    
    public InterpolationScheme getInterpolation() {
        return interpolation;
    }
    
}
