/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.epics.graphene.AxisRange;
import org.epics.graphene.AxisRanges;
import org.epics.graphene.FontUtil;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.Java2DStringUtilities;
import org.epics.graphene.MathIgnoreNaN;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;
import org.epics.graphene.ReductionScheme;
import org.epics.graphene.ValueAxis;
import org.epics.graphene.ValueScale;
import org.epics.graphene.ValueScales;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListMath;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;

public abstract class Graph2DRenderer<T extends Graph2DRendererUpdate> {
    protected double xPlotValueStart;
    protected double yPlotValueStart;
    protected double xPlotValueEnd;
    protected double yPlotValueEnd;
    protected int xAreaCoordStart;
    protected int yAreaCoordStart;
    protected int yAreaCoordEnd;
    protected int xAreaCoordEnd;
    protected double xPlotCoordStart;
    protected double yPlotCoordStart;
    protected double yPlotCoordEnd;
    protected double xPlotCoordEnd;
    protected double yPlotCoordHeight;
    protected double xPlotCoordWidth;
    protected Graphics2D g;
    private int imageWidth;
    private int imageHeight;
    private AxisRange xAxisRange = AxisRanges.integrated();
    private AxisRange yAxisRange = AxisRanges.integrated();
    private ValueScale xValueScale = ValueScales.linearScale();
    private ValueScale yValueScale = ValueScales.linearScale();
    protected Color backgroundColor = Color.WHITE;
    protected Color labelColor = Color.BLACK;
    protected Color referenceLineColor = new Color(240, 240, 240);
    protected Font labelFont = FontUtil.getLiberationSansRegular();
    protected int bottomMargin = 2;
    protected int topMargin = 2;
    protected int leftMargin = 2;
    protected int rightMargin = 2;
    protected int bottomAreaMargin = 0;
    protected int topAreaMargin = 0;
    protected int leftAreaMargin = 0;
    protected int rightAreaMargin = 0;
    protected int xLabelMargin = 3;
    protected int yLabelMargin = 3;
    protected double xPointMargin = 0.5;
    protected double yPointMargin = 0.5;
    private Range xAggregatedRange;
    private Range yAggregatedRange;
    private Range xPlotRange;
    private Range yPlotRange;
    protected FontMetrics labelFontMetrics;
    protected ListDouble xReferenceCoords;
    protected ListDouble xReferenceValues;
    protected List<String> xReferenceLabels;
    protected ListDouble yReferenceCoords;
    protected ListDouble yReferenceValues;
    protected List<String> yReferenceLabels;
    private int xLabelMaxHeight;
    private int yLabelMaxWidth;
    private boolean xAsPoints = true;
    private boolean yAsPoints = true;
    private static final int MIN = 0;
    private static final int MAX = 1;

    public Graph2DRenderer(int graphWidth, int graphHeight) {
        this.imageWidth = graphWidth;
        this.imageHeight = graphHeight;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public AxisRange getXAxisRange() {
        return this.xAxisRange;
    }

    public AxisRange getYAxisRange() {
        return this.yAxisRange;
    }

    public Range getXAggregatedRange() {
        return this.xAggregatedRange;
    }

    public Range getYAggregatedRange() {
        return this.yAggregatedRange;
    }

    public Range getXPlotRange() {
        return this.xPlotRange;
    }

    public Range getYPlotRange() {
        return this.yPlotRange;
    }

    public void update(T update) {
        if (((Graph2DRendererUpdate)update).getImageHeight() != null) {
            this.imageHeight = ((Graph2DRendererUpdate)update).getImageHeight();
        }
        if (((Graph2DRendererUpdate)update).getImageWidth() != null) {
            this.imageWidth = ((Graph2DRendererUpdate)update).getImageWidth();
        }
        if (((Graph2DRendererUpdate)update).getXAxisRange() != null) {
            this.xAxisRange = ((Graph2DRendererUpdate)update).getXAxisRange();
        }
        if (((Graph2DRendererUpdate)update).getYAxisRange() != null) {
            this.yAxisRange = ((Graph2DRendererUpdate)update).getYAxisRange();
        }
        if (((Graph2DRendererUpdate)update).getXValueScale() != null) {
            this.xValueScale = ((Graph2DRendererUpdate)update).getXValueScale();
        }
        if (((Graph2DRendererUpdate)update).getYValueScale() != null) {
            this.yValueScale = ((Graph2DRendererUpdate)update).getYValueScale();
        }
        if (((Graph2DRendererUpdate)update).getBackgroundColor() != null) {
            this.backgroundColor = ((Graph2DRendererUpdate)update).getBackgroundColor();
        }
        if (((Graph2DRendererUpdate)update).getLabelColor() != null) {
            this.labelColor = ((Graph2DRendererUpdate)update).getLabelColor();
        }
        if (((Graph2DRendererUpdate)update).getReferenceLineColor() != null) {
            this.referenceLineColor = ((Graph2DRendererUpdate)update).getReferenceLineColor();
        }
        if (((Graph2DRendererUpdate)update).getLabelFont() != null) {
            this.labelFont = ((Graph2DRendererUpdate)update).getLabelFont();
        }
        if (((Graph2DRendererUpdate)update).getBottomMargin() != null) {
            this.bottomMargin = ((Graph2DRendererUpdate)update).getBottomMargin();
        }
        if (((Graph2DRendererUpdate)update).getTopMargin() != null) {
            this.topMargin = ((Graph2DRendererUpdate)update).getTopMargin();
        }
        if (((Graph2DRendererUpdate)update).getLeftMargin() != null) {
            this.leftMargin = ((Graph2DRendererUpdate)update).getLeftMargin();
        }
        if (((Graph2DRendererUpdate)update).getRightMargin() != null) {
            this.rightMargin = ((Graph2DRendererUpdate)update).getRightMargin();
        }
        if (((Graph2DRendererUpdate)update).getBottomAreaMargin() != null) {
            this.bottomAreaMargin = ((Graph2DRendererUpdate)update).getBottomAreaMargin();
        }
        if (((Graph2DRendererUpdate)update).getTopAreaMargin() != null) {
            this.topAreaMargin = ((Graph2DRendererUpdate)update).getTopAreaMargin();
        }
        if (((Graph2DRendererUpdate)update).getLeftAreaMargin() != null) {
            this.leftAreaMargin = ((Graph2DRendererUpdate)update).getLeftAreaMargin();
        }
        if (((Graph2DRendererUpdate)update).getRightAreaMargin() != null) {
            this.rightAreaMargin = ((Graph2DRendererUpdate)update).getRightAreaMargin();
        }
        if (((Graph2DRendererUpdate)update).getXLabelMargin() != null) {
            this.xLabelMargin = ((Graph2DRendererUpdate)update).getXLabelMargin();
        }
        if (((Graph2DRendererUpdate)update).getYLabelMargin() != null) {
            this.yLabelMargin = ((Graph2DRendererUpdate)update).getYLabelMargin();
        }
    }

    static Range aggregateRange(Range dataRange, Range aggregatedRange) {
        if (aggregatedRange == null) {
            return dataRange;
        }
        return RangeUtil.sum(dataRange, aggregatedRange);
    }

    public abstract T newUpdate();

    protected void calculateRanges(Range xDataRange, Range yDataRange) {
        this.xAggregatedRange = Graph2DRenderer.aggregateRange(xDataRange, this.xAggregatedRange);
        this.yAggregatedRange = Graph2DRenderer.aggregateRange(yDataRange, this.yAggregatedRange);
        this.xPlotRange = this.xAxisRange.axisRange(xDataRange, this.xAggregatedRange);
        this.yPlotRange = this.yAxisRange.axisRange(yDataRange, this.yAggregatedRange);
    }

    protected void drawHorizontalReferenceLines() {
        this.g.setColor(this.referenceLineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ListDouble yTicks = this.yReferenceCoords;
        for (int i = 0; i < yTicks.size(); ++i) {
            Line2D.Double line = new Line2D.Double(this.xAreaCoordStart, yTicks.getDouble(i), this.xAreaCoordEnd - 1, yTicks.getDouble(i));
            this.g.draw(line);
        }
    }

    protected void drawVerticalReferenceLines() {
        this.g.setColor(this.referenceLineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ListDouble xTicks = this.xReferenceCoords;
        for (int i = 0; i < xTicks.size(); ++i) {
            Line2D.Double line = new Line2D.Double(xTicks.getDouble(i), this.yAreaCoordStart, xTicks.getDouble(i), this.yAreaCoordEnd - 1);
            this.g.draw(line);
        }
    }

    protected void calculateLabels() {
        if (!this.xPlotRange.getMinimum().equals(this.xPlotRange.getMaximum())) {
            ValueAxis xAxis = this.xValueScale.references(this.xPlotRange, 2, Math.max(2, this.getImageWidth() / 60));
            this.xReferenceLabels = Arrays.asList(xAxis.getTickLabels());
            this.xReferenceValues = new ArrayDouble(xAxis.getTickValues());
        } else {
            this.xReferenceLabels = Collections.singletonList(this.xPlotRange.getMinimum().toString());
            this.xReferenceValues = new ArrayDouble(new double[]{this.xPlotRange.getMinimum().doubleValue()});
        }
        if (!this.yPlotRange.getMinimum().equals(this.yPlotRange.getMaximum())) {
            ValueAxis yAxis = this.yValueScale.references(this.yPlotRange, 2, Math.max(2, this.getImageHeight() / 60));
            this.yReferenceLabels = Arrays.asList(yAxis.getTickLabels());
            this.yReferenceValues = new ArrayDouble(yAxis.getTickValues());
        } else {
            this.yReferenceLabels = Collections.singletonList(this.yPlotRange.getMinimum().toString());
            this.yReferenceValues = new ArrayDouble(new double[]{this.yPlotRange.getMinimum().doubleValue()});
        }
        this.labelFontMetrics = this.g.getFontMetrics(this.labelFont);
        this.xLabelMaxHeight = this.labelFontMetrics.getHeight() - this.labelFontMetrics.getLeading();
        int[] yLabelWidths = new int[this.yReferenceLabels.size()];
        this.yLabelMaxWidth = 0;
        for (int i = 0; i < yLabelWidths.length; ++i) {
            yLabelWidths[i] = this.labelFontMetrics.stringWidth(this.yReferenceLabels.get(i));
            this.yLabelMaxWidth = Math.max(this.yLabelMaxWidth, yLabelWidths[i]);
        }
    }

    protected void calculateGraphArea() {
        int i;
        int areaFromBottom = this.bottomMargin + this.xLabelMaxHeight + this.xLabelMargin;
        int areaFromLeft = this.leftMargin + this.yLabelMaxWidth + this.yLabelMargin;
        this.xPlotValueStart = this.getXPlotRange().getMinimum().doubleValue();
        this.xPlotValueEnd = this.getXPlotRange().getMaximum().doubleValue();
        if (this.xPlotValueStart == this.xPlotValueEnd) {
            this.xPlotValueStart -= 1.0;
            this.xPlotValueEnd += 1.0;
        }
        this.xAreaCoordStart = areaFromLeft;
        this.xAreaCoordEnd = this.getImageWidth() - this.rightMargin;
        this.xPlotCoordStart = (double)(this.xAreaCoordStart + this.leftAreaMargin) + this.xPointMargin;
        this.xPlotCoordEnd = (double)(this.xAreaCoordEnd - this.rightAreaMargin) - this.xPointMargin;
        this.xPlotCoordWidth = this.xPlotCoordEnd - this.xPlotCoordStart;
        this.yPlotValueStart = this.getYPlotRange().getMinimum().doubleValue();
        this.yPlotValueEnd = this.getYPlotRange().getMaximum().doubleValue();
        if (this.yPlotValueStart == this.yPlotValueEnd) {
            this.yPlotValueStart -= 1.0;
            this.yPlotValueEnd += 1.0;
        }
        this.yAreaCoordStart = this.topMargin;
        this.yAreaCoordEnd = this.getImageHeight() - areaFromBottom;
        this.yPlotCoordStart = (double)(this.yAreaCoordStart + this.topAreaMargin) + this.yPointMargin;
        this.yPlotCoordEnd = (double)(this.yAreaCoordEnd - this.bottomAreaMargin) - this.yPointMargin;
        this.yPlotCoordHeight = this.yPlotCoordEnd - this.yPlotCoordStart;
        if (this.xReferenceValues != null) {
            double[] xRefCoords = new double[this.xReferenceValues.size()];
            for (i = 0; i < xRefCoords.length; ++i) {
                xRefCoords[i] = this.scaledX(this.xReferenceValues.getDouble(i));
            }
            this.xReferenceCoords = new ArrayDouble(xRefCoords);
        }
        if (this.yReferenceValues != null) {
            double[] yRefCoords = new double[this.yReferenceValues.size()];
            for (i = 0; i < yRefCoords.length; ++i) {
                yRefCoords[i] = this.scaledY(this.yReferenceValues.getDouble(i));
            }
            this.yReferenceCoords = new ArrayDouble(yRefCoords);
        }
    }

    protected void drawBackground() {
        this.g.setColor(this.backgroundColor);
        this.g.fillRect(0, 0, this.getImageWidth(), this.getImageHeight());
    }

    protected void drawGraphArea() {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawVerticalReferenceLines();
        this.drawHorizontalReferenceLines();
        this.drawYLabels();
        this.drawXLabels();
    }

    private ScaledData scaleNoReduction(ListNumber xValues, ListNumber yValues) {
        return this.scaleNoReduction(xValues, yValues, 0);
    }

    private ScaledData scaleNoReduction(ListNumber xValues, ListNumber yValues, int dataStart) {
        ScaledData scaledData = new ScaledData();
        int dataCount = xValues.size();
        ScaledData.access$102(scaledData, new double[dataCount]);
        ScaledData.access$202(scaledData, new double[dataCount]);
        for (int i = 0; i < scaledData.scaledY.length; ++i) {
            ((ScaledData)scaledData).scaledX[i] = this.scaledX(xValues.getDouble(i));
            ((ScaledData)scaledData).scaledY[i] = this.scaledY(yValues.getDouble(i));
            this.processScaledValue(dataStart + i, xValues.getDouble(i), yValues.getDouble(i), scaledData.scaledX[i], scaledData.scaledY[i]);
        }
        scaledData.end = dataCount;
        return scaledData;
    }

    private ScaledData scaleFirstMaxMinLastReduction(ListNumber xValues, ListNumber yValues, int dataStart) {
        double last;
        if ((double)xValues.size() < this.xPlotCoordWidth * 4.0) {
            return this.scaleNoReduction(xValues, yValues, dataStart);
        }
        ScaledData scaledData = new ScaledData();
        ScaledData.access$102(scaledData, new double[((int)this.xPlotCoordWidth + 1) * 4]);
        ScaledData.access$202(scaledData, new double[((int)this.xPlotCoordWidth + 1) * 4]);
        int cursor = 0;
        int previousPixel = (int)this.scaledX(xValues.getDouble(0));
        double min = last = this.scaledY(yValues.getDouble(0));
        double max = last;
        ((ScaledData)scaledData).scaledX[0] = previousPixel;
        ((ScaledData)scaledData).scaledY[0] = min;
        this.processScaledValue(dataStart, xValues.getDouble(0), yValues.getDouble(0), this.scaledX(xValues.getDouble(0)), last);
        ++cursor;
        for (int i = 1; i < xValues.size(); ++i) {
            double currentScaledX = this.scaledX(xValues.getDouble(i));
            int currentPixel = (int)currentScaledX;
            if (currentPixel == previousPixel) {
                last = this.scaledY(yValues.getDouble(i));
                min = MathIgnoreNaN.min(min, last);
                max = MathIgnoreNaN.max(max, last);
                this.processScaledValue(dataStart + i, xValues.getDouble(i), yValues.getDouble(i), currentScaledX, last);
                continue;
            }
            ((ScaledData)scaledData).scaledX[cursor] = previousPixel;
            ((ScaledData)scaledData).scaledY[cursor] = max;
            ((ScaledData)scaledData).scaledX[++cursor] = previousPixel;
            ((ScaledData)scaledData).scaledY[cursor] = min;
            ((ScaledData)scaledData).scaledX[++cursor] = previousPixel;
            ((ScaledData)scaledData).scaledY[cursor] = last;
            previousPixel = currentPixel;
            min = last = this.scaledY(yValues.getDouble(i));
            max = last;
            ((ScaledData)scaledData).scaledX[++cursor] = currentPixel;
            ((ScaledData)scaledData).scaledY[cursor] = last;
            ++cursor;
        }
        ((ScaledData)scaledData).scaledX[cursor] = previousPixel;
        ((ScaledData)scaledData).scaledY[cursor] = max;
        ((ScaledData)scaledData).scaledX[++cursor] = previousPixel;
        ((ScaledData)scaledData).scaledY[cursor] = min;
        scaledData.end = ++cursor;
        return scaledData;
    }

    protected void processScaledValue(int index, double valueX, double valueY, double scaledX, double scaledY) {
    }

    protected void drawValueLine(ListNumber xValues, ListNumber yValues, InterpolationScheme interpolation) {
        Path2D.Double path;
        ReductionScheme reductionScheme = ReductionScheme.NONE;
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        switch (reductionScheme) {
            default: {
                throw new IllegalArgumentException("Reduction scheme " + (Object)((Object)reductionScheme) + " not supported");
            }
            case NONE: 
        }
        ScaledData scaledData = this.scaleNoReduction(xValues, yValues);
        switch (interpolation) {
            default: {
                path = Graph2DRenderer.nearestNeighbour(scaledData);
                break;
            }
            case LINEAR: {
                path = Graph2DRenderer.linearInterpolation(scaledData);
                break;
            }
            case CUBIC: {
                path = Graph2DRenderer.cubicInterpolation(scaledData);
            }
        }
        this.g.draw(path);
    }

    protected void drawValueExplicitLine(ListNumber xValues, ListNumber yValues, InterpolationScheme interpolation, ReductionScheme reduction) {
        Path2D.Double path;
        ScaledData scaledData;
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int start = ListNumbers.binarySearchValueOrLower((ListNumber)xValues, (double)this.xPlotValueStart);
        int end = ListNumbers.binarySearchValueOrHigher((ListNumber)xValues, (double)this.xPlotValueEnd);
        xValues = ListMath.limit((ListNumber)xValues, (int)start, (int)(end + 1));
        yValues = ListMath.limit((ListNumber)yValues, (int)start, (int)(end + 1));
        switch (reduction) {
            default: {
                throw new IllegalArgumentException("Reduction scheme " + (Object)((Object)reduction) + " not supported");
            }
            case NONE: {
                scaledData = this.scaleNoReduction(xValues, yValues, start);
                break;
            }
            case FIRST_MAX_MIN_LAST: {
                scaledData = this.scaleFirstMaxMinLastReduction(xValues, yValues, start);
            }
        }
        switch (interpolation) {
            default: {
                path = Graph2DRenderer.nearestNeighbour(scaledData);
                break;
            }
            case LINEAR: {
                path = Graph2DRenderer.linearInterpolation(scaledData);
                break;
            }
            case CUBIC: {
                path = Graph2DRenderer.cubicInterpolation(scaledData);
            }
        }
        this.g.draw(path);
    }

    private static Path2D.Double nearestNeighbour(ScaledData scaledData) {
        double[] scaledX = scaledData.scaledX;
        double[] scaledY = scaledData.scaledY;
        int start = scaledData.start;
        int end = scaledData.end;
        Path2D.Double line = new Path2D.Double();
        line.moveTo(scaledX[start], scaledY[start]);
        for (int i = 1; i < end; ++i) {
            double halfX = scaledX[i - 1] + (scaledX[i] - scaledX[i - 1]) / 2.0;
            if (!Double.isNaN(scaledY[i - 1])) {
                line.lineTo(halfX, scaledY[i - 1]);
                if (Double.isNaN(scaledY[i])) continue;
                line.lineTo(halfX, scaledY[i]);
                continue;
            }
            line.moveTo(halfX, scaledY[i]);
        }
        line.lineTo(scaledX[end - 1], scaledY[end - 1]);
        return line;
    }

    private static Path2D.Double linearInterpolation(ScaledData scaledData) {
        double[] scaledX = scaledData.scaledX;
        double[] scaledY = scaledData.scaledY;
        int start = scaledData.start;
        int end = scaledData.end;
        Path2D.Double line = new Path2D.Double();
        line.moveTo(scaledX[start], scaledY[start]);
        for (int i = 1; i < end; ++i) {
            line.lineTo(scaledX[i], scaledY[i]);
        }
        return line;
    }

    private static Path2D.Double cubicInterpolation(ScaledData scaledData) {
        double[] scaledX = scaledData.scaledX;
        double[] scaledY = scaledData.scaledY;
        int start = scaledData.start;
        int end = scaledData.end;
        Path2D.Double path = new Path2D.Double();
        path.moveTo(scaledX[start], scaledY[start]);
        for (int i = 1; i < end; ++i) {
            double x3;
            double y3;
            double x0;
            double y0;
            double y1 = scaledY[i - 1];
            double y2 = scaledY[i];
            double x1 = scaledX[i - 1];
            double x2 = scaledX[i];
            if (i > 1) {
                y0 = scaledY[i - 2];
                x0 = scaledX[i - 2];
            } else {
                y0 = y1 - (y2 - y1) / 2.0;
                x0 = x1 - (x2 - x1);
            }
            if (i < end - 1) {
                y3 = scaledY[i + 1];
                x3 = scaledX[i + 1];
            } else {
                y3 = y2 + (y2 - y1) / 2.0;
                x3 = x2 + (x2 - x1) / 2.0;
            }
            double bx0 = x1;
            double by0 = y1;
            double bx3 = x2;
            double by3 = y2;
            double bdy0 = (y2 - y0) / (x2 - x0);
            double bdy3 = (y3 - y1) / (x3 - x1);
            double bx1 = bx0 + (x2 - x0) / 6.0;
            double by1 = (bx1 - bx0) * bdy0 + by0;
            double bx2 = bx3 - (x3 - x1) / 6.0;
            double by2 = (bx2 - bx3) * bdy3 + by3;
            path.curveTo(bx1, by1, bx2, by2, bx3, by3);
        }
        return path;
    }

    private static void drawHorizontalReferencesLabel(Graphics2D graphics, FontMetrics metrics, String text, int yCenter, int[] drawRange, int xRight, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < yCenter || drawRange[0] > yCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.RIGHT;
        int targetY = yCenter;
        int halfHeight = metrics.getAscent() / 2;
        if (yCenter < drawRange[0] + halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetY = drawRange[0];
        } else if (yCenter > drawRange[1] - halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.BOTTOM_RIGHT;
            targetY = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, xRight, targetY, text);
        if (updateMin) {
            drawRange[1] = targetY - metrics.getHeight();
        } else {
            drawRange[0] = targetY + metrics.getHeight();
        }
    }

    private static void drawVerticalReferenceLabel(Graphics2D graphics, FontMetrics metrics, String text, int xCenter, int[] drawRange, int yTop, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < xCenter || drawRange[0] > xCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.TOP;
        int targetX = xCenter;
        int halfWidth = metrics.stringWidth(text) / 2;
        if (xCenter < drawRange[0] + halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_LEFT;
            targetX = drawRange[0];
        } else if (xCenter > drawRange[1] - halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetX = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, targetX, yTop, text);
        if (updateMin) {
            drawRange[0] = targetX + metrics.getHeight();
        } else {
            drawRange[1] = targetX - metrics.getHeight();
        }
    }

    protected final double scaledX(double value) {
        return this.xValueScale.scaleValue(value, this.xPlotValueStart, this.xPlotValueEnd, this.xPlotCoordStart, this.xPlotCoordEnd);
    }

    protected final double scaledY(double value) {
        return this.yValueScale.scaleValue(value, this.yPlotValueStart, this.yPlotValueEnd, this.yPlotCoordEnd, this.yPlotCoordStart);
    }

    protected void setClip(Graphics2D g) {
        g.setClip(this.xAreaCoordStart, this.yAreaCoordStart, this.xAreaCoordEnd - this.xAreaCoordStart, this.yAreaCoordEnd - this.yAreaCoordStart);
    }

    protected void drawYLabels() {
        ListDouble yTicks = this.yReferenceCoords;
        if (this.yReferenceLabels != null && !this.yReferenceLabels.isEmpty()) {
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{this.yAreaCoordStart, this.yAreaCoordEnd - 1};
            int xRightLabel = this.xAreaCoordStart - this.yLabelMargin - 1;
            Graph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.yReferenceLabels.get(0), (int)Math.floor(yTicks.getDouble(0)), drawRange, xRightLabel, true, false);
            Graph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.yReferenceLabels.get(this.yReferenceLabels.size() - 1), (int)Math.floor(yTicks.getDouble(this.yReferenceLabels.size() - 1)), drawRange, xRightLabel, false, false);
            for (int i = 1; i < this.yReferenceLabels.size() - 1; ++i) {
                Graph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.yReferenceLabels.get(i), (int)Math.floor(yTicks.getDouble(i)), drawRange, xRightLabel, true, false);
            }
        }
    }

    protected void drawXLabels() {
        ListDouble xTicks = this.xReferenceCoords;
        if (this.xReferenceLabels != null && !this.xReferenceLabels.isEmpty()) {
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{this.xAreaCoordStart, this.xAreaCoordEnd - 1};
            int yTop = this.yAreaCoordEnd + this.xLabelMargin;
            Graph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.xReferenceLabels.get(0), (int)Math.floor(xTicks.getDouble(0)), drawRange, yTop, true, false);
            Graph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.xReferenceLabels.get(this.xReferenceLabels.size() - 1), (int)Math.floor(xTicks.getDouble(this.xReferenceLabels.size() - 1)), drawRange, yTop, false, false);
            for (int i = 1; i < this.xReferenceLabels.size() - 1; ++i) {
                Graph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.xReferenceLabels.get(i), (int)Math.floor(xTicks.getDouble(i)), drawRange, yTop, true, false);
            }
        }
    }

    protected void setupDataAsPoints() {
        this.setupXAsPoints();
        this.setupYAsPoints();
    }

    protected void setupXAsPoints() {
        this.xPointMargin = 0.5;
    }

    protected void setupYAsPoints() {
        this.yPointMargin = 0.5;
    }

    protected void setupDataAsAreas() {
        this.setupXAsAreas();
        this.setupYAsAreas();
    }

    protected void setupXAsAreas() {
        this.xPointMargin = 0.0;
    }

    protected void setupYAsAreas() {
        this.yPointMargin = 0.0;
    }

    private static class ScaledData {
        private double[] scaledX;
        private double[] scaledY;
        private int start;
        private int end;

        private ScaledData() {
        }

        static /* synthetic */ double[] access$102(ScaledData x0, double[] x1) {
            x0.scaledX = x1;
            return x1;
        }

        static /* synthetic */ double[] access$202(ScaledData x0, double[] x1) {
            x0.scaledY = x1;
            return x1;
        }
    }
}

