/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.AxisRange;
import org.epics.graphene.AxisRanges;
import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.Cell2DDatasets;
import org.epics.graphene.ColorScheme;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.IntensityGraph2DRendererUpdate;
import org.epics.graphene.Java2DStringUtilities;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;
import org.epics.graphene.ValueAxis;
import org.epics.graphene.ValueColorScheme;
import org.epics.graphene.ValueColorSchemes;
import org.epics.graphene.ValueScale;
import org.epics.graphene.ValueScales;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;

public class IntensityGraph2DRenderer
extends Graph2DRenderer<Graph2DRendererUpdate> {
    private ValueColorScheme colorScheme;
    private int legendWidth = 10;
    private int legendMarginToGraph = 10;
    private int legendMarginToEdge = 2;
    protected int zLabelMargin = 3;
    private boolean drawLegend = false;
    private Range zRange;
    private Range zAggregatedRange;
    private Range zPlotRange;
    private AxisRange zAxisRange = AxisRanges.integrated();
    private ValueScale zValueScale = ValueScales.linearScale();
    protected ListDouble zReferenceCoords;
    protected ListDouble zReferenceValues;
    protected List<String> zReferenceLabels;
    private int zLabelMaxWidth;
    private ColorScheme valueColorScheme = ColorScheme.GRAY_SCALE;
    private static int MIN = 0;
    private static int MAX = 1;

    public IntensityGraph2DRenderer(int imageWidth, int imageHeight) {
        super(imageWidth, imageHeight);
    }

    public IntensityGraph2DRenderer() {
        this(300, 200);
    }

    @Override
    public void update(IntensityGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getDrawLegend() != null) {
            this.drawLegend = update.getDrawLegend();
        }
        if (update.getValueColorScheme() != null) {
            this.valueColorScheme = update.getValueColorScheme();
        }
        if (update.getZLabelMargin() != null) {
            this.zLabelMargin = update.getZLabelMargin();
        }
        if (update.getLegendWidth() != null) {
            this.legendWidth = update.getLegendWidth();
        }
        if (update.getLegendMarginToGraph() != null) {
            this.legendMarginToGraph = update.getLegendMarginToGraph();
        }
        if (update.getLegendMarginToEdge() != null) {
            this.legendMarginToEdge = update.getLegendMarginToEdge();
        }
    }

    public void draw(Graphics2D g, Cell2DDataset data) {
        this.g = g;
        this.calculateRanges(data.getXRange(), data.getYRange());
        this.drawBackground();
        this.calculateLabels();
        if (this.drawLegend) {
            this.zRange = RangeUtil.range(data.getStatistics().getMinimum().doubleValue(), data.getStatistics().getMaximum().doubleValue());
            this.calculateZRange(this.zRange);
            this.calculateZLabels();
            this.rightMargin = this.legendMarginToGraph + this.legendWidth + this.zLabelMargin + this.zLabelMaxWidth + this.legendMarginToEdge;
        }
        this.calculateGraphArea();
        if (this.drawLegend && this.zReferenceValues != null) {
            double[] zRefCoords = new double[this.zReferenceValues.size()];
            if (zRefCoords.length == 1) {
                zRefCoords[0] = Math.max(2, this.getImageHeight() / 60);
            } else {
                for (int i = 0; i < zRefCoords.length; ++i) {
                    zRefCoords[i] = this.scaledZ(this.zReferenceValues.getDouble(i));
                }
            }
            this.zReferenceCoords = new ArrayDouble(zRefCoords);
        }
        this.drawGraphArea();
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.colorScheme = ValueColorSchemes.schemeFor(this.valueColorScheme, data.getStatistics());
        double xStartGraph = this.xPlotCoordStart;
        double yEndGraph = this.yPlotCoordEnd;
        double xWidthTotal = this.xPlotCoordWidth;
        double yHeightTotal = this.yPlotCoordHeight;
        double xRange = data.getXBoundaries().getInt(data.getXCount()) - data.getXBoundaries().getInt(0);
        double yRange = data.getYBoundaries().getInt(data.getYCount()) - data.getYBoundaries().getInt(0);
        double cellHeight = yHeightTotal / (double)data.getYCount();
        double cellWidth = xWidthTotal / (double)data.getXCount();
        if (cellWidth >= 1.0 && cellHeight >= 1.0) {
            this.drawRectangles(g, this.colorScheme, data, xStartGraph, yEndGraph, xWidthTotal, yHeightTotal, cellHeight, cellWidth);
        }
        if (cellWidth < 1.0 || cellHeight < 1.0) {
            if (cellHeight > 1.0) {
                this.drawRectanglesSmallX(g, this.colorScheme, data, xStartGraph, yEndGraph, xWidthTotal, yHeightTotal, cellHeight, cellWidth);
            }
            if (cellWidth > 1.0) {
                this.drawRectanglesSmallY(g, this.colorScheme, data, xStartGraph, yEndGraph, xWidthTotal, yHeightTotal, cellHeight, cellWidth);
            }
            if (cellWidth < 1.0 && cellHeight < 1.0) {
                this.drawRectanglesSmallXAndY(g, this.colorScheme, data, xStartGraph, yEndGraph, xWidthTotal, yHeightTotal, cellHeight, cellWidth);
            }
        }
        if (this.drawLegend && this.legendWidth > 0) {
            ListNumber dataList = ListNumbers.linearListFromRange((double)this.zAggregatedRange.getMinimum().doubleValue(), (double)this.zAggregatedRange.getMaximum().doubleValue(), (int)((int)yHeightTotal));
            Cell2DDataset legendData = Cell2DDatasets.linearRange(dataList, RangeUtil.range(0.0, 1.0), 1, RangeUtil.range(0.0, (int)yHeightTotal), (int)yHeightTotal);
            this.drawRectangles(g, this.colorScheme, legendData, xStartGraph + xWidthTotal + (double)this.legendMarginToGraph + 1.0, yEndGraph, this.legendWidth, yHeightTotal, 1.0, this.legendWidth);
            this.drawZLabels();
        }
    }

    @Override
    public Graph2DRendererUpdate newUpdate() {
        return new IntensityGraph2DRendererUpdate();
    }

    private void drawRectangles(Graphics2D g, ValueColorScheme colorScheme, Cell2DDataset data, double xStartGraph, double yEndGraph, double xWidthTotal, double yHeightTotal, double cellHeight, double cellWidth) {
        double yPosition = yEndGraph - yHeightTotal;
        int yPositionInt = (int)(yEndGraph - yHeightTotal);
        for (int countY = 0; countY < data.getYCount(); ++countY) {
            double xPosition = xStartGraph;
            int xPositionInt = (int)xStartGraph;
            for (int countX = 0; countX < data.getXCount(); ++countX) {
                g.setColor(new Color(colorScheme.colorFor(data.getValue(countX, data.getYCount() - 1 - countY))));
                Rectangle2D.Double currentRectangle = new Rectangle2D.Double(xPositionInt, yPositionInt, (int)cellWidth + 1, (int)cellHeight + 1);
                g.fill(currentRectangle);
                xPositionInt = (int)(xPosition += cellWidth);
            }
            yPositionInt = (int)(yPosition += cellHeight);
        }
    }

    private void drawRectanglesSmallX(Graphics2D g, ValueColorScheme colorScheme, Cell2DDataset data, double xStartGraph, double yEndGraph, double xWidthTotal, double yHeightTotal, double cellHeight, double cellWidth) {
        double xDataPerBox = (double)(data.getXCount() - 1) / xWidthTotal;
        double yPosition = yEndGraph - yHeightTotal;
        int yPositionInt = (int)(yEndGraph - yHeightTotal);
        for (int countY = 0; countY < data.getYCount(); ++countY) {
            double countX = 0.0;
            for (int xPositionInt = (int)xStartGraph; xPositionInt < (int)(xStartGraph + xWidthTotal) + 1; ++xPositionInt) {
                g.setColor(new Color(colorScheme.colorFor(data.getValue((int)countX, data.getYCount() - 1 - countY))));
                Rectangle2D.Double rect = (double)(yPositionInt + (int)cellHeight + 1) - (yPosition + cellHeight) < 1.0 ? new Rectangle2D.Double(xPositionInt, yPositionInt, 1.0, (int)cellHeight + 1) : new Rectangle2D.Double(xPositionInt, yPositionInt, 1.0, (int)cellHeight + 2);
                g.fill(rect);
                countX += xDataPerBox;
            }
            yPositionInt = (int)(yPosition += cellHeight);
        }
    }

    private void drawRectanglesSmallY(Graphics2D g, ValueColorScheme colorScheme, Cell2DDataset data, double xStartGraph, double yEndGraph, double xWidthTotal, double yHeightTotal, double cellHeight, double cellWidth) {
        double yDataPerBox = (double)(data.getYCount() - 1) / yHeightTotal;
        double xPosition = xStartGraph;
        int xPositionInt = (int)xStartGraph;
        for (int countX = 0; countX < data.getXCount(); ++countX) {
            double countY = 0.0;
            for (int yPositionInt = (int)(yEndGraph - yHeightTotal); yPositionInt < (int)yEndGraph + 1; ++yPositionInt) {
                g.setColor(new Color(colorScheme.colorFor(data.getValue(countX, data.getYCount() - 1 - (int)countY))));
                Rectangle2D.Double rect = (double)(xPositionInt + (int)cellWidth + 1) - (xPosition + cellWidth) < 1.0 ? new Rectangle2D.Double(xPositionInt, yPositionInt, (int)cellWidth + 1, 1.0) : new Rectangle2D.Double(xPositionInt, yPositionInt, (int)cellWidth + 2, 1.0);
                g.fill(rect);
                countY += yDataPerBox;
            }
            xPositionInt = (int)(xPosition += cellWidth);
        }
    }

    private void drawRectanglesSmallXAndY(Graphics2D g, ValueColorScheme colorScheme, Cell2DDataset data, double xStartGraph, double yEndGraph, double xWidthTotal, double yHeightTotal, double cellHeight, double cellWidth) {
        double countY = 0.0;
        double yDataPerBox = (double)(data.getYCount() - 1) / yHeightTotal;
        double xDataPerBox = (double)(data.getXCount() - 1) / xWidthTotal;
        for (int yPositionInt = (int)(yEndGraph - yHeightTotal); yPositionInt < (int)yEndGraph + 1; ++yPositionInt) {
            double countX = 0.0;
            for (int xPositionInt = (int)xStartGraph; xPositionInt < (int)(xStartGraph + xWidthTotal) + 1; ++xPositionInt) {
                g.setColor(new Color(colorScheme.colorFor(data.getValue((int)countX, data.getYCount() - 1 - (int)countY))));
                Rectangle2D.Double rect = new Rectangle2D.Double(xPositionInt, yPositionInt, 1.0, 1.0);
                g.fill(rect);
                countX += xDataPerBox;
            }
            countY += yDataPerBox;
        }
    }

    protected void calculateZRange(Range zDataRange) {
        this.zAggregatedRange = IntensityGraph2DRenderer.aggregateRange(zDataRange, this.zAggregatedRange);
        this.zPlotRange = this.zAxisRange.axisRange(zDataRange, this.zAggregatedRange);
    }

    protected void calculateZLabels() {
        ValueAxis zAxis;
        if (!this.zPlotRange.getMinimum().equals(this.zPlotRange.getMaximum())) {
            zAxis = this.zValueScale.references(this.zPlotRange, 2, Math.max(2, this.getImageHeight() / 60));
            this.zReferenceLabels = Arrays.asList(zAxis.getTickLabels());
            this.zReferenceValues = new ArrayDouble(zAxis.getTickValues());
        } else {
            zAxis = this.zValueScale.references(this.zPlotRange, 1, 1);
            this.zReferenceLabels = Arrays.asList(zAxis.getTickLabels());
            this.zReferenceValues = new ArrayDouble(new double[]{this.zPlotRange.getMinimum().doubleValue()});
        }
        int[] zLabelWidths = new int[this.zReferenceLabels.size()];
        this.zLabelMaxWidth = 0;
        for (int i = 0; i < zLabelWidths.length; ++i) {
            zLabelWidths[i] = this.labelFontMetrics.stringWidth(this.zReferenceLabels.get(i));
            this.zLabelMaxWidth = Math.max(this.zLabelMaxWidth, zLabelWidths[i]);
        }
    }

    protected void drawZLabels() {
        ListDouble zTicks = this.zReferenceCoords;
        if (this.zReferenceLabels != null && !this.zReferenceLabels.isEmpty()) {
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{this.yAreaCoordStart, this.yAreaCoordEnd - 1};
            int xRightLabel = this.getImageWidth() - this.legendMarginToEdge - 1;
            IntensityGraph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.zReferenceLabels.get(0), (int)Math.floor(zTicks.getDouble(0)), drawRange, xRightLabel, true, false);
            IntensityGraph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.zReferenceLabels.get(this.zReferenceLabels.size() - 1), (int)Math.floor(zTicks.getDouble(this.zReferenceLabels.size() - 1)), drawRange, xRightLabel, false, false);
            for (int i = 1; i < this.zReferenceLabels.size() - 1; ++i) {
                IntensityGraph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.zReferenceLabels.get(i), (int)Math.floor(zTicks.getDouble(i)), drawRange, xRightLabel, true, false);
            }
        }
    }

    private static void drawHorizontalReferencesLabel(Graphics2D graphics, FontMetrics metrics, String text, int yCenter, int[] drawRange, int xRight, boolean updateMin, boolean centeredOnly) {
        if (drawRange[MAX] < yCenter || drawRange[MIN] > yCenter) {
            return;
        }
        if (drawRange[MAX] - drawRange[MIN] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.RIGHT;
        int targetY = yCenter;
        int halfHeight = metrics.getAscent() / 2;
        if (yCenter < drawRange[MIN] + halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetY = drawRange[MIN];
        } else if (yCenter > drawRange[MAX] - halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.BOTTOM_RIGHT;
            targetY = drawRange[MAX];
        }
        Java2DStringUtilities.drawString(graphics, alignment, xRight, targetY, text);
        if (updateMin) {
            drawRange[IntensityGraph2DRenderer.MAX] = targetY - metrics.getHeight();
        } else {
            drawRange[IntensityGraph2DRenderer.MIN] = targetY + metrics.getHeight();
        }
    }

    protected final double scaledZ(double value) {
        return this.zValueScale.scaleValue(value, this.zPlotRange.getMinimum().doubleValue(), this.zPlotRange.getMaximum().doubleValue(), this.yPlotCoordEnd, this.yPlotCoordStart);
    }
}

