/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.LineTimeGraph2DRendererUpdate;
import org.epics.graphene.TemporalGraph2DRenderer;
import org.epics.graphene.TimeSeriesDataset;
import org.epics.util.array.ListNumber;

public class LineTimeGraph2DRenderer
extends TemporalGraph2DRenderer<LineTimeGraph2DRendererUpdate> {
    public static List<InterpolationScheme> supportedInterpolationScheme = Arrays.asList(InterpolationScheme.NEAREST_NEIGHBOUR, InterpolationScheme.PREVIOUS_VALUE, InterpolationScheme.LINEAR, InterpolationScheme.CUBIC);
    private InterpolationScheme interpolation = InterpolationScheme.NEAREST_NEIGHBOUR;

    @Override
    public LineTimeGraph2DRendererUpdate newUpdate() {
        return new LineTimeGraph2DRendererUpdate();
    }

    public LineTimeGraph2DRenderer(int imageWidth, int imageHeight) {
        super(imageWidth, imageHeight);
    }

    public InterpolationScheme getInterpolation() {
        return this.interpolation;
    }

    @Override
    public void update(LineTimeGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getInterpolation() != null) {
            this.interpolation = update.getInterpolation();
        }
    }

    public void draw(Graphics2D g, TimeSeriesDataset data) {
        this.g = g;
        this.calculateRanges(data.getStatistics(), data.getTimeInterval());
        this.calculateGraphArea();
        this.drawBackground();
        this.drawGraphArea();
        ListNumber xValues = data.getNormalizedTime();
        ListNumber yValues = data.getValues();
        this.setClip(g);
        g.setColor(Color.BLACK);
        this.drawValueLine(xValues, yValues, this.interpolation);
    }
}

