/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.ColorScheme;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.MultilineGraph2DRendererUpdate;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;
import org.epics.graphene.ReductionScheme;
import org.epics.graphene.ValueColorScheme;
import org.epics.graphene.ValueColorSchemes;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.array.SortedListView;

public class MultilineGraph2DRenderer
extends Graph2DRenderer {
    private ValueColorScheme colorScheme;
    private ColorScheme valueColorScheme = ColorScheme.GRAY_SCALE;
    public static List<InterpolationScheme> supportedInterpolationScheme = Arrays.asList(InterpolationScheme.NEAREST_NEIGHBOUR, InterpolationScheme.LINEAR, InterpolationScheme.CUBIC);
    public static List<ReductionScheme> supportedReductionScheme = Arrays.asList(ReductionScheme.FIRST_MAX_MIN_LAST, ReductionScheme.NONE);
    private InterpolationScheme interpolation = InterpolationScheme.LINEAR;

    public MultilineGraph2DRenderer(int imageWidth, int imageHeight) {
        super(imageWidth, imageHeight);
    }

    public void draw(Graphics2D g, List<Point2DDataset> data) {
        this.g = g;
        for (Point2DDataset dataPiece : data) {
            super.calculateRanges(dataPiece.getXStatistics(), dataPiece.getYStatistics());
        }
        this.calculateLabels();
        this.calculateGraphArea();
        this.drawBackground();
        this.drawGraphArea();
        Range datasetRange = RangeUtil.range(0.0, data.size());
        this.colorScheme = ValueColorSchemes.schemeFor(this.valueColorScheme, datasetRange);
        for (int datasetNumber = 0; datasetNumber < data.size(); ++datasetNumber) {
            SortedListView xValues = ListNumbers.sortedView((ListNumber)data.get(datasetNumber).getXValues());
            SortedListView yValues = ListNumbers.sortedView((ListNumber)data.get(datasetNumber).getYValues(), (ListInt)xValues.getIndexes());
            this.setClip(g);
            g.setColor(new Color(this.colorScheme.colorFor(datasetNumber)));
            this.drawValueExplicitLine((ListNumber)xValues, (ListNumber)yValues, this.interpolation, ReductionScheme.FIRST_MAX_MIN_LAST);
        }
    }

    public void update(MultilineGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getValueColorScheme() != null) {
            this.valueColorScheme = update.getValueColorScheme();
        }
    }

    public Graph2DRendererUpdate newUpdate() {
        return new MultilineGraph2DRendererUpdate();
    }
}

