/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.ReductionScheme;
import org.epics.graphene.SparklineGraph2DRendererUpdate;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.array.SortedListView;

public class SparklineGraph2DRenderer
extends Graph2DRenderer<SparklineGraph2DRendererUpdate> {
    private int circleDiameter = 3;
    private Color minValueColor = new Color(28, 160, 232);
    private Color maxValueColor = new Color(28, 160, 232);
    private Color firstValueColor = new Color(223, 59, 73);
    private Color lastValueColor = new Color(223, 59, 73);
    private boolean drawCircles = true;
    private int maxIndex;
    private int minIndex;
    private int firstIndex;
    private int lastIndex;
    private double maxValueY = -1.0;
    private double minValueY = -1.0;
    private double firstValueY = -1.0;
    private double lastValueY = -1.0;
    private Double aspectRatio = null;
    public static List<InterpolationScheme> supportedInterpolationScheme = Arrays.asList(InterpolationScheme.NEAREST_NEIGHBOUR, InterpolationScheme.LINEAR, InterpolationScheme.CUBIC);
    private InterpolationScheme interpolation = InterpolationScheme.LINEAR;

    public SparklineGraph2DRenderer(int imageWidth, int imageHeight) {
        super(imageWidth, imageHeight);
        this.xLabelMargin = 0;
        this.yLabelMargin = 0;
        this.rightMargin = 0;
        this.leftMargin = 0;
        this.bottomMargin = 0;
        this.topMargin = 0;
        this.leftAreaMargin = 1;
        this.rightAreaMargin = 1;
        this.bottomAreaMargin = 1;
        this.topAreaMargin = 1;
    }

    public void draw(Graphics2D g, Point2DDataset data) {
        this.g = g;
        if (this.aspectRatio != null) {
            this.adjustGraphToAspectRatio();
        }
        this.calculateRanges(data.getXStatistics(), data.getYStatistics());
        this.calculateGraphArea();
        this.drawBackground();
        g.setColor(Color.BLACK);
        SortedListView xValues = ListNumbers.sortedView((ListNumber)data.getXValues());
        SortedListView yValues = ListNumbers.sortedView((ListNumber)data.getYValues(), (ListInt)xValues.getIndexes());
        this.setClip(g);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawValueExplicitLine((ListNumber)xValues, (ListNumber)yValues, this.interpolation, ReductionScheme.FIRST_MAX_MIN_LAST);
        if (this.drawCircles) {
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.7f);
            g.setComposite(ac);
            if (!this.hasOverlapMinimum()) {
                this.drawCircle(g, data, this.minIndex, this.minValueColor);
            }
            if (!this.hasOverlapMaximum()) {
                this.drawCircle(g, data, this.maxIndex, this.maxValueColor);
            }
            this.drawCircle(g, data, this.firstIndex, this.firstValueColor);
            this.drawCircle(g, data, this.lastIndex, this.lastValueColor);
        }
    }

    private boolean hasOverlapMinimum() {
        return this.minIndex == this.lastIndex || this.minIndex == this.firstIndex;
    }

    private boolean hasOverlapMaximum() {
        return this.maxIndex == this.lastIndex || this.maxIndex == this.firstIndex;
    }

    protected void drawCircle(Graphics2D g, Point2DDataset data, int index, Color color) {
        double x = Math.floor(this.scaledX(data.getXValues().getDouble(index))) + 0.5;
        double y = Math.floor(this.scaledY(data.getYValues().getDouble(index))) + 0.5;
        g.setColor(color);
        Shape circle = this.createShape(x, y, this.circleDiameter);
        g.fill(circle);
    }

    protected Shape createShape(double x, double y, double size) {
        double halfSize = size / 2.0;
        Ellipse2D.Double circle = new Ellipse2D.Double(x - halfSize, y - halfSize, size, size);
        return circle;
    }

    @Override
    protected void processScaledValue(int index, double valueX, double valueY, double scaledX, double scaledY) {
        if (index == 0) {
            this.firstIndex = 0;
            this.firstValueY = valueY;
            this.maxValueY = valueY;
            this.minValueY = valueY;
        } else {
            if (this.maxValueY <= valueY) {
                this.maxValueY = valueY;
                this.maxIndex = index;
            }
            if (this.minValueY >= valueY) {
                this.minValueY = valueY;
                this.minIndex = index;
            }
        }
        this.lastValueY = valueY;
        this.lastIndex = index;
    }

    @Override
    public void update(SparklineGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getMinValueColor() != null) {
            this.minValueColor = update.getMinValueColor();
        }
        if (update.getMaxValueColor() != null) {
            this.maxValueColor = update.getMaxValueColor();
        }
        if (update.getCircleDiameter() != null) {
            this.circleDiameter = update.getCircleDiameter();
        }
        if (update.getDrawCircles() != null) {
            this.drawCircles = update.getDrawCircles();
        }
        if (update.getInterpolation() != null) {
            this.interpolation = update.getInterpolation();
        }
        if (update.getAspectRatio() != null) {
            this.aspectRatio = update.getAspectRatio();
        }
    }

    @Override
    public SparklineGraph2DRendererUpdate newUpdate() {
        return new SparklineGraph2DRendererUpdate();
    }

    public InterpolationScheme getInterpolation() {
        return this.interpolation;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public double getMaxValue() {
        return this.maxValueY;
    }

    public double getMinValue() {
        return this.minValueY;
    }

    public double getFirstValue() {
        return this.firstValueY;
    }

    public double getLastValue() {
        return this.lastValueY;
    }

    public boolean getDrawCircles() {
        return this.drawCircles;
    }

    public Color getMinValueColor() {
        return this.minValueColor;
    }

    public Color getMaxValueColor() {
        return this.maxValueColor;
    }

    public Color getLastValueColor() {
        return this.lastValueColor;
    }

    public int getCircleDiameter() {
        return this.circleDiameter;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    private void adjustGraphToAspectRatio() {
        int relevantHeight = super.getImageHeight() - this.bottomMargin - this.topMargin;
        int relevantWidth = super.getImageWidth() - this.rightMargin - this.leftMargin;
        this.rightAreaMargin = 1;
        this.leftAreaMargin = 1;
        this.topAreaMargin = 1;
        this.bottomAreaMargin = 1;
        if ((double)relevantHeight * this.aspectRatio <= (double)relevantWidth) {
            double preferredWidth = (double)relevantHeight * this.aspectRatio;
            int marginSize = (int)((double)relevantWidth - preferredWidth) / 2;
            this.rightAreaMargin = 1 + marginSize;
            this.leftAreaMargin = 1 + marginSize;
        } else {
            double preferredHeight = (double)relevantWidth / this.aspectRatio;
            int marginSize = (int)((double)relevantHeight - preferredHeight) / 2;
            this.topAreaMargin = 1 + marginSize;
            this.bottomAreaMargin = 1 + marginSize;
        }
    }
}

