/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.util.ArrayList;
import org.epics.graphene.ColorScheme;
import org.epics.graphene.NumberUtil;
import org.epics.graphene.Range;
import org.epics.graphene.ValueColorScheme;

public class ValueColorSchemes {
    private ValueColorSchemes() {
    }

    public static ValueColorScheme schemeFor(ColorScheme color, Range range) {
        if (range == null) {
            throw new NullPointerException("The range cannot be null.");
        }
        switch (color) {
            case GRAY_SCALE: {
                return ValueColorSchemes.grayScale(range);
            }
            case JET: {
                return ValueColorSchemes.jetScale(range);
            }
            case HOT: {
                return ValueColorSchemes.hotScale(range);
            }
            case COOL: {
                return ValueColorSchemes.coolScale(range);
            }
            case SPRING: {
                return ValueColorSchemes.springScale(range);
            }
            case BONE: {
                return ValueColorSchemes.boneScale(range);
            }
            case COPPER: {
                return ValueColorSchemes.copperScale(range);
            }
            case PINK: {
                return ValueColorSchemes.pinkScale(range);
            }
        }
        return ValueColorSchemes.grayScale(range);
    }

    public static ValueColorScheme grayScale(Range range) {
        return ValueColorSchemes.singleRangeGradient(range, Color.BLACK, Color.WHITE, Color.RED);
    }

    public static ValueColorScheme jetScale(Range range) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(0, 0, 138));
        colors.add(Color.BLUE);
        colors.add(Color.CYAN);
        colors.add(Color.YELLOW);
        colors.add(Color.RED);
        colors.add(new Color(138, 0, 0));
        colors.add(Color.BLACK);
        return ValueColorSchemes.RangeGradient(range, colors, ValueColorSchemes.percentageRange(colors.size() - 2));
    }

    public static ValueColorScheme hotScale(Range range) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(30, 0, 0));
        colors.add(Color.RED);
        colors.add(Color.YELLOW);
        colors.add(Color.WHITE);
        colors.add(Color.BLUE);
        return ValueColorSchemes.RangeGradient(range, colors, ValueColorSchemes.percentageRange(colors.size() - 2));
    }

    public static ValueColorScheme coolScale(Range range) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.CYAN);
        colors.add(Color.MAGENTA);
        colors.add(Color.RED);
        return ValueColorSchemes.RangeGradient(range, colors, ValueColorSchemes.percentageRange(colors.size() - 2));
    }

    public static ValueColorScheme springScale(Range range) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.MAGENTA);
        colors.add(Color.YELLOW);
        colors.add(Color.RED);
        return ValueColorSchemes.RangeGradient(range, colors, ValueColorSchemes.percentageRange(colors.size() - 2));
    }

    public static ValueColorScheme boneScale(Range range) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.BLACK);
        colors.add(new Color(44, 37, 101));
        colors.add(new Color(107, 115, 140));
        colors.add(new Color(158, 203, 205));
        colors.add(Color.WHITE);
        colors.add(Color.RED);
        return ValueColorSchemes.RangeGradient(range, colors, ValueColorSchemes.percentageRange(colors.size() - 2));
    }

    public static ValueColorScheme copperScale(Range range) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.BLACK);
        colors.add(new Color(66, 41, 24));
        colors.add(new Color(173, 107, 68));
        colors.add(new Color(239, 148, 90));
        colors.add(new Color(255, 198, 123));
        colors.add(Color.RED);
        return ValueColorSchemes.RangeGradient(range, colors, ValueColorSchemes.percentageRange(colors.size() - 2));
    }

    public static ValueColorScheme pinkScale(Range range) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(57, 0, 0));
        colors.add(new Color(189, 123, 123));
        colors.add(new Color(214, 189, 156));
        colors.add(Color.WHITE);
        colors.add(Color.RED);
        return ValueColorSchemes.RangeGradient(range, colors, ValueColorSchemes.percentageRange(colors.size() - 2));
    }

    public static ValueColorScheme singleRangeGradient(final Range range, final Color minValueColor, final Color maxValueColor, final Color nanColor) {
        if (range == null) {
            throw new NullPointerException("Range should not be null");
        }
        if (minValueColor == null) {
            throw new NullPointerException("The minimum color value should not be null");
        }
        if (maxValueColor == null) {
            throw new NullPointerException("The maximum color value should not be null");
        }
        if (nanColor == null) {
            throw new NullPointerException("The 'not a number' default color value should not be null");
        }
        return new ValueColorScheme(){

            @Override
            public int colorFor(double value) {
                if (Double.isNaN(value)) {
                    return nanColor.getRGB();
                }
                double normalValue = NumberUtil.normalize(value, range.getMinimum().doubleValue(), range.getMaximum().doubleValue());
                normalValue = Math.min(normalValue, 1.0);
                normalValue = Math.max(normalValue, 0.0);
                int alpha = 255;
                int red = (int)((double)minValueColor.getRed() + (double)(maxValueColor.getRed() - minValueColor.getRed()) * normalValue);
                int green = (int)((double)minValueColor.getGreen() + (double)(maxValueColor.getGreen() - minValueColor.getGreen()) * normalValue);
                int blue = (int)((double)minValueColor.getBlue() + (double)(maxValueColor.getBlue() - minValueColor.getBlue()) * normalValue);
                return alpha << 24 | red << 16 | green << 8 | blue;
            }
        };
    }

    public static ValueColorScheme RangeGradient(final Range range, final ArrayList<Color> colors, final ArrayList<Double> percentages) {
        return new ValueColorScheme(){
            private Color nanColor;
            {
                this.nanColor = (Color)colors.get(colors.size() - 1);
            }

            @Override
            public int colorFor(double value) {
                if (Double.isNaN(value)) {
                    return this.nanColor.getRGB();
                }
                if (range == null) {
                    throw new NullPointerException("range can not be null.");
                }
                double fullRange = range.getMaximum().doubleValue() - range.getMinimum().doubleValue();
                int alpha = 0;
                int red = 0;
                int green = 0;
                int blue = 0;
                if (fullRange > 0.0) {
                    for (int i = 0; i < percentages.size() - 1; ++i) {
                        if (!(range.getMinimum().doubleValue() + (Double)percentages.get(i) * fullRange <= value) || !(value <= range.getMinimum().doubleValue() + (Double)percentages.get(i + 1) * fullRange)) continue;
                        double normalValue = NumberUtil.normalize(value, range.getMinimum().doubleValue() + (Double)percentages.get(i) * fullRange, range.getMinimum().doubleValue() + (Double)percentages.get(i + 1) * fullRange);
                        normalValue = Math.min(normalValue, 1.0);
                        normalValue = Math.max(normalValue, 0.0);
                        alpha = 255;
                        red = (int)((double)((Color)colors.get(i)).getRed() + (double)(((Color)colors.get(i + 1)).getRed() - ((Color)colors.get(i)).getRed()) * normalValue);
                        green = (int)((double)((Color)colors.get(i)).getGreen() + (double)(((Color)colors.get(i + 1)).getGreen() - ((Color)colors.get(i)).getGreen()) * normalValue);
                        blue = (int)((double)((Color)colors.get(i)).getBlue() + (double)(((Color)colors.get(i + 1)).getBlue() - ((Color)colors.get(i)).getBlue()) * normalValue);
                    }
                } else {
                    for (int i = 0; i < percentages.size() - 1; ++i) {
                        if (!((Double)percentages.get(i) <= 0.5) || !(0.5 <= (Double)percentages.get(i + 1))) continue;
                        double normalValue = 0.0;
                        normalValue = Math.min(normalValue, 1.0);
                        normalValue = Math.max(normalValue, 0.0);
                        alpha = 255;
                        red = (int)((double)((Color)colors.get(i)).getRed() + (double)(((Color)colors.get(i + 1)).getRed() - ((Color)colors.get(i)).getRed()) * normalValue);
                        green = (int)((double)((Color)colors.get(i)).getGreen() + (double)(((Color)colors.get(i + 1)).getGreen() - ((Color)colors.get(i)).getGreen()) * normalValue);
                        blue = (int)((double)((Color)colors.get(i)).getBlue() + (double)(((Color)colors.get(i + 1)).getBlue() - ((Color)colors.get(i)).getBlue()) * normalValue);
                    }
                }
                return alpha << 24 | red << 16 | green << 8 | blue;
            }
        };
    }

    private static ArrayList<Double> percentageRange(int size) {
        ArrayList<Double> percentages = new ArrayList<Double>();
        percentages.add(0.0);
        for (int i = 1; i <= size; ++i) {
            percentages.add((double)i / (double)size);
        }
        return percentages;
    }
}

